/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.common.AsyncFoldLeft;
import org.cometd.common.HashMapMessage;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.LocalSessionImpl;
import org.cometd.server.ServerChannelImpl;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSessionImpl
implements ServerSession,
Dumpable {
    private static final AtomicLong _idCount = new AtomicLong();
    private static final Logger _logger = LoggerFactory.getLogger(ServerSession.class);
    private final BayeuxServerImpl _bayeux;
    private final String _id;
    private final List<ServerSession.ServerSessionListener> _listeners = new CopyOnWriteArrayList<ServerSession.ServerSessionListener>();
    private final List<ServerSession.Extension> _extensions = new CopyOnWriteArrayList<ServerSession.Extension>();
    private final Queue<ServerMessage> _queue = new ArrayDeque<ServerMessage>();
    private final LocalSessionImpl _localSession;
    private final AttributesMap _attributes = new AttributesMap();
    private final Set<ServerChannelImpl> subscriptions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final LazyTask _lazyTask = new LazyTask();
    private AbstractServerTransport.Scheduler _scheduler = new AbstractServerTransport.Scheduler.None(0L);
    private ServerTransport _transport;
    private ServerTransport _advisedTransport;
    private Object _endPoint;
    private State _state = State.NEW;
    private int _maxQueue = -1;
    private long _transientTimeout = -1L;
    private long _transientInterval = -1L;
    private long _timeout = -1L;
    private long _interval = -1L;
    private long _maxInterval = -1L;
    private long _maxProcessing = -1L;
    private long _maxLazy = -1L;
    private boolean _metaConnectDelivery;
    private int _batch;
    private String _userAgent;
    private long _messageTime;
    private long _expireTime;
    private boolean _nonLazyMessages;
    private boolean _broadcastToPublisher;
    private boolean _allowMessageDeliveryDuringHandshake;
    private String _browserId;

    public ServerSessionImpl(BayeuxServerImpl bayeux) {
        this(bayeux, null, null);
    }

    public ServerSessionImpl(BayeuxServerImpl bayeux, LocalSessionImpl localSession, String idHint) {
        this._bayeux = bayeux;
        this._localSession = localSession;
        StringBuilder id = new StringBuilder(30);
        int len = 20;
        if (idHint != null) {
            len += idHint.length() + 1;
            id.append(idHint);
            id.append('_');
        }
        int index = id.length();
        while (id.length() < len) {
            id.append(Long.toString(this._bayeux.randomLong(), 36));
        }
        id.insert(index, Long.toString(_idCount.incrementAndGet(), 36));
        this._id = id.toString();
        this._broadcastToPublisher = this._bayeux.isBroadcastToPublisher();
    }

    public BayeuxServerImpl getBayeuxServer() {
        return this._bayeux;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public void setUserAgent(String userAgent) {
        this._userAgent = userAgent;
    }

    public String getBrowserId() {
        return this._browserId;
    }

    public void setBrowserId(String browserId) {
        this._browserId = browserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sweep(long now) {
        if (this.isLocalSession()) {
            return false;
        }
        boolean remove = false;
        AbstractServerTransport.Scheduler scheduler = null;
        Object object = this.getLock();
        synchronized (object) {
            if (this._expireTime == 0L) {
                if (this._maxProcessing > 0L && now - this._messageTime > this._maxProcessing) {
                    _logger.info("Sweeping during processing {}", (Object)this);
                    remove = true;
                }
            } else if (now - this._expireTime > 0L) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Sweeping {}", (Object)this);
                }
                remove = true;
            }
            if (remove) {
                scheduler = this._scheduler;
            }
        }
        if (remove) {
            scheduler.destroy();
            this._bayeux.removeServerSession(this, true);
            return true;
        }
        return false;
    }

    public Set<ServerChannel> getSubscriptions() {
        return Collections.unmodifiableSet(this.subscriptions);
    }

    public void addExtension(ServerSession.Extension extension) {
        this._extensions.add(extension);
    }

    public void removeExtension(ServerSession.Extension extension) {
        this._extensions.remove(extension);
    }

    public List<ServerSession.Extension> getExtensions() {
        return Collections.unmodifiableList(this._extensions);
    }

    public void batch(Runnable batch) {
        this.startBatch();
        try {
            batch.run();
        }
        finally {
            this.endBatch();
        }
    }

    public void deliver(Session sender, ServerMessage.Mutable message, Promise<Boolean> promise) {
        ServerSession session = null;
        if (sender instanceof ServerSession) {
            session = (ServerSession)sender;
        } else if (sender instanceof LocalSession) {
            session = ((LocalSession)sender).getServerSession();
        }
        ServerSession serverSession = session;
        this._bayeux.extendOutgoing(serverSession, this, message, (Promise<Boolean>)Promise.from(b -> {
            if (b.booleanValue()) {
                this.deliver1(serverSession, message, promise);
            } else {
                promise.succeed((Object)false);
            }
        }, arg_0 -> promise.fail(arg_0)));
    }

    public void deliver(Session sender, String channelId, Object data, Promise<Boolean> promise) {
        ServerMessage.Mutable message = this._bayeux.newMessage();
        message.setChannel(channelId);
        message.setData(data);
        this.deliver(sender, message, promise);
    }

    protected void deliver1(ServerSession sender, ServerMessage.Mutable mutable, Promise<Boolean> promise) {
        if (sender == this && !this.isBroadcastToPublisher() && ChannelId.isBroadcast((String)mutable.getChannel())) {
            promise.succeed((Object)false);
        } else {
            this.extendOutgoing(sender, mutable, (Promise<ServerMessage.Mutable>)Promise.from(message -> {
                if (message == null) {
                    promise.succeed((Object)false);
                } else {
                    this._bayeux.freeze((ServerMessage.Mutable)message);
                    AsyncFoldLeft.run(this._listeners, (Object)true, (result, listener, loop) -> {
                        if (listener instanceof ServerSession.MessageListener) {
                            this.notifyOnMessage((ServerSession.MessageListener)listener, sender, (ServerMessage)message, this._bayeux.resolveLoop((AsyncFoldLeft.Loop<Boolean>)loop));
                        } else {
                            loop.proceed(result);
                        }
                    }, (Promise)Promise.from(b -> {
                        if (b.booleanValue()) {
                            this.deliver2(sender, (ServerMessage.Mutable)message, promise);
                        } else {
                            promise.succeed((Object)false);
                        }
                    }, arg_0 -> ((Promise)promise).fail(arg_0)));
                }
            }, arg_0 -> promise.fail(arg_0)));
        }
    }

    private void deliver2(ServerSession sender, ServerMessage.Mutable message, Promise<Boolean> promise) {
        Boolean wakeup = this.enqueueMessage(sender, message);
        if (wakeup == null) {
            promise.succeed((Object)false);
        } else {
            if (wakeup.booleanValue()) {
                if (message.isLazy()) {
                    this.flushLazy((ServerMessage)message);
                } else {
                    this.flush();
                }
            }
            promise.succeed((Object)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean enqueueMessage(ServerSession sender, ServerMessage.Mutable message) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isTerminated() && !ChannelId.isMeta((String)message.getChannel())) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Dropping message {} for terminated {}", (Object)message, (Object)this);
                }
                return null;
            }
            for (ServerSession.ServerSessionListener listener : this._listeners) {
                int maxQueueSize;
                if (!(listener instanceof ServerSession.QueueMaxedListener) || (maxQueueSize = this._maxQueue) <= 0 || this._queue.size() < maxQueueSize || this.notifyQueueMaxed((ServerSession.QueueMaxedListener)listener, this, this._queue, sender, (ServerMessage)message)) continue;
                return null;
            }
            this.addMessage((ServerMessage)message);
            for (ServerSession.ServerSessionListener listener : this._listeners) {
                if (!(listener instanceof ServerSession.QueueListener)) continue;
                this.notifyQueued((ServerSession.QueueListener)listener, sender, (ServerMessage)message);
            }
            return this._batch == 0;
        }
    }

    protected void extendOutgoing(ServerSession sender, ServerMessage.Mutable message, Promise<ServerMessage.Mutable> promise) {
        AsyncFoldLeft.reverseRun(this._extensions, (Object)message, (result, extension, loop) -> {
            try {
                extension.outgoing(sender, (ServerSession)this, result, Promise.from(m -> {
                    if (m != null) {
                        loop.proceed(m);
                    } else {
                        loop.leave(null);
                    }
                }, failure -> {
                    _logger.info("Exception reported by extension " + extension, failure);
                    loop.proceed(result);
                }));
            }
            catch (Throwable x) {
                _logger.info("Exception thrown by extension " + extension, x);
                loop.proceed(result);
            }
        }, promise);
    }

    private boolean notifyQueueMaxed(ServerSession.QueueMaxedListener listener, ServerSession session, Queue<ServerMessage> queue, ServerSession sender, ServerMessage message) {
        try {
            return listener.queueMaxed(session, queue, sender, message);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking listener " + listener, x);
            return true;
        }
    }

    private void notifyOnMessage(ServerSession.MessageListener listener, ServerSession sender, ServerMessage message, Promise<Boolean> promise) {
        try {
            listener.onMessage((ServerSession)this, sender, message, Promise.from(arg_0 -> promise.succeed(arg_0), failure -> {
                _logger.info("Exception reported by listener " + listener, failure);
                promise.succeed((Object)true);
            }));
        }
        catch (Throwable x) {
            _logger.info("Exception thrown by listener " + listener, x);
            promise.succeed((Object)true);
        }
    }

    private void notifyQueued(ServerSession.QueueListener listener, ServerSession session, ServerMessage message) {
        try {
            listener.queued(session, message);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking listener " + listener, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handshake(ServerMessage.Mutable message) {
        AbstractServerTransport transport;
        AbstractServerTransport abstractServerTransport = transport = message == null ? null : (AbstractServerTransport)message.getServerTransport();
        if (transport != null) {
            this._maxQueue = transport.getOption("maxQueue", -1);
            this._maxProcessing = transport.getOption("maxProcessing", -1);
            if (this._maxProcessing > 0L) {
                this._maxProcessing = TimeUnit.MILLISECONDS.toNanos(this._maxProcessing);
            }
            this._maxLazy = transport.getMaxLazyTimeout();
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this._state == State.NEW) {
                this._state = State.HANDSHAKEN;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean connected() {
        Object object = this.getLock();
        synchronized (object) {
            if (this._state == State.HANDSHAKEN || this._state == State.CONNECTED) {
                this._state = State.CONNECTED;
                return true;
            }
            return false;
        }
    }

    public void disconnect() {
        boolean connected = this._bayeux.removeServerSession(this, false);
        if (connected) {
            ServerMessage.Mutable message = this._bayeux.newMessage();
            message.setSuccessful(true);
            message.setChannel("/meta/disconnect");
            this.deliver((Session)this, message, new Promise<Boolean>(){

                public void succeed(Boolean result) {
                    ServerSessionImpl.this.flush();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBatch() {
        Object object = this.getLock();
        synchronized (object) {
            ++this._batch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endBatch() {
        boolean result = false;
        Object object = this.getLock();
        synchronized (object) {
            if (--this._batch == 0 && this._nonLazyMessages) {
                result = true;
            }
        }
        if (result) {
            this.flush();
        }
        return result;
    }

    public LocalSession getLocalSession() {
        return this._localSession;
    }

    public boolean isLocalSession() {
        return this._localSession != null;
    }

    public void addListener(ServerSession.ServerSessionListener listener) {
        this._listeners.add(listener);
    }

    public String getId() {
        return this._id;
    }

    public Object getLock() {
        return this;
    }

    public Queue<ServerMessage> getQueue() {
        return this._queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNonLazyMessages() {
        Object object = this.getLock();
        synchronized (object) {
            return this._nonLazyMessages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessage(ServerMessage message) {
        Object object = this.getLock();
        synchronized (object) {
            this._queue.add(message);
            this._nonLazyMessages |= !message.isLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerMessage> takeQueue(List<ServerMessage.Mutable> replies) {
        List<ServerMessage> copy = Collections.emptyList();
        Object object = this.getLock();
        synchronized (object) {
            for (ServerSession.ServerSessionListener listener : this._listeners) {
                if (!(listener instanceof ServerSession.DeQueueListener)) continue;
                this.notifyDeQueue((ServerSession.DeQueueListener)listener, this, this._queue, replies);
            }
            int size = this._queue.size();
            if (size > 0) {
                copy = new ArrayList(size);
                copy.addAll(this._queue);
                this._queue.clear();
            }
            this._nonLazyMessages = false;
        }
        return copy;
    }

    private void notifyDeQueue(ServerSession.DeQueueListener listener, ServerSession serverSession, Queue<ServerMessage> queue, List<ServerMessage.Mutable> replies) {
        try {
            listener.deQueue(serverSession, queue, replies);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking listener " + listener, x);
        }
    }

    public void notifySuspended(ServerMessage message, long timeout) {
        for (ServerSession.ServerSessionListener listener : this._listeners) {
            if (!(listener instanceof ServerSession.HeartBeatListener)) continue;
            ((ServerSession.HeartBeatListener)listener).onSuspended((ServerSession)this, message, timeout);
        }
    }

    public void notifyResumed(ServerMessage message, boolean timeout) {
        for (ServerSession.ServerSessionListener listener : this._listeners) {
            if (!(listener instanceof ServerSession.HeartBeatListener)) continue;
            ((ServerSession.HeartBeatListener)listener).onResumed((ServerSession)this, message, timeout);
        }
    }

    public void removeListener(ServerSession.ServerSessionListener listener) {
        this._listeners.remove(listener);
    }

    public List<ServerSession.ServerSessionListener> getListeners() {
        return Collections.unmodifiableList(this._listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduler(AbstractServerTransport.Scheduler newScheduler) {
        if (newScheduler == null) {
            AbstractServerTransport.Scheduler oldScheduler;
            Object object = this.getLock();
            synchronized (object) {
                oldScheduler = this._scheduler;
                if (_logger.isDebugEnabled()) {
                    _logger.debug("{} disabling scheduler {}", (Object)this, (Object)oldScheduler);
                }
            }
            oldScheduler.cancel();
        } else {
            AbstractServerTransport.Scheduler oldScheduler;
            boolean schedule = false;
            Object object = this.getLock();
            synchronized (object) {
                oldScheduler = this._scheduler;
                if (newScheduler.getMetaConnectCycle() >= oldScheduler.getMetaConnectCycle()) {
                    this._scheduler = newScheduler;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("{} replacing scheduler old={} new={}", new Object[]{this, oldScheduler, newScheduler});
                    }
                    if (this.shouldSchedule()) {
                        schedule = true;
                    } else {
                        this.cancelExpiration(true);
                    }
                } else {
                    oldScheduler = newScheduler;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("{} ignoring stale scheduler {}", (Object)this, (Object)newScheduler);
                    }
                }
            }
            oldScheduler.cancel();
            if (schedule) {
                newScheduler.schedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldSchedule() {
        Object object = this.getLock();
        synchronized (object) {
            return this.hasNonLazyMessages() && this._batch == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        AbstractServerTransport.Scheduler scheduler;
        Iterator<ServerMessage> iterator = this.getLock();
        synchronized (iterator) {
            this._lazyTask.cancel();
            scheduler = this._scheduler;
        }
        if (this._localSession == null) {
            scheduler.schedule();
        } else if (this.hasNonLazyMessages()) {
            for (ServerMessage msg : this.takeQueue(Collections.emptyList())) {
                this._localSession.receive((Message.Mutable)new HashMapMessage((Message)msg), (Promise<Void>)Promise.noop());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushLazy(ServerMessage message) {
        Object object = this.getLock();
        synchronized (object) {
            ServerChannel channel = this._bayeux.getChannel(message.getChannel());
            long lazyTimeout = -1L;
            if (channel != null) {
                lazyTimeout = channel.getLazyTimeout();
            }
            if (lazyTimeout <= 0L) {
                lazyTimeout = this._maxLazy;
            }
            if (lazyTimeout <= 0L) {
                this.flush();
            } else {
                this._lazyTask.schedule(lazyTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyScheduler() {
        AbstractServerTransport.Scheduler oldScheduler;
        Object object = this.getLock();
        synchronized (object) {
            oldScheduler = this._scheduler;
            this._scheduler = new AbstractServerTransport.Scheduler.None(Long.MAX_VALUE);
        }
        oldScheduler.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelExpiration(boolean metaConnect) {
        long now = System.nanoTime();
        Object object = this.getLock();
        synchronized (object) {
            this._messageTime = now;
            if (metaConnect) {
                this._expireTime = 0L;
            } else if (this._expireTime != 0L) {
                long maxInterval = this.calculateMaxInterval(this.getServerTransport().getMaxInterval());
                this._expireTime = Math.max(this._expireTime, now + TimeUnit.MILLISECONDS.toNanos(maxInterval));
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("{} expiration for {}", (Object)(metaConnect ? "Cancelled" : "Delayed"), (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleExpiration(long defaultInterval, long defaultMaxInterval, long metaConnectCycle) {
        long interval = this.calculateInterval(defaultInterval);
        long maxInterval = this.calculateMaxInterval(defaultMaxInterval);
        long now = System.nanoTime();
        Object object = this.getLock();
        synchronized (object) {
            long currentMetaConnectCycle = this.getMetaConnectCycle();
            if (metaConnectCycle == 0L || metaConnectCycle == currentMetaConnectCycle) {
                this._expireTime = now + TimeUnit.MILLISECONDS.toNanos(interval + maxInterval);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Scheduled expiration for {}", (Object)this);
                }
            } else if (this._state == State.HANDSHAKEN) {
                _logger.info("Skipped expiration at cycle {}/{} for {}", new Object[]{metaConnectCycle, currentMetaConnectCycle, this, new Throwable()});
            } else if (_logger.isDebugEnabled()) {
                _logger.debug("Skipped expiration at cycle {}/{} for {}", new Object[]{metaConnectCycle, currentMetaConnectCycle, this});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getMetaConnectCycle() {
        Object object = this.getLock();
        synchronized (object) {
            return this._scheduler.getMetaConnectCycle();
        }
    }

    public long getMaxInterval() {
        return this._maxInterval;
    }

    public void setMaxInterval(long maxInterval) {
        this._maxInterval = maxInterval;
    }

    long getIntervalTimestamp() {
        return this._expireTime;
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this._attributes.getAttributeNameSet();
    }

    public Object removeAttribute(String name) {
        Object old = this.getAttribute(name);
        this._attributes.removeAttribute(name);
        return old;
    }

    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHandshook() {
        Object object = this.getLock();
        synchronized (object) {
            return this._state == State.HANDSHAKEN || this._state == State.CONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.getLock();
        synchronized (object) {
            return this._state == State.CONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnected() {
        Object object = this.getLock();
        synchronized (object) {
            return this._state == State.DISCONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.getLock();
        synchronized (object) {
            return this._state == State.DISCONNECTED || this._state == State.EXPIRED;
        }
    }

    protected void extendIncoming(ServerMessage.Mutable message, Promise<Boolean> promise) {
        AsyncFoldLeft.run(this._extensions, (Object)true, (result, extension, loop) -> {
            if (result.booleanValue()) {
                try {
                    extension.incoming((ServerSession)this, message, Promise.from(arg_0 -> ((AsyncFoldLeft.Loop)loop).proceed(arg_0), failure -> {
                        _logger.info("Exception reported by extension " + extension, failure);
                        loop.proceed((Object)true);
                    }));
                }
                catch (Throwable x) {
                    _logger.info("Exception thrown by extension " + extension, x);
                    loop.proceed((Object)true);
                }
            } else {
                loop.leave((Object)false);
            }
        }, promise);
    }

    public void reAdvise() {
        this._advisedTransport = null;
    }

    public Map<String, Object> takeAdvice(ServerTransport transport) {
        if (transport == null || transport == this._advisedTransport) {
            return null;
        }
        return this.createAdvice(transport);
    }

    private Map<String, Object> createAdvice(ServerTransport transport) {
        this._advisedTransport = transport;
        long timeout = this.getTimeout() < 0L ? transport.getTimeout() : this.getTimeout();
        long interval = this.calculateInterval(transport.getInterval());
        HashMap<String, Object> advice = new HashMap<String, Object>(3);
        advice.put("reconnect", "retry");
        advice.put("interval", interval);
        advice.put("timeout", timeout);
        if (transport instanceof AbstractServerTransport && ((AbstractServerTransport)transport).isHandshakeReconnect()) {
            long maxInterval = this.calculateMaxInterval(transport.getMaxInterval());
            advice.put("maxInterval", maxInterval);
        }
        return advice;
    }

    public ServerTransport getServerTransport() {
        return this._transport;
    }

    public void setServerTransport(ServerTransport transport) {
        this._transport = transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateServerEndPoint(Object newEndPoint) {
        Object object = this.getLock();
        synchronized (object) {
            if (this._endPoint == newEndPoint) {
                return this._state == State.NEW || this._state == State.HANDSHAKEN;
            }
            this._endPoint = newEndPoint;
            return true;
        }
    }

    public long getTimeout() {
        return this._timeout;
    }

    public long getInterval() {
        return this._interval;
    }

    public void setTimeout(long timeoutMS) {
        this._timeout = timeoutMS;
        this._advisedTransport = null;
    }

    public void setInterval(long intervalMS) {
        this._interval = intervalMS;
        this._advisedTransport = null;
    }

    public boolean isBroadcastToPublisher() {
        return this._broadcastToPublisher;
    }

    public void setBroadcastToPublisher(boolean value) {
        this._broadcastToPublisher = value;
    }

    void added(ServerMessage message) {
        for (ServerSession.ServerSessionListener listener : this._listeners) {
            if (!(listener instanceof ServerSession.AddedListener)) continue;
            this.notifyAdded((ServerSession.AddedListener)listener, this, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removed(ServerMessage message, boolean timeout) {
        boolean result;
        Iterator<ServerChannelImpl> iterator = this.getLock();
        synchronized (iterator) {
            result = this.isHandshook();
            this._state = timeout ? State.EXPIRED : State.DISCONNECTED;
        }
        if (result) {
            for (ServerChannelImpl channel : this.subscriptions) {
                channel.unsubscribe(this);
            }
            for (ServerSession.ServerSessionListener listener : this._listeners) {
                if (!(listener instanceof ServerSession.RemovedListener)) continue;
                this.notifyRemoved((ServerSession.RemovedListener)listener, this, message, timeout);
            }
        }
        return result;
    }

    private void notifyAdded(ServerSession.AddedListener listener, ServerSession serverSession, ServerMessage message) {
        try {
            listener.added(serverSession, message);
        }
        catch (Exception x) {
            _logger.info("Exception while invoking listener " + listener, (Throwable)x);
        }
    }

    private void notifyRemoved(ServerSession.RemovedListener listener, ServerSession session, ServerMessage message, boolean timeout) {
        try {
            listener.removed(session, message, timeout);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking listener " + listener, x);
        }
    }

    public void setMetaConnectDeliveryOnly(boolean meta) {
        this._metaConnectDelivery = meta;
    }

    public boolean isMetaConnectDeliveryOnly() {
        return this._metaConnectDelivery;
    }

    public boolean isAllowMessageDeliveryDuringHandshake() {
        return this._allowMessageDeliveryDuringHandshake;
    }

    public void setAllowMessageDeliveryDuringHandshake(boolean allow) {
        this._allowMessageDeliveryDuringHandshake = allow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean subscribe(ServerChannelImpl channel) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isTerminated()) {
                return false;
            }
            this.subscriptions.add(channel);
            return true;
        }
    }

    protected void unsubscribedFrom(ServerChannelImpl channel) {
        this.subscriptions.remove(channel);
    }

    public long calculateTimeout(long defaultTimeout) {
        if (this._transientTimeout >= 0L) {
            return this._transientTimeout;
        }
        if (this._timeout >= 0L) {
            return this._timeout;
        }
        return defaultTimeout;
    }

    public long calculateInterval(long defaultInterval) {
        if (this._transientInterval >= 0L) {
            return this._transientInterval;
        }
        if (this._interval >= 0L) {
            return this._interval;
        }
        return defaultInterval;
    }

    private long calculateMaxInterval(long defaultMaxInterval) {
        if (this._maxInterval > 0L) {
            return this._maxInterval;
        }
        return defaultMaxInterval;
    }

    public void updateTransientTimeout(long timeout) {
        this._transientTimeout = timeout;
    }

    public void updateTransientInterval(long interval) {
        this._transientInterval = interval;
    }

    public void dump(Appendable out, String indent) throws IOException {
        List<ServerSession.ServerSessionListener> listeners = this._listeners;
        if (this._bayeux.isDetailedDump()) {
            Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{new DumpableCollection("listeners", listeners)});
        } else {
            Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{"listeners size=" + listeners.size()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object endPoint;
        AbstractServerTransport.Scheduler scheduler;
        int size;
        State state;
        long expire;
        long last;
        long cycle;
        long now = System.nanoTime();
        Object object = this.getLock();
        synchronized (object) {
            cycle = this.getMetaConnectCycle();
            last = now - this._messageTime;
            expire = this._expireTime == 0L ? 0L : this._expireTime - now;
            state = this._state;
            size = this._queue.size();
            scheduler = this._scheduler;
            endPoint = this._endPoint;
        }
        return String.format("%s@%x[%s,%s,q=%d,cycle=%d,last=%d,expire=%d,scheduler=%s,endPoint=%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._id, state, size, cycle, TimeUnit.NANOSECONDS.toMillis(last), TimeUnit.NANOSECONDS.toMillis(expire), scheduler, endPoint});
    }

    private class LazyTask
    implements Runnable {
        private long _nextExecutionNanos;
        private volatile Scheduler.Task _task;

        private LazyTask() {
        }

        @Override
        public void run() {
            ServerSessionImpl.this.flush();
            this._nextExecutionNanos = 0L;
            this._task = null;
        }

        public boolean cancel() {
            Scheduler.Task task = this._task;
            return task != null && task.cancel();
        }

        public boolean schedule(long lazyTimeout) {
            long nextExecutionNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(lazyTimeout);
            if (this._task == null || this._nextExecutionNanos - nextExecutionNanos > 0L) {
                this.cancel();
                this._nextExecutionNanos = nextExecutionNanos;
                this._task = ServerSessionImpl.this._bayeux.schedule(this, lazyTimeout);
                return true;
            }
            return false;
        }
    }

    private static enum State {
        NEW,
        HANDSHAKEN,
        CONNECTED,
        DISCONNECTED,
        EXPIRED;

    }
}

