/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;

public class BatchArrayQueue<T>
implements Queue<T> {
    private final Object lock;
    private T[] elements;
    private int head;
    private int tail;
    private long[] batches;
    private long batch;

    public BatchArrayQueue(int initial, Object lock) {
        this.lock = lock;
        Object[] array = new Object[initial];
        this.elements = array;
        this.batches = new long[initial];
        this.batch = 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T t) {
        Object object = this.lock;
        synchronized (object) {
            this.elements[this.tail] = Objects.requireNonNull(t);
            this.batches[this.tail] = this.batch;
            ++this.tail;
            if (this.tail == this.elements.length) {
                this.tail = 0;
            }
            if (this.tail == this.head) {
                int capacity = this.elements.length;
                int newCapacity = 2 * capacity;
                if (newCapacity < 0) {
                    throw new IllegalStateException("Could not double up capacity " + capacity);
                }
                Object[] newElements = new Object[newCapacity];
                long[] newBatches = new long[newCapacity];
                int length = capacity - this.head;
                if (length > 0) {
                    System.arraycopy(this.elements, this.head, newElements, 0, length);
                    System.arraycopy(this.batches, this.head, newBatches, 0, length);
                }
                if (this.head > 0) {
                    System.arraycopy(this.elements, 0, newElements, length, this.tail);
                    System.arraycopy(this.batches, 0, newBatches, length, this.tail);
                }
                this.elements = newElements;
                this.batches = newBatches;
                this.head = 0;
                this.tail = capacity;
            }
        }
        return true;
    }

    @Override
    public boolean add(T t) {
        return this.offer(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peek() {
        Object object = this.lock;
        synchronized (object) {
            return this.elements[this.head];
        }
    }

    @Override
    public T element() {
        T element = this.peek();
        if (element == null) {
            throw new NoSuchElementException();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isEmpty()) {
                return null;
            }
            T result = this.elements[this.head];
            this.elements[this.head] = null;
            this.batches[this.head] = 0L;
            ++this.head;
            if (this.head == this.elements.length) {
                this.head = 0;
            }
            return result;
        }
    }

    @Override
    public T remove() {
        T result = this.poll();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> items) {
        Object object = this.lock;
        synchronized (object) {
            boolean result = false;
            for (T item : items) {
                result |= this.offer(item);
            }
            return result;
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> items) {
        Object object = this.lock;
        synchronized (object) {
            for (Object item : items) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isEmpty()) {
                return false;
            }
            int cursor = this.head;
            do {
                if (o.equals(this.elements[cursor])) {
                    return true;
                }
                if (++cursor != this.elements.length) continue;
                cursor = 0;
            } while (cursor != this.tail);
            return false;
        }
    }

    @Override
    public Iterator<T> iterator() {
        final Object[] objects = this.toArray();
        return new Iterator<T>(){
            private int index = 0;
            final /* synthetic */ BatchArrayQueue this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return this.index < objects.length;
            }

            @Override
            public T next() {
                return objects[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.head == this.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            if (this.head <= this.tail) {
                return this.tail - this.head;
            }
            return this.elements.length - this.head + this.tail;
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArray((E[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> E[] toArray(E[] a) {
        Object object = this.lock;
        synchronized (object) {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            if (this.head <= this.tail) {
                System.arraycopy(this.elements, this.head, a, 0, size);
            } else {
                int l = this.elements.length - this.head;
                System.arraycopy(this.elements, this.head, a, 0, l);
                System.arraycopy(this.elements, 0, a, l, this.tail);
            }
            return a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            Arrays.fill(this.elements, null);
            Arrays.fill(this.batches, 0L);
            this.tail = 0;
            this.head = 0;
            this.batch = 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBatch() {
        Object object = this.lock;
        synchronized (object) {
            return this.batch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBatch() {
        Object object = this.lock;
        synchronized (object) {
            ++this.batch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearToBatch(long batch) {
        Object object = this.lock;
        synchronized (object) {
            while (this.batches[this.head] <= batch && this.poll() != null) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportMessagesToBatch(Queue<T> target, long batch) {
        Object object = this.lock;
        synchronized (object) {
            int cursor = this.head;
            while (cursor != this.tail && this.batches[cursor] <= batch) {
                target.offer(this.elements[cursor]);
                if (++cursor != this.batches.length) continue;
                cursor = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long batchOf(int index) {
        Object object = this.lock;
        synchronized (object) {
            int cursor = this.head + index;
            int capacity = this.elements.length;
            if (cursor > capacity) {
                cursor -= capacity;
            }
            return this.batches[cursor];
        }
    }
}

