/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.ext.AcknowledgedMessagesSessionExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcknowledgedMessagesExtension
implements BayeuxServer.Extension {
    private final Logger _logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final List<Listener> _listeners = new CopyOnWriteArrayList<Listener>();
    private int _maxQueueSize = -1;

    public void addListener(Listener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this._listeners.remove(listener);
    }

    public int getMaxQueueSize() {
        return this._maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this._maxQueueSize = maxQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rcvMeta(ServerSession remote, ServerMessage.Mutable message) {
        if ("/meta/handshake".equals(message.getChannel())) {
            boolean clientRequestedAcks;
            Map rcvExt = message.getExt();
            boolean bl = clientRequestedAcks = rcvExt != null && rcvExt.get("ack") == Boolean.TRUE;
            if (clientRequestedAcks && remote != null) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Enabled message acknowledgement for {}", (Object)remote);
                }
                AcknowledgedMessagesSessionExtension extension = this.newSessionExtension(remote);
                extension.addListeners(this._listeners);
                extension.setMaxQueueSize(this.getMaxQueueSize());
                ServerSessionImpl session = (ServerSessionImpl)remote;
                Object object = session.getLock();
                synchronized (object) {
                    session.addExtension(extension);
                    extension.importMessages(session);
                }
            }
        }
        return true;
    }

    protected AcknowledgedMessagesSessionExtension newSessionExtension(ServerSession session) {
        return new AcknowledgedMessagesSessionExtension(session);
    }

    public static interface Listener {
        default public void onBatchSend(ServerSession session, List<ServerMessage> messages, long batch) {
        }

        default public void onBatchReceive(ServerSession session, long batch) {
        }

        default public void onBatchQueueMaxed(ServerSession session, Queue<ServerMessage> queue) {
        }
    }
}

