/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.filter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.filter.DataFilter;

public class JSONDataFilter
implements DataFilter {
    public void init(Object init) {
    }

    @Override
    public Object filter(ServerSession session, ServerChannel channel, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Map) {
            return this.filterMap(session, channel, (Map)data);
        }
        if (data instanceof List) {
            return this.filterList(session, channel, (List)data);
        }
        if (data instanceof Collection) {
            return this.filterCollection(session, channel, (Collection)data);
        }
        if (data.getClass().isArray()) {
            return this.filterArray(session, channel, data);
        }
        if (data instanceof Number) {
            return this.filterNumber(session, channel, (Number)data);
        }
        if (data instanceof Boolean) {
            return this.filterBoolean(session, channel, (Boolean)data);
        }
        if (data instanceof String) {
            return this.filterString(session, channel, (String)data);
        }
        return this.filterObject(session, channel, data);
    }

    protected Object filterString(ServerSession session, ServerChannel channel, String string) {
        return string;
    }

    protected Object filterBoolean(ServerSession session, ServerChannel channel, Boolean bool) {
        return bool;
    }

    protected Object filterNumber(ServerSession session, ServerChannel channel, Number number) {
        return number;
    }

    protected Object filterArray(ServerSession session, ServerChannel channel, Object array) {
        Object[] mutated = null;
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object filtered;
            Object original = Array.get(array, i);
            if (original == (filtered = this.filter(session, channel, original))) continue;
            if (mutated == null) {
                mutated = Arrays.copyOf((Object[])array, Array.getLength(array));
            }
            mutated[i] = filtered;
        }
        return mutated == null ? array : mutated;
    }

    protected Object filterList(ServerSession session, ServerChannel channel, List<Object> list) {
        ArrayList<Object> mutated = null;
        for (int i = 0; i < list.size(); ++i) {
            Object filtered;
            Object original = list.get(i);
            if (original == (filtered = this.filter(session, channel, original))) continue;
            if (mutated == null) {
                mutated = new ArrayList<Object>(list);
            }
            mutated.set(i, filtered);
        }
        return mutated == null ? list : mutated;
    }

    protected Object filterCollection(ServerSession session, ServerChannel channel, Collection<Object> collection) {
        int index = 0;
        ArrayList<Object> mutated = null;
        for (Object original : collection) {
            Object filtered;
            if (original != (filtered = this.filter(session, channel, original))) {
                if (mutated == null) {
                    mutated = new ArrayList<Object>(collection.size());
                    int i = 0;
                    for (Object copy : collection) {
                        if (i == index) break;
                        mutated.add(copy);
                        ++i;
                    }
                }
                mutated.add(filtered);
            } else if (mutated != null) {
                mutated.add(original);
            }
            ++index;
        }
        return mutated == null ? collection : mutated;
    }

    protected Object filterMap(ServerSession session, ServerChannel channel, Map<String, Object> map) {
        HashMap<String, Object> mutated = null;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object filtered;
            Object original = entry.getValue();
            if (original == (filtered = this.filter(session, channel, original))) continue;
            if (mutated == null) {
                mutated = new HashMap<String, Object>(map);
            }
            mutated.put(entry.getKey(), filtered);
        }
        return mutated == null ? map : mutated;
    }

    protected Object filterObject(ServerSession session, ServerChannel channel, Object data) {
        return data;
    }
}

