/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.http;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.http.AbstractHttpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamHttpTransport
extends AbstractHttpTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStreamHttpTransport.class);
    private static final String CONTEXT_ATTRIBUTE = "org.cometd.transport.context";
    private static final String HEARTBEAT_TIMEOUT_ATTRIBUTE = "org.cometd.transport.heartbeat.timeout";

    protected AbstractStreamHttpTransport(BayeuxServerImpl bayeux, String name) {
        super(bayeux, name);
    }

    @Override
    public void handle(final HttpServletRequest request, final HttpServletResponse response) {
        final AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        Promise<Void> promise = new Promise<Void>(){

            public void succeed(Void result) {
                asyncContext.complete();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Handling successful");
                }
            }

            public void fail(Throwable failure) {
                int code = failure instanceof TimeoutException ? AbstractStreamHttpTransport.this.getDuplicateMetaConnectHttpResponseCode() : 500;
                AbstractStreamHttpTransport.this.sendError(request, response, code, failure);
                asyncContext.complete();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Handling failed", failure);
                }
            }
        };
        AbstractHttpTransport.Context context = (AbstractHttpTransport.Context)request.getAttribute(CONTEXT_ATTRIBUTE);
        if (context == null) {
            this.process(new AbstractHttpTransport.Context(request, response), promise);
        } else {
            ServerMessage.Mutable message = context.scheduler.getMessage();
            context.session.notifyResumed((ServerMessage)message, (Boolean)request.getAttribute(HEARTBEAT_TIMEOUT_ATTRIBUTE));
            this.resume(context, message, (Promise<Void>)Promise.from(arg_0 -> this.lambda$handle$0(context, (Promise)promise, arg_0), arg_0 -> ((Promise)promise).fail(arg_0)));
        }
    }

    protected void process(AbstractHttpTransport.Context context, Promise<Void> promise) {
        block6: {
            HttpServletRequest request = context.request;
            try {
                try {
                    ServerMessage.Mutable[] messages = this.parseMessages(request);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Parsed {} messages", (Object)(messages == null ? -1 : messages.length));
                    }
                    if (messages != null) {
                        this.processMessages(context, List.of(messages), promise);
                        break block6;
                    }
                    promise.succeed(null);
                }
                catch (ParseException x) {
                    this.handleJSONParseException(request, context.response, x.getMessage(), x.getCause());
                    promise.succeed(null);
                }
            }
            catch (Throwable x) {
                promise.fail(x);
            }
        }
    }

    @Override
    protected AbstractHttpTransport.HttpScheduler suspend(AbstractHttpTransport.Context context, Promise<Void> promise, ServerMessage.Mutable message, long timeout) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Suspended {}", (Object)message);
        }
        HttpServletRequest request = context.request;
        context.scheduler = this.newHttpScheduler(context, promise, message, timeout);
        request.setAttribute(CONTEXT_ATTRIBUTE, (Object)context);
        context.session.notifySuspended((ServerMessage)message, timeout);
        return context.scheduler;
    }

    protected AbstractHttpTransport.HttpScheduler newHttpScheduler(AbstractHttpTransport.Context context, Promise<Void> promise, ServerMessage.Mutable message, long timeout) {
        return new DispatchingLongPollScheduler(context, promise, message, timeout);
    }

    protected abstract ServerMessage.Mutable[] parseMessages(HttpServletRequest var1) throws IOException, ParseException;

    protected ServerMessage.Mutable[] parseMessages(String[] requestParameters) throws IOException, ParseException {
        if (requestParameters == null || requestParameters.length == 0) {
            throw new IOException("Missing 'message' request parameter");
        }
        if (requestParameters.length == 1) {
            return this.parseMessages(requestParameters[0]);
        }
        ArrayList<ServerMessage.Mutable> messages = new ArrayList<ServerMessage.Mutable>();
        for (String batch : requestParameters) {
            ServerMessage.Mutable[] parsed;
            if (batch == null || (parsed = this.parseMessages(batch)) == null) continue;
            messages.addAll(List.of(parsed));
        }
        return messages.toArray(new ServerMessage.Mutable[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(AbstractHttpTransport.Context context, List<ServerMessage> messages, Promise<Void> promise) {
        HttpServletRequest request = context.request;
        HttpServletResponse response = context.response;
        try {
            ServerMessage.Mutable reply;
            ServletOutputStream output;
            ServerSessionImpl session = context.session;
            List<ServerMessage.Mutable> replies = context.replies;
            int replyIndex = 0;
            boolean needsComma = false;
            try {
                output = this.beginWrite(request, response);
                if (replies.size() > 0 && "/meta/handshake".equals((reply = replies.get(0)).getChannel())) {
                    if (this.allowMessageDeliveryDuringHandshake(session) && !messages.isEmpty()) {
                        reply.put((Object)"x-messages", (Object)messages.size());
                    }
                    this.getBayeux().freeze(reply);
                    this.writeMessage(context, output, (ServerMessage)reply);
                    needsComma = true;
                    ++replyIndex;
                }
                for (ServerMessage message : messages) {
                    if (needsComma) {
                        output.write(44);
                    }
                    needsComma = true;
                    this.writeMessage(context, output, message);
                }
            }
            finally {
                if (context.scheduleExpiration) {
                    this.scheduleExpiration(session, context.metaConnectCycle);
                }
            }
            while (replyIndex < replies.size()) {
                reply = replies.get(replyIndex);
                if (needsComma) {
                    output.write(44);
                }
                needsComma = true;
                this.getBayeux().freeze(reply);
                this.writeMessage(context, output, (ServerMessage)reply);
                ++replyIndex;
            }
            this.endWrite(response, output);
            promise.succeed(null);
            this.writeComplete(context, messages);
        }
        catch (Throwable x) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failure writing messages", x);
            }
            promise.fail(x);
        }
    }

    protected void writeMessage(AbstractHttpTransport.Context context, ServletOutputStream output, ServerMessage message) throws IOException {
        this.writeMessage(context.response, output, context.session, message);
    }

    protected void writeMessage(HttpServletResponse response, ServletOutputStream output, ServerSessionImpl session, ServerMessage message) throws IOException {
        output.write(this.toJSONBytes(message));
    }

    protected abstract ServletOutputStream beginWrite(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected abstract void endWrite(HttpServletResponse var1, ServletOutputStream var2) throws IOException;

    protected void writeComplete(AbstractHttpTransport.Context context, List<ServerMessage> messages) {
    }

    private /* synthetic */ void lambda$handle$0(AbstractHttpTransport.Context context, Promise promise, Void y) {
        this.flush(context, (Promise<Void>)promise);
    }

    protected class DispatchingLongPollScheduler
    extends AbstractHttpTransport.LongPollScheduler {
        public DispatchingLongPollScheduler(AbstractHttpTransport.Context context, Promise<Void> promise, ServerMessage.Mutable message, long timeout) {
            super(context, promise, message, timeout);
        }

        @Override
        protected void dispatch(boolean timeout) {
            HttpServletRequest request = this.getContext().request;
            request.setAttribute(AbstractStreamHttpTransport.HEARTBEAT_TIMEOUT_ATTRIBUTE, (Object)timeout);
            AsyncContext asyncContext = AbstractStreamHttpTransport.this.getAsyncContext(request);
            if (asyncContext != null) {
                asyncContext.dispatch();
            }
        }
    }
}

