/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerChannelImpl
implements ServerChannel,
Dumpable {
    private static final Logger _logger = LoggerFactory.getLogger(ServerChannel.class);
    private final BayeuxServerImpl _bayeux;
    private final ChannelId _id;
    private final AttributesMap _attributes = new AttributesMap();
    private final Set<ServerSession> _subscribers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<ConfigurableServerChannel.ServerChannelListener> _listeners = new CopyOnWriteArrayList<ConfigurableServerChannel.ServerChannelListener>();
    private final List<Authorizer> _authorizers = new CopyOnWriteArrayList<Authorizer>();
    private final CountDownLatch _initialized = new CountDownLatch(1);
    private final AtomicInteger _sweeperPasses = new AtomicInteger();
    private boolean _lazy;
    private long _lazyTimeout = -1L;
    private boolean _persistent;
    private boolean _broadcastToPublisher = true;

    protected ServerChannelImpl(BayeuxServerImpl bayeux, ChannelId id) {
        this._bayeux = bayeux;
        this._id = id;
        this.setPersistent(!this.isBroadcast());
    }

    void waitForInitialized() {
        try {
            if (!this._initialized.await(5L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Not Initialized: " + String.valueOf(this));
            }
        }
        catch (InterruptedException x) {
            throw new IllegalStateException("Initialization interrupted: " + String.valueOf(this), x);
        }
    }

    void initialized() {
        this.resetSweeperPasses();
        this._initialized.countDown();
    }

    void resetSweeperPasses() {
        this._sweeperPasses.set(0);
    }

    public boolean subscribe(ServerSession session) {
        return this.subscribe((ServerSessionImpl)session, null);
    }

    protected boolean subscribe(ServerSessionImpl session, ServerMessage message) {
        if (this.isService()) {
            return true;
        }
        if (this.isMeta()) {
            return false;
        }
        this.resetSweeperPasses();
        if (session.subscribe(this)) {
            if (this._subscribers.add(session)) {
                for (ConfigurableServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
                    if (!(serverChannelListener instanceof ServerChannel.SubscriptionListener)) continue;
                    this.notifySubscribed((ServerChannel.SubscriptionListener)serverChannelListener, (ServerSession)session, (ServerChannel)this, message);
                }
                for (BayeuxServer.BayeuxServerListener bayeuxServerListener : this._bayeux.getListeners()) {
                    if (!(bayeuxServerListener instanceof BayeuxServer.SubscriptionListener)) continue;
                    this.notifySubscribed((BayeuxServer.SubscriptionListener)bayeuxServerListener, (ServerSession)session, (ServerChannel)this, message);
                }
            }
            return true;
        }
        return false;
    }

    private void notifySubscribed(ServerChannel.SubscriptionListener listener, ServerSession session, ServerChannel channel, ServerMessage message) {
        try {
            listener.subscribed(session, channel, message);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking listener " + String.valueOf(listener), x);
        }
    }

    private void notifySubscribed(BayeuxServer.SubscriptionListener listener, ServerSession session, ServerChannel channel, ServerMessage message) {
        try {
            listener.subscribed(session, channel, message);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking listener " + String.valueOf(listener), x);
        }
    }

    public boolean unsubscribe(ServerSession session) {
        return this.unsubscribe((ServerSessionImpl)session, null);
    }

    protected boolean unsubscribe(ServerSessionImpl session, ServerMessage message) {
        if (this.isService()) {
            return true;
        }
        if (this.isMeta()) {
            return false;
        }
        if (this._subscribers.remove(session)) {
            session.unsubscribedFrom(this);
            for (ConfigurableServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
                if (!(serverChannelListener instanceof ServerChannel.SubscriptionListener)) continue;
                this.notifyUnsubscribed((ServerChannel.SubscriptionListener)serverChannelListener, (ServerSession)session, (ServerChannel)this, message);
            }
            for (BayeuxServer.BayeuxServerListener bayeuxServerListener : this._bayeux.getListeners()) {
                if (!(bayeuxServerListener instanceof BayeuxServer.SubscriptionListener)) continue;
                this.notifyUnsubscribed((BayeuxServer.SubscriptionListener)bayeuxServerListener, (ServerSession)session, (ServerChannel)this, message);
            }
        }
        return true;
    }

    private void notifyUnsubscribed(BayeuxServer.SubscriptionListener listener, ServerSession session, ServerChannel channel, ServerMessage message) {
        try {
            listener.unsubscribed(session, channel, message);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking listener " + String.valueOf(listener), x);
        }
    }

    private void notifyUnsubscribed(ServerChannel.SubscriptionListener listener, ServerSession session, ServerChannel channel, ServerMessage message) {
        try {
            listener.unsubscribed(session, channel, message);
        }
        catch (Throwable x) {
            _logger.info("Exception while invoking listener " + String.valueOf(listener), x);
        }
    }

    public Set<ServerSession> getSubscribers() {
        return Set.copyOf(this.subscribers());
    }

    public Set<ServerSession> subscribers() {
        return this._subscribers;
    }

    public boolean isBroadcast() {
        return !this.isMeta() && !this.isService();
    }

    public boolean isDeepWild() {
        return this._id.isDeepWild();
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public boolean isWild() {
        return this._id.isWild();
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
        if (!lazy) {
            this._lazyTimeout = -1L;
        }
    }

    public long getLazyTimeout() {
        return this._lazyTimeout;
    }

    public void setLazyTimeout(long lazyTimeout) {
        this._lazyTimeout = lazyTimeout;
        this.setLazy(lazyTimeout > 0L);
    }

    public void setPersistent(boolean persistent) {
        this.resetSweeperPasses();
        this._persistent = persistent;
    }

    public void addListener(ConfigurableServerChannel.ServerChannelListener listener) {
        this.resetSweeperPasses();
        this._listeners.add(listener);
    }

    public boolean isBroadcastToPublisher() {
        return this._broadcastToPublisher;
    }

    public void setBroadcastToPublisher(boolean broadcastToPublisher) {
        this._broadcastToPublisher = broadcastToPublisher;
    }

    public void removeListener(ConfigurableServerChannel.ServerChannelListener listener) {
        this._listeners.remove(listener);
    }

    public List<ConfigurableServerChannel.ServerChannelListener> getListeners() {
        return List.copyOf(this.listeners());
    }

    protected List<ConfigurableServerChannel.ServerChannelListener> listeners() {
        return this._listeners;
    }

    public ChannelId getChannelId() {
        return this._id;
    }

    public String getId() {
        return this._id.getId();
    }

    public boolean isMeta() {
        return this._id.isMeta();
    }

    public boolean isService() {
        return this._id.isService();
    }

    public void publish(Session from, ServerMessage.Mutable mutable, Promise<Boolean> promise) {
        if (this.isWild()) {
            throw new IllegalStateException("Wild publish");
        }
        mutable.setChannel(this.getId());
        ServerSessionImpl session = null;
        if (from instanceof ServerSessionImpl) {
            session = (ServerSessionImpl)from;
        } else if (from instanceof LocalSession) {
            session = (ServerSessionImpl)((LocalSession)from).getServerSession();
        }
        this._bayeux.publish(session, this, mutable, false, promise);
    }

    public void publish(Session from, Object data, Promise<Boolean> promise) {
        ServerMessage.Mutable mutable = this._bayeux.newMessage();
        mutable.setData(data);
        this.publish(from, mutable, promise);
    }

    protected void sweep() {
        this.waitForInitialized();
        for (ServerSession session : this._subscribers) {
            if (session.isHandshook()) continue;
            this.unsubscribe(session);
        }
        if (this.isMeta() || this.isPersistent()) {
            return;
        }
        if (!this._subscribers.isEmpty()) {
            return;
        }
        if (!this._authorizers.isEmpty()) {
            return;
        }
        for (ConfigurableServerChannel.ServerChannelListener listener : this._listeners) {
            if (listener instanceof ConfigurableServerChannel.ServerChannelListener.Weak) continue;
            return;
        }
        if (this._sweeperPasses.incrementAndGet() < 3) {
            return;
        }
        this.remove();
    }

    public void remove() {
        if (this._bayeux.removeServerChannel(this)) {
            for (ServerSession subscriber : this._subscribers) {
                ((ServerSessionImpl)subscriber).unsubscribedFrom(this);
            }
            this._subscribers.clear();
        }
        this._listeners.clear();
    }

    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this._attributes.getAttributeNameSet();
    }

    public Object removeAttribute(String name) {
        Object old = this.getAttribute(name);
        this._attributes.removeAttribute(name);
        return old;
    }

    public void addAuthorizer(Authorizer authorizer) {
        this._authorizers.add(authorizer);
    }

    public void removeAuthorizer(Authorizer authorizer) {
        this._authorizers.remove(authorizer);
    }

    public List<Authorizer> getAuthorizers() {
        return List.copyOf(this.authorizers());
    }

    protected List<Authorizer> authorizers() {
        return this._authorizers;
    }

    public void dump(Appendable out, String indent) throws IOException {
        ArrayList<Object> children = new ArrayList<Object>();
        children.add(this.childrenForDump("authorizers", this.authorizers()));
        children.add(this.childrenForDump("listeners", this.listeners()));
        children.add(this.childrenForDump("subscribers", this.subscribers()));
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])children.toArray());
    }

    private Object childrenForDump(String name, Collection<?> collection) {
        if (this._bayeux.isDetailedDump()) {
            return new DumpableCollection(name, collection);
        }
        return name + " size=" + collection.size();
    }

    public String toString() {
        return this._id.toString();
    }
}

