/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.Map;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.ext.AcknowledgedMessagesSessionExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcknowledgedMessagesExtension
implements BayeuxServer.Extension {
    private final Logger _logger = LoggerFactory.getLogger((String)this.getClass().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rcvMeta(ServerSession remote, ServerMessage.Mutable message) {
        if ("/meta/handshake".equals(message.getChannel())) {
            boolean clientRequestedAcks;
            Map rcvExt = message.getExt();
            boolean bl = clientRequestedAcks = rcvExt != null && rcvExt.get("ack") == Boolean.TRUE;
            if (clientRequestedAcks && remote != null) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Enabled message acknowledgement for session {}", (Object)remote);
                }
                AcknowledgedMessagesSessionExtension extension = new AcknowledgedMessagesSessionExtension(remote);
                ServerSessionImpl session = (ServerSessionImpl)remote;
                session.getLock().lock();
                try {
                    session.addExtension(extension);
                    extension.importMessages(session);
                }
                finally {
                    session.getLock().unlock();
                }
            }
        }
        return true;
    }
}

