/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.ext.AcknowledgedMessagesExtension;
import org.cometd.server.ext.BatchArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcknowledgedMessagesSessionExtension
implements ServerSession.Extension,
ServerSession.DeQueueListener,
ServerSession.QueueListener {
    private static final Logger _logger = LoggerFactory.getLogger(AcknowledgedMessagesSessionExtension.class);
    private final List<AcknowledgedMessagesExtension.Listener> _listeners = new CopyOnWriteArrayList<AcknowledgedMessagesExtension.Listener>();
    private final Map<String, Long> _batches = new HashMap<String, Long>();
    private final ServerSessionImpl _session;
    private final BatchArrayQueue<ServerMessage> _queue;
    private long _lastBatch;

    public AcknowledgedMessagesSessionExtension(ServerSession session) {
        this._session = (ServerSessionImpl)session;
        this._queue = new BatchArrayQueue(16, this._session.getLock());
        this._session.setMetaConnectDeliveryOnly(true);
        this._session.addListener((ServerSession.ServerSessionListener)this);
    }

    void addListeners(List<AcknowledgedMessagesExtension.Listener> listeners) {
        this._listeners.addAll(listeners);
    }

    public void addListener(AcknowledgedMessagesExtension.Listener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(AcknowledgedMessagesExtension.Listener listener) {
        this._listeners.remove(listener);
    }

    public boolean rcv(ServerSession from, ServerMessage.Mutable message) {
        return true;
    }

    public boolean rcvMeta(ServerSession session, ServerMessage.Mutable message) {
        Number batchValue;
        Map ext;
        if ("/meta/connect".equals(message.getChannel()) && (ext = message.getExt(false)) != null && (batchValue = (Number)ext.get("ack")) != null) {
            this.processBatch(batchValue.longValue());
            this.updateAdvice(message);
        }
        return true;
    }

    private void updateAdvice(ServerMessage.Mutable message) {
        this._session.getLock().lock();
        try {
            Map advice;
            if (!this._session.hasNonLazyMessages() && this._session.getQueue().size() != this._queue.size() && (advice = message.getAdvice(true)).get("timeout") == null) {
                advice.put("timeout", 0L);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Forcing advice: { timeout: 0 } for {}", (Object)this._session);
                }
            }
        }
        finally {
            this._session.getLock().unlock();
        }
    }

    protected void processBatch(long batch) {
        this._session.getLock().lock();
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Processing batch: last={}, client={}, server={} for {}", new Object[]{this._lastBatch, batch, this._queue.getBatch(), this._session});
            }
            this._lastBatch = batch;
            this._queue.clearToBatch(batch);
            this.notifyBatchReceive(this._session, batch);
        }
        finally {
            this._session.getLock().unlock();
        }
    }

    public ServerMessage send(ServerSession sender, ServerSession session, ServerMessage message) {
        return message;
    }

    public void queued(ServerSession sender, ServerMessage message) {
        this._session.getLock().lock();
        try {
            this._queue.offer(message);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Stored at batch {} {} for {}", new Object[]{this._queue.getBatch(), message, this._session});
            }
        }
        finally {
            this._session.getLock().unlock();
        }
    }

    public boolean sendMeta(ServerSession sender, ServerSession to, ServerMessage.Mutable message) {
        String channel = message.getChannel();
        Map ext = message.getExt(true);
        if (channel.equals("/meta/handshake")) {
            if (this._session.isAllowMessageDeliveryDuringHandshake()) {
                long batch = this.closeBatch(message);
                HashMap<String, Comparable<Boolean>> ack = new HashMap<String, Comparable<Boolean>>(3);
                ack.put("enabled", Boolean.valueOf(true));
                ack.put("batch", Long.valueOf(batch));
                ext.put("ack", ack);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Sending batch {} for {}", (Object)batch, (Object)this._session);
                }
            } else {
                ext.put("ack", Boolean.TRUE);
            }
        } else if (channel.equals("/meta/connect")) {
            long batch = this.closeBatch(message);
            ext.put("ack", batch);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Sending batch {} for {}", (Object)batch, (Object)this._session);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long closeBatch(ServerMessage.Mutable message) {
        this._session.getLock().lock();
        try {
            long batch = this._queue.getBatch();
            this._batches.put(message.getId(), batch);
            this._queue.nextBatch();
            long l = batch;
            return l;
        }
        finally {
            this._session.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deQueue(ServerSession session, Queue<ServerMessage> queue, List<ServerMessage.Mutable> replies) {
        ServerMessage.Mutable reply = null;
        for (ServerMessage.Mutable r : replies) {
            String channel = r.getChannel();
            if (!"/meta/handshake".equals(channel) && !"/meta/connect".equals(channel)) continue;
            reply = r;
            break;
        }
        if (reply != null) {
            long batch = this._batches.remove(reply.getId());
            this._session.getLock().lock();
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Dequeuing {}/{} messages until batch {} for {} on {}", new Object[]{queue.size(), this._queue.size(), batch, reply, this._session});
                }
                queue.clear();
                this._queue.exportMessagesToBatch(queue, batch);
                this.notifyBatchSend(this._session, queue, batch);
            }
            finally {
                this._session.getLock().unlock();
            }
        }
    }

    public void deQueue(ServerSession session, Queue<ServerMessage> queue) {
    }

    protected void importMessages(ServerSessionImpl session) {
        this._session.getLock().lock();
        try {
            this._queue.addAll((Collection<ServerMessage>)session.getQueue());
        }
        finally {
            this._session.getLock().unlock();
        }
    }

    private void notifyBatchSend(ServerSession session, Queue<ServerMessage> queue, long batch) {
        List<ServerMessage> messages = null;
        for (AcknowledgedMessagesExtension.Listener listener : this._listeners) {
            if (messages == null) {
                messages = List.copyOf(queue);
            }
            try {
                listener.onBatchSend(session, messages, batch);
            }
            catch (Throwable x) {
                _logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    private void notifyBatchReceive(ServerSession session, long batch) {
        for (AcknowledgedMessagesExtension.Listener listener : this._listeners) {
            try {
                listener.onBatchReceive(session, batch);
            }
            catch (Throwable x) {
                _logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    BatchArrayQueue<ServerMessage> getBatchArrayQueue() {
        return this._queue;
    }
}

