/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.http;

import java.util.concurrent.atomic.AtomicReference;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.CometDRequest;
import org.cometd.server.http.AbstractHttpTransport;
import org.cometd.server.http.TransportContext;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpScheduler
implements Runnable,
AbstractHttpTransport.HttpScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHttpScheduler.class);
    private final AtomicReference<Scheduler.Task> task = new AtomicReference();
    private final AbstractHttpTransport transport;
    private final TransportContext context;
    private final Promise<Void> promise;
    private final ServerMessage.Mutable message;

    protected AbstractHttpScheduler(AbstractHttpTransport transport, TransportContext context, Promise<Void> promise, ServerMessage.Mutable message, long timeout) {
        this.transport = transport;
        this.context = context;
        this.promise = promise;
        this.message = message;
        this.task.set(transport.getBayeuxServer().schedule(this, timeout));
        context.metaConnectCycle(transport.newMetaConnectCycle());
    }

    public TransportContext getContext() {
        return this.context;
    }

    public Promise<Void> getPromise() {
        return this.promise;
    }

    @Override
    public ServerMessage.Mutable getMessage() {
        return this.message;
    }

    @Override
    public long getMetaConnectCycle() {
        return this.context.metaConnectCycle();
    }

    @Override
    public void schedule() {
        if (this.cancelTimeout()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resuming suspended {} for {}", (Object)this.message, (Object)this.context.session());
            }
            this.resume(false);
        }
    }

    @Override
    public void cancel(Throwable cause) {
        if (this.cancelTimeout()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cancelling suspended {} for {}", (Object)this.message, (Object)this.context.session());
            }
            this.fail(cause);
        }
    }

    @Override
    public void destroy() {
        this.cancel();
    }

    private boolean cancelTimeout() {
        Scheduler.Task task = this.task.getAndSet(null);
        if (task == null) {
            return false;
        }
        task.cancel();
        return true;
    }

    @Override
    public void run() {
        if (this.cancelTimeout()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Timing out suspended {} for {}", (Object)this.message, (Object)this.context.session());
            }
            this.resume(true);
        }
    }

    private void resume(boolean timeout) {
        this.transport.decBrowserId(this.context.session(), this.transport.isHTTP2(this.context.request()));
        this.dispatch(timeout);
    }

    protected abstract void dispatch(boolean var1);

    private void fail(Throwable failure) {
        CometDRequest request = this.context.request();
        this.transport.scheduleExpiration(this.context.session(), this.getMetaConnectCycle());
        this.transport.decBrowserId(this.context.session(), this.transport.isHTTP2(request));
        this.getPromise().fail(failure);
    }

    public String toString() {
        return String.format("%s@%x[cycle=%d]", this.getClass().getSimpleName(), this.hashCode(), this.getMetaConnectCycle());
    }
}

