/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.http.jetty;

import java.net.SocketAddress;
import java.security.Principal;
import java.util.List;
import java.util.Locale;
import org.cometd.bayeux.server.BayeuxContext;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Session;

class JettyBayeuxContext
implements BayeuxContext {
    private final Request request;

    JettyBayeuxContext(Request request) {
        this.request = request;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public SocketAddress getRemoteAddress() {
        return this.request.getConnectionMetaData().getRemoteSocketAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.request.getConnectionMetaData().getLocalSocketAddress();
    }

    public String getHeader(String name) {
        return this.request.getHeaders().get(name);
    }

    public List<String> getHeaderValues(String name) {
        return this.request.getHeaders().getValuesList(name);
    }

    public String getParameter(String name) {
        return Request.extractQueryParameters((Request)this.request).getValue(name);
    }

    public List<String> getParameterValues(String name) {
        return Request.extractQueryParameters((Request)this.request).getValues(name);
    }

    public String getCookie(String name) {
        List cookies = Request.getCookies((Request)this.request);
        if (cookies != null) {
            for (HttpCookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public Object getContextAttribute(String name) {
        return this.request.getContext().getAttribute(name);
    }

    public Object getRequestAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Object getSessionAttribute(String name) {
        Session session = this.request.getSession(false);
        return session == null ? null : session.getAttribute(name);
    }

    public String getContextPath() {
        return this.request.getContext().getContextPath();
    }

    public String getURL() {
        return this.request.getHttpURI().asString();
    }

    public List<Locale> getLocales() {
        return Request.getLocales((Request)this.request);
    }

    public String getProtocol() {
        return this.request.getConnectionMetaData().getProtocol();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }
}

