/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.http.jetty;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.cometd.server.CometDRequest;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.IO;

class JettyCometDRequest
implements CometDRequest {
    private final Request request;
    private CometDRequest.Input cometDInput;

    public JettyCometDRequest(Request request) {
        this.request = request;
    }

    public String getCharacterEncoding() {
        Charset charset = Request.getCharset((Request)this.request);
        return charset == null ? "ISO-8859-1" : charset.name();
    }

    public String getCookie(String name) {
        List cookies = Request.getCookies((Request)this.request);
        if (cookies == null) {
            return null;
        }
        for (HttpCookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public List<String> getParameterValues(String name) {
        Fields fields = Request.extractQueryParameters((Request)this.request);
        return fields.getValuesOrEmpty(name);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getProtocol() {
        return this.request.getConnectionMetaData().getProtocol();
    }

    public CometDRequest.Input getInput() {
        if (this.cometDInput == null) {
            this.cometDInput = new JettyCometDInput(this);
        }
        return this.cometDInput;
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    private static class JettyCometDInput
    implements CometDRequest.Input {
        private final JettyCometDRequest request;

        private JettyCometDInput(JettyCometDRequest request) {
            this.request = request;
        }

        public void demand(Runnable r) {
            this.request.request.demand(r);
        }

        public CometDRequest.Input.Chunk read() throws IOException {
            Content.Chunk chunk = this.request.request.read();
            if (chunk == null) {
                return null;
            }
            if (Content.Chunk.isFailure((Content.Chunk)chunk)) {
                throw IO.rethrow((Throwable)chunk.getFailure());
            }
            return new Chunk(chunk);
        }

        private static class Chunk
        implements CometDRequest.Input.Chunk {
            private final Content.Chunk chunk;

            private Chunk(Content.Chunk chunk) {
                this.chunk = chunk;
            }

            public ByteBuffer byteBuffer() {
                return this.chunk.getByteBuffer();
            }

            public boolean isLast() {
                return this.chunk.isLast();
            }

            public void release() {
                this.chunk.release();
            }

            public String toString() {
                return "%s@%x[%s]".formatted(this.getClass().getSimpleName(), this.hashCode(), this.chunk);
            }
        }
    }
}

