/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.http.jetty;

import java.util.Map;
import java.util.Objects;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.CometDRequest;
import org.cometd.server.CometDResponse;
import org.cometd.server.HttpException;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.http.AbstractHttpTransport;
import org.cometd.server.http.JSONHttpTransport;
import org.cometd.server.http.jetty.JettyBayeuxContext;
import org.cometd.server.http.jetty.JettyCometDRequest;
import org.cometd.server.http.jetty.JettyCometDResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometDHandler
extends Handler.Abstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(CometDHandler.class);
    private Map<String, String> options = Map.of();
    private BayeuxServer bayeuxServer;

    public CometDHandler() {
        this(Invocable.InvocationType.BLOCKING);
    }

    public CometDHandler(Invocable.InvocationType invocationType) {
        super(invocationType);
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = Objects.requireNonNull(options);
    }

    protected void doStart() throws Exception {
        Context context = ContextHandler.getCurrentContext((Server)this.getServer());
        this.bayeuxServer = (BayeuxServer)context.getAttribute("org.cometd.bayeux");
        boolean export = false;
        if (this.bayeuxServer == null) {
            export = true;
            this.bayeuxServer = this.newBayeuxServer();
            String transports = JSONHttpTransport.class.getName() + ",org.cometd.server.websocket.jetty.JettyWebSocketTransport";
            this.bayeuxServer.setOption("transports", (Object)transports);
            for (Map.Entry<String, String> entry : this.getOptions().entrySet()) {
                this.bayeuxServer.setOption(entry.getKey(), (Object)entry.getValue());
            }
        }
        this.bayeuxServer.setOption(Context.class.getName(), (Object)context);
        this.addBean(this.bayeuxServer);
        if (export) {
            context.setAttribute("org.cometd.bayeux", (Object)this.bayeuxServer);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        for (ServerSession session : this.bayeuxServer.getSessions()) {
            ((ServerSessionImpl)session).destroyScheduler();
        }
        super.doStop();
        this.removeBean(this.bayeuxServer);
        this.bayeuxServer = null;
        Context context = ContextHandler.getCurrentContext((Server)this.getServer());
        context.removeAttribute("org.cometd.bayeux");
    }

    public BayeuxServer getBayeuxServer() {
        return this.bayeuxServer;
    }

    protected BayeuxServer newBayeuxServer() {
        return new BayeuxServerImpl();
    }

    public boolean handle(final Request request, final Response response, final Callback callback) {
        if (HttpMethod.OPTIONS.is(request.getMethod())) {
            this.serviceOptions(request, response, callback);
            return true;
        }
        JettyCometDRequest cometDRequest = new JettyCometDRequest(request);
        JettyCometDResponse cometDResponse = new JettyCometDResponse(response);
        JettyBayeuxContext bayeuxContext = new JettyBayeuxContext(request);
        Promise<Void> promise = new Promise<Void>(this){
            final /* synthetic */ CometDHandler this$0;
            {
                this.this$0 = this$0;
            }

            public void succeed(Void result) {
                callback.succeeded();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Handling successful");
                }
            }

            public void fail(Throwable failure) {
                int code = 500;
                Throwable cause = failure;
                if (failure instanceof HttpException) {
                    HttpException http = (HttpException)failure;
                    code = http.getCode();
                    cause = http.getCause();
                }
                this.this$0.sendError(request, response, callback, code, cause);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Handling failed", failure);
                }
            }
        };
        AbstractHttpTransport transport = AbstractHttpTransport.find((BayeuxServer)this.bayeuxServer, (CometDRequest)cometDRequest);
        if (transport == null) {
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)400, (String)"Unknown Bayeux Transport");
        } else {
            request.addIdleTimeoutListener(x -> false);
            transport.handle((BayeuxContext)bayeuxContext, (CometDRequest)cometDRequest, (CometDResponse)cometDResponse, (Promise)promise);
        }
        return true;
    }

    protected void serviceOptions(Request request, Response response, Callback callback) {
        callback.succeeded();
    }

    protected void sendError(Request request, Response response, Callback callback, int code, Throwable failure) {
        Response.writeError((Request)request, (Response)response, (Callback)callback, (int)code, null, (Throwable)failure);
    }
}

