/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.http.jetty;

import java.nio.ByteBuffer;
import org.cometd.bayeux.Promise;
import org.cometd.server.CometDResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

class JettyCometDResponse
implements CometDResponse {
    private final Response response;
    private CometDResponse.Output cometDOutput;

    JettyCometDResponse(Response response) {
        this.response = response;
    }

    public void addHeader(String name, String value) {
        this.response.getHeaders().add(name, value);
    }

    public CometDResponse.Output getOutput() {
        if (this.cometDOutput == null) {
            this.cometDOutput = new JettyCometDOutput(Response.asBufferedSink((Request)this.response.getRequest(), (Response)this.response));
        }
        return this.cometDOutput;
    }

    public void setContentType(String contentType) {
        this.response.getHeaders().put(HttpHeader.CONTENT_TYPE, contentType);
    }

    private static class JettyCometDOutput
    implements CometDResponse.Output {
        private final Content.Sink sink;

        private JettyCometDOutput(Content.Sink sink) {
            this.sink = sink;
        }

        public void write(boolean last, byte[] bytes, final Promise<Void> promise) {
            this.sink.write(last, ByteBuffer.wrap(bytes), new Callback(){

                public void succeeded() {
                    promise.succeed(null);
                }

                public void failed(Throwable x) {
                    promise.fail(x);
                }
            });
        }
    }
}

