/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.websocket.javax;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.websocket.DeploymentException;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.websocket.common.AbstractBayeuxContext;
import org.cometd.server.websocket.common.AbstractWebSocketEndPoint;
import org.cometd.server.websocket.common.AbstractWebSocketTransport;
import org.cometd.server.websocket.javax.WebSocketEndPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends AbstractWebSocketTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketTransport.class);

    public WebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux);
    }

    public void init() {
        super.init();
        ServletContext context = (ServletContext)this.getOption(ServletContext.class.getName());
        if (context == null) {
            throw new IllegalArgumentException("Missing ServletContext");
        }
        String cometdURLMapping = (String)this.getOption("cometdURLMapping");
        if (cometdURLMapping == null) {
            throw new IllegalArgumentException("Missing 'cometdURLMapping' parameter");
        }
        ServerContainer container = (ServerContainer)context.getAttribute(ServerContainer.class.getName());
        if (container == null) {
            throw new IllegalArgumentException("Missing WebSocket ServerContainer");
        }
        int maxMessageSize = this.getMaxMessageSize();
        if (maxMessageSize < 0) {
            maxMessageSize = container.getDefaultMaxTextMessageBufferSize();
        }
        container.setDefaultMaxTextMessageBufferSize(maxMessageSize);
        long idleTimeout = this.getOption("idleTimeout", container.getDefaultMaxSessionIdleTimeout());
        container.setDefaultMaxSessionIdleTimeout(idleTimeout);
        String protocol = this.getProtocol();
        List<String> protocols = protocol == null ? null : Collections.singletonList(protocol);
        Configurator configurator = new Configurator(context);
        for (String mapping : this.normalizeURLMapping(cometdURLMapping)) {
            ServerEndpointConfig config = ServerEndpointConfig.Builder.create(WebSocketEndPoint.class, (String)mapping).subprotocols(protocols).configurator((ServerEndpointConfig.Configurator)configurator).build();
            try {
                container.addEndpoint(config);
            }
            catch (DeploymentException x) {
                throw new RuntimeException(x);
            }
        }
    }

    protected boolean checkOrigin(String origin) {
        return true;
    }

    protected void modifyHandshake(HandshakeRequest request, HandshakeResponse response) {
    }

    protected Object newWebSocketEndPoint(BayeuxContext bayeuxContext) {
        return new EndPoint(bayeuxContext);
    }

    private static List<Locale> retrieveLocales(Map<String, Object> userProperties) {
        List locales = (List)userProperties.get("javax.websocket.upgrade.locales");
        if (locales == null || locales.isEmpty()) {
            return Collections.singletonList(Locale.getDefault());
        }
        return locales;
    }

    private static boolean isSecure(HandshakeRequest request) {
        String scheme = request.getRequestURI().getScheme();
        return "https".equalsIgnoreCase(scheme) || "wss".equalsIgnoreCase(scheme);
    }

    private class EndPoint
    extends WebSocketEndPoint {
        private EndPoint(BayeuxContext bayeuxContext) {
            super(WebSocketTransport.this, bayeuxContext);
        }

        @Override
        protected void writeComplete(AbstractWebSocketEndPoint.Context context, List<ServerMessage> messages) {
            WebSocketTransport.this.writeComplete(context, messages);
        }
    }

    private static class BayeuxContextHolder {
        private static final ThreadLocal<BayeuxContextHolder> holder = new ThreadLocal();
        private WebSocketContext bayeuxContext;
        private boolean protocolMatches;

        private BayeuxContextHolder() {
        }

        public void clear() {
            holder.set(null);
            this.bayeuxContext = null;
            this.protocolMatches = true;
        }
    }

    private class Configurator
    extends ServerEndpointConfig.Configurator {
        private final ServletContext servletContext;

        private Configurator(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
            BayeuxContextHolder context = this.provideContext();
            context.bayeuxContext = new WebSocketContext(this.servletContext, request, sec.getUserProperties());
            WebSocketTransport.this.modifyHandshake(request, response);
        }

        public boolean checkOrigin(String originHeaderValue) {
            return WebSocketTransport.this.checkOrigin(originHeaderValue);
        }

        public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
            BayeuxContextHolder context = this.provideContext();
            context.protocolMatches = this.checkProtocol(supported, requested);
            if (context.protocolMatches) {
                return super.getNegotiatedSubprotocol(supported, requested);
            }
            LOGGER.warn("Could not negotiate WebSocket SubProtocols: server{} != client{}", supported, requested);
            return null;
        }

        public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
            LinkedHashSet<Extension> negotiated = new LinkedHashSet<Extension>();
            block0: for (Extension requestedExtension : requested) {
                String name = requestedExtension.getName();
                boolean option = WebSocketTransport.this.getOption("enableExtension." + name, true);
                if (!option) continue;
                for (Extension installedExtension : installed) {
                    if (!installedExtension.getName().equals(name)) continue;
                    negotiated.add(requestedExtension);
                    continue block0;
                }
            }
            return new ArrayList<Extension>(negotiated);
        }

        public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
            BayeuxContextHolder holder = this.provideContext();
            if (!WebSocketTransport.this.getBayeux().getAllowedTransports().contains(WebSocketTransport.this.getName())) {
                throw new InstantiationException("Transport not allowed");
            }
            if (!holder.protocolMatches) {
                throw new InstantiationException("Could not negotiate WebSocket SubProtocols");
            }
            Object instance = WebSocketTransport.this.newWebSocketEndPoint((BayeuxContext)holder.bayeuxContext);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created {}", instance);
            }
            holder.clear();
            return (T)instance;
        }

        private boolean checkProtocol(List<String> serverProtocols, List<String> clientProtocols) {
            if (serverProtocols.isEmpty()) {
                return true;
            }
            for (String clientProtocol : clientProtocols) {
                if (!serverProtocols.contains(clientProtocol)) continue;
                return true;
            }
            return false;
        }

        private BayeuxContextHolder provideContext() {
            BayeuxContextHolder holder = (BayeuxContextHolder)BayeuxContextHolder.holder.get();
            if (holder == null) {
                holder = new BayeuxContextHolder();
                holder.clear();
                BayeuxContextHolder.holder.set(holder);
            }
            return holder;
        }
    }

    private static class WebSocketContext
    extends AbstractBayeuxContext {
        private WebSocketContext(ServletContext context, HandshakeRequest request, Map<String, Object> userProperties) {
            super(context, request.getRequestURI().toString(), request.getQueryString(), request.getHeaders(), request.getParameterMap(), request.getUserPrincipal(), (HttpSession)request.getHttpSession(), (InetSocketAddress)userProperties.get("javax.websocket.endpoint.localAddress"), (InetSocketAddress)userProperties.get("javax.websocket.endpoint.remoteAddress"), WebSocketTransport.retrieveLocales(userProperties), "HTTP/1.1", WebSocketTransport.isSecure(request));
        }
    }
}

