/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.websocket.javax;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.websocket.common.AbstractWebSocketEndPoint;
import org.cometd.server.websocket.common.AbstractWebSocketTransport;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketEndPoint
extends Endpoint
implements MessageHandler.Whole<String> {
    private final Logger _logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AbstractWebSocketEndPoint _delegate;
    private volatile Session _wsSession;

    public WebSocketEndPoint(AbstractWebSocketTransport transport, BayeuxContext bayeuxContext) {
        this._delegate = new Delegate(transport, bayeuxContext);
    }

    public void onOpen(Session wsSession, EndpointConfig config) {
        this._wsSession = wsSession;
        wsSession.addMessageHandler((MessageHandler)this);
    }

    public void onMessage(String data) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("WebSocket Text message on {}@{}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)Integer.toHexString(((Object)((Object)this)).hashCode()));
        }
        try {
            try {
                Promise.Completable completable = new Promise.Completable();
                this._delegate.onMessage(data, (Promise)completable);
                completable.get();
            }
            catch (ExecutionException x) {
                throw x.getCause();
            }
        }
        catch (Throwable failure) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("", failure);
            }
            this._delegate.close(1011, failure.toString());
        }
    }

    public void onClose(Session wsSession, CloseReason closeReason) {
        this._delegate.onClose(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
    }

    public void onError(Session wsSession, Throwable failure) {
        this._delegate.onError(failure);
    }

    protected void writeComplete(AbstractWebSocketEndPoint.Context context, List<ServerMessage> messages) {
    }

    private class Delegate
    extends AbstractWebSocketEndPoint {
        public Delegate(AbstractWebSocketTransport transport, BayeuxContext bayeuxContext) {
            super(transport, bayeuxContext);
        }

        protected void send(ServerSession session, String data, Callback callback) {
            if (WebSocketEndPoint.this._logger.isDebugEnabled()) {
                WebSocketEndPoint.this._logger.debug("Sending {}", (Object)data);
            }
            WebSocketEndPoint.this._wsSession.getAsyncRemote().sendText(data, result -> {
                Throwable failure = result.getException();
                if (failure == null) {
                    callback.succeeded();
                } else {
                    callback.failed(failure);
                }
            });
        }

        public void close(int code, String reason) {
            try {
                reason = reason.substring(0, Math.min(reason.length(), 30));
                if (WebSocketEndPoint.this._logger.isDebugEnabled()) {
                    WebSocketEndPoint.this._logger.debug("Closing {}/{}", (Object)code, (Object)reason);
                }
                WebSocketEndPoint.this._wsSession.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)code), reason));
            }
            catch (Throwable x) {
                WebSocketEndPoint.this._logger.trace("Could not close WebSocket session " + WebSocketEndPoint.this._wsSession, x);
            }
        }

        protected void writeComplete(AbstractWebSocketEndPoint.Context context, List<ServerMessage> messages) {
            WebSocketEndPoint.this.writeComplete(context, messages);
        }
    }
}

