/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.websocket.jetty;

import java.util.concurrent.ExecutionException;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.websocket.common.AbstractWebSocketEndPoint;
import org.cometd.server.websocket.common.AbstractWebSocketTransport;
import org.cometd.server.websocket.jetty.JettyWebSocketTransport;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketEndPoint
extends AbstractWebSocketEndPoint
implements WebSocketListener {
    private final Logger _logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private volatile Session _wsSession;

    public JettyWebSocketEndPoint(JettyWebSocketTransport transport, BayeuxContext context) {
        super((AbstractWebSocketTransport)transport, context);
    }

    public void onWebSocketConnect(Session session) {
        this._wsSession = session;
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
    }

    public void onWebSocketText(String data) {
        try {
            try {
                Promise.Completable completable = new Promise.Completable();
                this.onMessage(data, (Promise)completable);
                completable.get();
            }
            catch (ExecutionException x) {
                throw x.getCause();
            }
        }
        catch (Throwable failure) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("", failure);
            }
            this.close(1011, failure.toString());
        }
    }

    public void onWebSocketClose(int code, String reason) {
        this.onClose(code, reason);
    }

    public void onWebSocketError(Throwable failure) {
        this.onError(failure);
    }

    protected void send(ServerSession session, String data, final Callback callback) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Sending {} on {}", (Object)data, (Object)this);
        }
        this._wsSession.getRemote().sendString(data, new WriteCallback(){

            public void writeSuccess() {
                callback.succeeded();
            }

            public void writeFailed(Throwable x) {
                callback.failed(x);
            }
        });
    }

    public void close(int code, String reason) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Closing {}/{} on {}", new Object[]{code, reason, this});
        }
        this._wsSession.close(code, reason);
    }

    public String toString() {
        return String.format("%s[%s]", super.toString(), this._wsSession);
    }
}

