/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.websocket.jetty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.websocket.common.AbstractBayeuxContext;
import org.cometd.server.websocket.common.AbstractWebSocketEndPoint;
import org.cometd.server.websocket.common.AbstractWebSocketTransport;
import org.cometd.server.websocket.jetty.JettyWebSocketEndPoint;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketTransport
extends AbstractWebSocketTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyWebSocketTransport.class);

    public JettyWebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux);
    }

    public void init() {
        super.init();
        ServletContext context = (ServletContext)this.getOption(ServletContext.class.getName());
        if (context == null) {
            throw new IllegalArgumentException("Missing ServletContext");
        }
        String cometdURLMapping = (String)this.getOption("cometdURLMapping");
        if (cometdURLMapping == null) {
            throw new IllegalArgumentException("Missing 'cometdURLMapping' parameter");
        }
        NativeWebSocketConfiguration wsConfig = (NativeWebSocketConfiguration)context.getAttribute(NativeWebSocketConfiguration.class.getName());
        if (wsConfig == null) {
            throw new IllegalArgumentException("Missing WebSocketConfiguration");
        }
        WebSocketPolicy policy = wsConfig.getFactory().getPolicy();
        int bufferSize = this.getOption("bufferSize", policy.getInputBufferSize());
        policy.setInputBufferSize(bufferSize);
        int maxMessageSize = this.getMaxMessageSize();
        if (maxMessageSize < 0) {
            maxMessageSize = policy.getMaxTextMessageSize();
        }
        policy.setMaxTextMessageSize(maxMessageSize);
        long idleTimeout = this.getOption("idleTimeout", policy.getIdleTimeout());
        policy.setIdleTimeout((long)((int)idleTimeout));
        for (String mapping : this.normalizeURLMapping(cometdURLMapping)) {
            wsConfig.addMapping(mapping, (request, response) -> {
                String origin = request.getHeader("Origin");
                if (origin == null) {
                    origin = request.getHeader("Sec-WebSocket-Origin");
                }
                if (this.checkOrigin(request, origin)) {
                    ArrayList<ExtensionConfig> negotiated = new ArrayList<ExtensionConfig>();
                    for (ExtensionConfig extensionConfig : request.getExtensions()) {
                        String name = extensionConfig.getName();
                        boolean option = this.getOption("enableExtension." + name, true);
                        if (!option) continue;
                        negotiated.add(extensionConfig);
                    }
                    response.setExtensions(negotiated);
                    this.modifyUpgrade(request, response);
                    List allowedTransports = this.getBayeux().getAllowedTransports();
                    if (allowedTransports.contains(this.getName())) {
                        WebSocketContext handshake = new WebSocketContext(context, request);
                        Object instance = this.newWebSocketEndPoint((BayeuxContext)handshake);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Created {}", instance);
                        }
                        return instance;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Transport not those allowed: {}", (Object)allowedTransports);
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Origin check failed for origin {}", (Object)origin);
                }
                return null;
            });
        }
    }

    protected Object newWebSocketEndPoint(BayeuxContext bayeuxContext) {
        return new EndPoint(bayeuxContext);
    }

    protected void modifyUpgrade(ServletUpgradeRequest request, ServletUpgradeResponse response) {
    }

    protected boolean checkOrigin(ServletUpgradeRequest request, String origin) {
        return true;
    }

    private class EndPoint
    extends JettyWebSocketEndPoint {
        public EndPoint(BayeuxContext bayeuxContext) {
            super(JettyWebSocketTransport.this, bayeuxContext);
        }

        protected void writeComplete(AbstractWebSocketEndPoint.Context context, List<ServerMessage> messages) {
            JettyWebSocketTransport.this.writeComplete(context, messages);
        }
    }

    private static class WebSocketContext
    extends AbstractBayeuxContext {
        private final Map<String, Object> attributes;

        private WebSocketContext(ServletContext context, ServletUpgradeRequest request) {
            super(context, request.getRequestURI().toString(), request.getQueryString(), request.getHeaders(), request.getParameterMap(), request.getUserPrincipal(), request.getSession(), request.getLocalSocketAddress(), request.getRemoteSocketAddress(), Collections.list(request.getLocales()), "HTTP/1.1", request.isSecure());
            this.attributes = request.getServletAttributes();
        }

        public Object getRequestAttribute(String name) {
            return this.attributes.get(name);
        }
    }
}

