/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.websocket.jetty;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.websocket.common.AbstractBayeuxContext;
import org.cometd.server.websocket.common.AbstractWebSocketEndPoint;
import org.cometd.server.websocket.common.AbstractWebSocketTransport;
import org.cometd.server.websocket.jetty.JettyWebSocketEndPoint;
import org.eclipse.jetty.websocket.api.ExtensionConfig;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketTransport
extends AbstractWebSocketTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyWebSocketTransport.class);

    public JettyWebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux);
    }

    public void init() {
        super.init();
        ServletContext context = (ServletContext)this.getOption(ServletContext.class.getName());
        if (context == null) {
            throw new IllegalArgumentException("Missing ServletContext");
        }
        String cometdURLMapping = (String)this.getOption("cometdURLMapping");
        if (cometdURLMapping == null) {
            throw new IllegalArgumentException("Missing 'cometdURLMapping' parameter");
        }
        JettyWebSocketServerContainer container = JettyWebSocketServerContainer.ensureContainer((ServletContext)context);
        if (container == null) {
            throw new IllegalArgumentException("Missing JettyWebSocketServerContainer");
        }
        int bufferSize = this.getOption("bufferSize", container.getInputBufferSize());
        container.setInputBufferSize(bufferSize);
        long maxMessageSize = this.getMaxMessageSize();
        if (maxMessageSize < 0L) {
            maxMessageSize = container.getMaxTextMessageSize();
        }
        container.setMaxTextMessageSize(maxMessageSize);
        long idleTimeout = this.getOption("idleTimeout", container.getIdleTimeout().toMillis());
        container.setIdleTimeout(Duration.ofMillis(idleTimeout));
        for (String mapping : this.normalizeURLMapping(cometdURLMapping)) {
            container.addMapping(mapping, (request, response) -> {
                String origin = request.getHeader("Origin");
                if (origin == null) {
                    origin = request.getHeader("Sec-WebSocket-Origin");
                }
                if (this.checkOrigin(request, origin)) {
                    ArrayList<ExtensionConfig> negotiated = new ArrayList<ExtensionConfig>();
                    for (ExtensionConfig extensionConfig : request.getExtensions()) {
                        String name = extensionConfig.getName();
                        boolean option = this.getOption("enableExtension." + name, true);
                        if (!option) continue;
                        negotiated.add(extensionConfig);
                    }
                    response.setExtensions(negotiated);
                    this.modifyUpgrade(request, response);
                    List allowedTransports = this.getBayeux().getAllowedTransports();
                    if (allowedTransports.contains(this.getName())) {
                        WebSocketContext handshake = new WebSocketContext(context, request);
                        return this.newWebSocketEndPoint((BayeuxContext)handshake);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Transport not those allowed: {}", (Object)allowedTransports);
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Origin check failed for origin {}", (Object)origin);
                }
                return null;
            });
        }
    }

    protected Object newWebSocketEndPoint(BayeuxContext bayeuxContext) {
        return new EndPoint(bayeuxContext);
    }

    protected void modifyUpgrade(JettyServerUpgradeRequest request, JettyServerUpgradeResponse response) {
    }

    protected boolean checkOrigin(JettyServerUpgradeRequest request, String origin) {
        return true;
    }

    public class EndPoint
    extends JettyWebSocketEndPoint {
        public EndPoint(BayeuxContext bayeuxContext) {
            super(JettyWebSocketTransport.this, bayeuxContext);
        }

        protected void writeComplete(AbstractWebSocketEndPoint.Context context, List<ServerMessage> messages) {
            JettyWebSocketTransport.this.writeComplete(context, messages);
        }
    }

    private static class WebSocketContext
    extends AbstractBayeuxContext {
        private final Map<String, Object> attributes;

        private WebSocketContext(ServletContext context, JettyServerUpgradeRequest request) {
            super(context, request.getRequestURI().toString(), request.getQueryString(), request.getHeaders(), request.getParameterMap(), request.getUserPrincipal(), (HttpSession)request.getSession(), (InetSocketAddress)request.getLocalSocketAddress(), (InetSocketAddress)request.getRemoteSocketAddress(), Collections.list(request.getLocales()), "HTTP/1.1", request.isSecure());
            this.attributes = request.getServletAttributes();
        }

        public Object getRequestAttribute(String name) {
            return this.attributes.get(name);
        }
    }
}

