/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.websocket.jetty;

import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.websocket.common.AbstractBayeuxContext;
import org.cometd.server.websocket.common.AbstractWebSocketEndPoint;
import org.cometd.server.websocket.common.AbstractWebSocketTransport;
import org.cometd.server.websocket.jetty.JettyWebSocketEndPoint;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.websocket.api.ExtensionConfig;
import org.eclipse.jetty.websocket.server.ServerUpgradeRequest;
import org.eclipse.jetty.websocket.server.ServerUpgradeResponse;
import org.eclipse.jetty.websocket.server.ServerWebSocketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketTransport
extends AbstractWebSocketTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyWebSocketTransport.class);

    public JettyWebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux);
    }

    public void init() {
        super.init();
        Context context = (Context)this.getBayeuxServer().getOption(Context.class.getName());
        if (context == null) {
            throw new IllegalArgumentException("Missing Context");
        }
        String cometdURLMapping = (String)this.getOption("cometdURLMapping");
        if (cometdURLMapping == null) {
            throw new IllegalArgumentException("Missing 'cometdURLMapping' parameter");
        }
        ServerWebSocketContainer container = ServerWebSocketContainer.get((Context)context);
        if (container == null) {
            throw new IllegalArgumentException("Missing JettyWebSocketServerContainer");
        }
        int bufferSize = this.getOption("bufferSize", container.getInputBufferSize());
        container.setInputBufferSize(bufferSize);
        long maxMessageSize = this.getMaxMessageSize();
        if (maxMessageSize < 0L) {
            maxMessageSize = container.getMaxTextMessageSize();
        }
        container.setMaxTextMessageSize(maxMessageSize);
        long idleTimeout = this.getOption("idleTimeout", container.getIdleTimeout().toMillis());
        container.setIdleTimeout(Duration.ofMillis(idleTimeout));
        for (String mapping : this.normalizeURLMapping(cometdURLMapping)) {
            container.addMapping(mapping, (request, response, callback) -> {
                String origin = request.getHeaders().get("Origin");
                if (origin == null) {
                    origin = request.getHeaders().get("Sec-WebSocket-Origin");
                }
                if (this.checkOrigin(request, origin)) {
                    ArrayList<ExtensionConfig> negotiated = new ArrayList<ExtensionConfig>();
                    for (ExtensionConfig extensionConfig : request.getExtensions()) {
                        String name = extensionConfig.getName();
                        boolean option = this.getOption("enableExtension." + name, true);
                        if (!option) continue;
                        negotiated.add(extensionConfig);
                    }
                    response.setExtensions(negotiated);
                    this.modifyUpgrade(request, response);
                    List allowedTransports = this.getBayeuxServer().getAllowedTransports();
                    if (allowedTransports.contains(this.getName())) {
                        JettyWebSocketContext handshake = new JettyWebSocketContext(request);
                        Object instance = this.newWebSocketEndPoint((BayeuxContext)handshake);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Created {}", instance);
                        }
                        return instance;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Transport not those allowed: {}", (Object)allowedTransports);
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Origin check failed for origin {}", (Object)origin);
                }
                return null;
            });
        }
    }

    protected Object newWebSocketEndPoint(BayeuxContext bayeuxContext) {
        return new EndPoint(bayeuxContext);
    }

    protected void modifyUpgrade(ServerUpgradeRequest request, ServerUpgradeResponse response) {
    }

    protected boolean checkOrigin(ServerUpgradeRequest request, String origin) {
        return true;
    }

    public class EndPoint
    extends JettyWebSocketEndPoint {
        public EndPoint(BayeuxContext bayeuxContext) {
            super(JettyWebSocketTransport.this, bayeuxContext);
        }

        protected void writeComplete(AbstractWebSocketEndPoint.Context context, List<ServerMessage> messages) {
            JettyWebSocketTransport.this.writeComplete(context, messages);
        }
    }

    private static class JettyWebSocketContext
    extends AbstractBayeuxContext {
        private final Map<String, Object> contextAttributes;
        private final Map<String, Object> requestAttributes;
        private final String sessionId;
        private final Map<String, Object> sessionAttributes;

        private JettyWebSocketContext(ServerUpgradeRequest request) {
            super(request.getHttpURI().toString(), request.getContext().getContextPath(), null, JettyWebSocketContext.headersToMap(request), JettyWebSocketContext.queryToMap(request), null, request.getConnectionMetaData().getLocalSocketAddress(), request.getConnectionMetaData().getRemoteSocketAddress(), Request.getLocales((Request)request), "HTTP/1.1", request.isSecure());
            this.contextAttributes = Map.copyOf(request.getContext().asAttributeMap());
            this.requestAttributes = Map.copyOf(request.asAttributeMap());
            Session session = request.getSession(false);
            this.sessionId = session == null ? null : session.getId();
            this.sessionAttributes = session == null ? Map.of() : Map.copyOf(session.asAttributeMap());
        }

        private static Map<String, List<String>> headersToMap(ServerUpgradeRequest request) {
            HttpFields headers = request.getHeaders();
            LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
            headers.forEach(field -> {
                String name = field.getName();
                result.compute(name, (k, v) -> {
                    if (v == null) {
                        v = new ArrayList(1);
                    }
                    v.addAll(field.getValueList());
                    return v;
                });
            });
            return result;
        }

        private static Map<String, List<String>> queryToMap(ServerUpgradeRequest request) {
            Fields fields = Request.extractQueryParameters((Request)request);
            LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
            fields.forEach(field -> {
                String name = field.getName();
                result.compute(name, (k, v) -> {
                    if (v == null) {
                        v = new ArrayList(1);
                    }
                    v.addAll(field.getValues());
                    return v;
                });
            });
            return result;
        }

        public Object getContextAttribute(String name) {
            return this.contextAttributes.get(name);
        }

        public Object getRequestAttribute(String name) {
            return this.requestAttributes.get(name);
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Object getSessionAttribute(String name) {
            return this.sessionAttributes.get(name);
        }
    }
}

