/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.cometd.Channel;
import org.cometd.ChannelBayeuxListener;
import org.cometd.ChannelListener;
import org.cometd.Client;
import org.cometd.DataFilter;
import org.cometd.Message;
import org.cometd.SubscriptionListener;
import org.cometd.server.AbstractBayeux;
import org.cometd.server.ChannelId;
import org.cometd.server.ClientImpl;
import org.cometd.server.MessageImpl;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelImpl
implements Channel {
    private final AbstractBayeux _bayeux;
    private final ChannelId _id;
    private final ConcurrentHashMap<String, ChannelImpl> _children = new ConcurrentHashMap();
    private volatile ClientImpl[] _subscribers = new ClientImpl[0];
    private volatile DataFilter[] _dataFilters = new DataFilter[0];
    private volatile SubscriptionListener[] _subscriptionListeners = new SubscriptionListener[0];
    private volatile ChannelImpl _wild;
    private volatile ChannelImpl _wildWild;
    private volatile boolean _persistent;
    private volatile int _split;
    private volatile boolean _lazy;

    protected ChannelImpl(String id, AbstractBayeux bayeux) {
        this._id = new ChannelId(id);
        this._bayeux = bayeux;
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    public ChannelImpl addChild(ChannelImpl channel) {
        ChannelId child = channel.getChannelId();
        if (!this._id.isParentOf(child)) {
            throw new IllegalArgumentException(this._id + " not parent of " + child);
        }
        String next = child.getSegment(this._id.depth());
        if (child.depth() - this._id.depth() == 1) {
            ChannelImpl old = this._children.putIfAbsent(next, channel);
            if (old != null) {
                return old;
            }
            if ("*".equals(next)) {
                this._wild = channel;
            } else if ("**".equals(next)) {
                this._wildWild = channel;
            }
            this._bayeux.addChannel(channel);
            return channel;
        }
        ChannelImpl branch = (ChannelImpl)this._bayeux.getChannel((this._id.depth() == 0 ? "/" : this._id.toString() + "/") + next, true);
        return branch.addChild(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataFilter(DataFilter filter) {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this._dataFilters = (DataFilter[])LazyList.addToArray((Object[])this._dataFilters, (Object)filter, null);
        }
    }

    public ChannelId getChannelId() {
        return this._id;
    }

    public ChannelImpl getChild(ChannelId id) {
        String next = id.getSegment(this._id.depth());
        if (next == null) {
            return null;
        }
        ChannelImpl channel = this._children.get(next);
        if (channel == null || channel.getChannelId().depth() == id.depth()) {
            return channel;
        }
        return channel.getChild(id);
    }

    public void getChannels(List<Channel> list) {
        list.add(this);
        for (ChannelImpl channel : this._children.values()) {
            channel.getChannels(list);
        }
    }

    public int getChannelCount() {
        return this._children.size();
    }

    public String getId() {
        return this._id.toString();
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public void deliver(Client from, Iterable<Client> to, Object data, String id) {
        Message m;
        MessageImpl message = this._bayeux.newMessage();
        message.put("channel", (Object)this.getId());
        message.put("data", data);
        if (id != null) {
            message.put("id", (Object)id);
        }
        if ((m = this._bayeux.extendSendBayeux(from, message)) != null) {
            for (Client t : to) {
                ((ClientImpl)t).doDelivery(from, m);
            }
        }
        if (m instanceof MessageImpl) {
            ((MessageImpl)m).decRef();
        }
    }

    public void publish(Client fromClient, Object data, String msgId) {
        this._bayeux.doPublish(this.getChannelId(), fromClient, data, msgId, false);
    }

    public void publishLazy(Client fromClient, Object data, String msgId) {
        this._bayeux.doPublish(this.getChannelId(), fromClient, data, msgId, true);
    }

    public boolean remove() {
        return this._bayeux.removeChannel(this);
    }

    public boolean doRemove(ChannelImpl channel, List<ChannelBayeuxListener> listeners) {
        String key;
        ChannelImpl child;
        ChannelId channelId = channel.getChannelId();
        int diff = channel._id.depth() - this._id.depth();
        if (diff >= 1 && (child = this._children.get(key = channelId.getSegment(this._id.depth()))) != null) {
            if (diff == 1) {
                if (!child.isPersistent()) {
                    child = this._children.remove(key);
                    if (child != null) {
                        if (this._wild == channel) {
                            this._wild = null;
                        } else if (this._wildWild == channel) {
                            this._wildWild = null;
                        }
                        if (child.getChannelCount() > 0) {
                            for (ChannelImpl c : child._children.values()) {
                                child.doRemove(c, listeners);
                            }
                        }
                        for (ChannelBayeuxListener l : listeners) {
                            l.channelRemoved((Channel)child);
                        }
                    }
                    return true;
                }
                return false;
            }
            boolean removed = child.doRemove(channel, listeners);
            if (removed && !child.isPersistent() && child.getChannelCount() == 0 && child.getSubscriberCount() == 0 && (child = this._children.remove(key)) != null) {
                for (ChannelBayeuxListener l : listeners) {
                    l.channelRemoved((Channel)child);
                }
            }
            return removed;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFilter removeDataFilter(DataFilter filter) {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this._dataFilters = (DataFilter[])LazyList.removeFromArray((Object[])this._dataFilters, (Object)filter);
            return filter;
        }
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Client client) {
        if (!(client instanceof ClientImpl)) {
            throw new IllegalArgumentException("Client instance not obtained from Bayeux.newClient()");
        }
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            for (ClientImpl clientImpl : this._subscribers) {
                if (!client.equals(clientImpl)) continue;
                return;
            }
            this._subscribers = (ClientImpl[])LazyList.addToArray((Object[])this._subscribers, (Object)client, null);
        }
        SubscriptionListener[] listeners = this._subscriptionListeners;
        for (ClientImpl clientImpl : listeners) {
            clientImpl.subscribed(client, this);
        }
        ((ClientImpl)client).addSubscription(this);
    }

    public String toString() {
        return this._id.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Client client) {
        if (!(client instanceof ClientImpl)) {
            throw new IllegalArgumentException("Client instance not obtained from Bayeux.newClient()");
        }
        ((ClientImpl)client).removeSubscription(this);
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this._subscribers = (ClientImpl[])LazyList.removeFromArray((Object[])this._subscribers, (Object)client);
        }
        for (SubscriptionListener l : this._subscriptionListeners) {
            l.unsubscribed(client, (Channel)this);
        }
        if (!this._persistent && this._subscribers.length == 0 && this._children.size() == 0) {
            this.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doDelivery(ChannelId to, Client from, Message msg) {
        int tail = to.depth() - this._id.depth();
        Object data = msg.getData();
        if (data != null) {
            Object old = data;
            try {
                switch (tail) {
                    case 0: {
                        DataFilter[] filters;
                        for (DataFilter dataFilter : filters = this._dataFilters) {
                            if ((data = dataFilter.filter(from, (Channel)this, data)) != null) continue;
                            return;
                        }
                        break;
                    }
                    case 1: {
                        ChannelImpl wild = this._wild;
                        if (wild != null) {
                            void var11_34;
                            DataFilter[] dataFilterArray;
                            DataFilter[] arr$ = dataFilterArray = wild._dataFilters;
                            int len$ = arr$.length;
                            boolean bl = false;
                            while (var11_34 < len$) {
                                DataFilter filter = arr$[var11_34];
                                if ((data = filter.filter(from, (Channel)this, data)) == null) {
                                    return;
                                }
                                ++var11_34;
                            }
                        }
                    }
                    default: {
                        ChannelImpl channelImpl = this._wildWild;
                        if (channelImpl != null) {
                            DataFilter[] filters;
                            for (DataFilter filter : filters = channelImpl._dataFilters) {
                                if ((data = filter.filter(from, (Channel)this, data)) != null) continue;
                                return;
                            }
                        }
                    }
                }
            }
            catch (IllegalStateException e) {
                Log.ignore((Throwable)e);
                return;
            }
            if (data != old) {
                msg.put((Object)"data", data);
            }
        }
        switch (tail) {
            case 0: {
                void var8_17;
                void var8_15;
                int split;
                ClientImpl[] subscribers;
                if (this._lazy && msg instanceof MessageImpl) {
                    ((MessageImpl)msg).setLazy(true);
                }
                if ((subscribers = this._subscribers).length <= 0) break;
                int n = split = this._split++ % subscribers.length;
                while (var8_15 < subscribers.length) {
                    subscribers[var8_15].doDelivery(from, msg);
                    ++var8_15;
                }
                boolean bl = false;
                while (var8_17 < split) {
                    subscribers[var8_17].doDelivery(from, msg);
                    ++var8_17;
                }
                break;
            }
            case 1: {
                ChannelImpl wild = this._wild;
                if (wild != null) {
                    ClientImpl[] subscribers;
                    if (wild._lazy && msg instanceof MessageImpl) {
                        ((MessageImpl)msg).setLazy(true);
                    }
                    for (ClientImpl clientImpl : subscribers = wild._subscribers) {
                        clientImpl.doDelivery(from, msg);
                    }
                }
            }
            default: {
                String string;
                ChannelImpl channel;
                ChannelImpl wildWild = this._wildWild;
                if (wildWild != null) {
                    void var11_38;
                    ClientImpl[] clientImplArray;
                    if (wildWild._lazy && msg instanceof MessageImpl) {
                        ((MessageImpl)msg).setLazy(true);
                    }
                    ClientImpl[] arr$ = clientImplArray = wildWild._subscribers;
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var11_38 < len$) {
                        ClientImpl client = arr$[var11_38];
                        client.doDelivery(from, msg);
                        ++var11_38;
                    }
                }
                if ((channel = this._children.get(string = to.getSegment(this._id.depth()))) == null) break;
                channel.doDelivery(to, from, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Client> getSubscribers() {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            return Arrays.asList((Client[])this._subscribers);
        }
    }

    public int getSubscriberCount() {
        return this._subscribers.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DataFilter> getDataFilters() {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            return Arrays.asList(this._dataFilters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ChannelListener listener) {
        if (listener instanceof SubscriptionListener) {
            ChannelImpl channelImpl = this;
            synchronized (channelImpl) {
                this._subscriptionListeners = (SubscriptionListener[])LazyList.addToArray((Object[])this._subscriptionListeners, (Object)listener, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ChannelListener listener) {
        if (listener instanceof SubscriptionListener) {
            ChannelImpl channelImpl = this;
            synchronized (channelImpl) {
                this._subscriptionListeners = (SubscriptionListener[])LazyList.removeFromArray((Object[])this._subscriptionListeners, (Object)listener);
            }
        }
    }
}

