/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.Map;
import org.cometd.Client;
import org.cometd.Extension;
import org.cometd.Message;
import org.cometd.server.MessageImpl;
import org.cometd.server.ext.ArrayIdQueue;
import org.eclipse.jetty.util.ArrayQueue;

public class AcknowledgedMessagesClientExtension
implements Extension {
    private final Client _client;
    private final ArrayIdQueue<Message> _unackedQueue;

    public AcknowledgedMessagesClientExtension(Client client) {
        this._client = client;
        this._unackedQueue = new ArrayIdQueue(8, 16, client);
        this._unackedQueue.setCurrentId(1);
    }

    public Message rcv(Client from, Message message) {
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message rcvMeta(Client from, Message message) {
        if (message.getChannel().equals("/meta/connect")) {
            Client client = this._client;
            synchronized (client) {
                int s;
                Long acked;
                Map ext = message.getExt(false);
                if (ext != null && (acked = (Long)ext.get("ack")) != null && (s = this._unackedQueue.size()) > 0) {
                    Message q;
                    int i;
                    if (this._unackedQueue.getAssociatedIdUnsafe(s - 1) <= acked) {
                        for (i = 0; i < s; ++i) {
                            q = (Message)this._unackedQueue.getUnsafe(i);
                            if (!(q instanceof MessageImpl)) continue;
                            ((MessageImpl)q).decRef();
                        }
                        this._unackedQueue.clear();
                    } else {
                        for (i = 0; i < s && this._unackedQueue.getAssociatedIdUnsafe(0) <= acked; ++i) {
                            q = (Message)this._unackedQueue.remove();
                            if (!(q instanceof MessageImpl)) continue;
                            ((MessageImpl)q).decRef();
                        }
                    }
                }
                ArrayQueue messages = (ArrayQueue)from.getQueue();
                int cid = this._unackedQueue.getCurrentId();
                int s2 = this._unackedQueue.size();
                for (int i = 0; i < s2 && this._unackedQueue.getAssociatedIdUnsafe(0) < (long)cid; ++i) {
                    messages.add(i, this._unackedQueue.remove());
                }
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message send(Client from, Message message) {
        Client client = this._client;
        synchronized (client) {
            this._unackedQueue.add(message);
            ((MessageImpl)message).incRef();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message sendMeta(Client from, Message message) {
        if (message.getChannel().equals("/meta/connect")) {
            Client client = this._client;
            synchronized (client) {
                Map ext = message.getExt(true);
                ext.put("ack", this._unackedQueue.getCurrentId());
                this._unackedQueue.incrementCurrentId();
            }
        }
        return message;
    }
}

