/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.Channel;
import org.cometd.ChannelBayeuxListener;
import org.cometd.ChannelListener;
import org.cometd.Client;
import org.cometd.DataFilter;
import org.cometd.Message;
import org.cometd.SubscriptionListener;
import org.cometd.server.AbstractBayeux;
import org.cometd.server.ChannelId;
import org.cometd.server.ClientImpl;
import org.cometd.server.MessageImpl;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelImpl
implements Channel {
    protected AbstractBayeux _bayeux;
    private volatile ClientImpl[] _subscribers = new ClientImpl[0];
    private volatile DataFilter[] _dataFilters = new DataFilter[0];
    private volatile SubscriptionListener[] _subscriptionListeners = new SubscriptionListener[0];
    private ChannelId _id;
    private ConcurrentMap<String, ChannelImpl> _children = new ConcurrentHashMap<String, ChannelImpl>();
    private ChannelImpl _wild;
    private ChannelImpl _wildWild;
    private boolean _persistent;
    private int _split;
    private boolean _lazy;

    protected ChannelImpl(String id, AbstractBayeux bayeux) {
        this._id = new ChannelId(id);
        this._bayeux = bayeux;
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(ChannelImpl channel) {
        ChannelId child = channel.getChannelId();
        if (!this._id.isParentOf(child)) {
            throw new IllegalArgumentException(this._id + " not parent of " + child);
        }
        String next = child.getSegment(this._id.depth());
        if (child.depth() - this._id.depth() == 1) {
            ChannelImpl channelImpl = this;
            synchronized (channelImpl) {
                ChannelImpl old = this._children.putIfAbsent(next, channel);
                if (old != null) {
                    throw new IllegalArgumentException("Already Exists");
                }
                if ("*".equals(next)) {
                    this._wild = channel;
                } else if ("**".equals(next)) {
                    this._wildWild = channel;
                }
                this._bayeux.addChannel(channel);
            }
        } else {
            ChannelImpl branch = (ChannelImpl)this._bayeux.getChannel((this._id.depth() == 0 ? "/" : this._id.toString() + "/") + next, true);
            branch.addChild(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataFilter(DataFilter filter) {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this._dataFilters = (DataFilter[])LazyList.addToArray((Object[])this._dataFilters, (Object)filter, null);
        }
    }

    public ChannelId getChannelId() {
        return this._id;
    }

    public ChannelImpl getChild(ChannelId id) {
        String next = id.getSegment(this._id.depth());
        if (next == null) {
            return null;
        }
        ChannelImpl channel = (ChannelImpl)this._children.get(next);
        if (channel == null || channel.getChannelId().depth() == id.depth()) {
            return channel;
        }
        return channel.getChild(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getChannels(List<Channel> list) {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            list.add(this);
            for (ChannelImpl channel : this._children.values()) {
                channel.getChannels(list);
            }
        }
    }

    public int getChannelCount() {
        return this._children.size();
    }

    public String getId() {
        return this._id.toString();
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public void deliver(Client from, Iterable<Client> to, Object data, String id) {
        Message m;
        MessageImpl message = this._bayeux.newMessage();
        message.put("channel", (Object)this.getId());
        message.put("data", data);
        if (id != null) {
            message.put("id", (Object)id);
        }
        if ((m = this._bayeux.extendSendBayeux(from, message)) != null) {
            for (Client t : to) {
                ((ClientImpl)t).doDelivery(from, m);
            }
        }
        if (m instanceof MessageImpl) {
            ((MessageImpl)m).decRef();
        }
    }

    public void publish(Client fromClient, Object data, String msgId) {
        this._bayeux.doPublish(this.getChannelId(), fromClient, data, msgId, false);
    }

    public void publishLazy(Client fromClient, Object data, String msgId) {
        this._bayeux.doPublish(this.getChannelId(), fromClient, data, msgId, true);
    }

    public boolean remove() {
        return this._bayeux.removeChannel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doRemove(ChannelImpl channel, List<ChannelBayeuxListener> listeners) {
        String key;
        ChannelImpl child;
        ChannelId channelId = channel.getChannelId();
        int diff = channel._id.depth() - this._id.depth();
        if (diff >= 1 && (child = (ChannelImpl)this._children.get(key = channelId.getSegment(this._id.depth()))) != null) {
            if (diff == 1) {
                if (!child.isPersistent()) {
                    ChannelImpl channelImpl = this;
                    synchronized (channelImpl) {
                        if (child.getChannelCount() > 0) {
                            for (ChannelImpl c : child._children.values()) {
                                child.doRemove(c, listeners);
                            }
                        }
                        this._children.remove(key);
                    }
                    for (ChannelBayeuxListener l : listeners) {
                        l.channelRemoved((Channel)channel);
                    }
                    return true;
                }
                return false;
            }
            boolean removed = child.doRemove(channel, listeners);
            if (removed && !child.isPersistent() && child.getChannelCount() == 0 && child.getSubscriberCount() == 0) {
                ChannelImpl l = this;
                synchronized (l) {
                    this._children.remove(key);
                }
                for (ChannelBayeuxListener l2 : listeners) {
                    l2.channelRemoved((Channel)channel);
                }
            }
            return removed;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFilter removeDataFilter(DataFilter filter) {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this._dataFilters = (DataFilter[])LazyList.removeFromArray((Object[])this._dataFilters, (Object)filter);
            return filter;
        }
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Client client) {
        if (!(client instanceof ClientImpl)) {
            throw new IllegalArgumentException("Client instance not obtained from Bayeux.newClient()");
        }
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            for (ClientImpl clientImpl : this._subscribers) {
                if (!client.equals(clientImpl)) continue;
                return;
            }
            this._subscribers = (ClientImpl[])LazyList.addToArray((Object[])this._subscribers, (Object)client, null);
            for (ClientImpl clientImpl : this._subscriptionListeners) {
                clientImpl.subscribed(client, this);
            }
        }
        ((ClientImpl)client).addSubscription(this);
    }

    public String toString() {
        return this._id.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Client client) {
        if (!(client instanceof ClientImpl)) {
            throw new IllegalArgumentException("Client instance not obtained from Bayeux.newClient()");
        }
        ((ClientImpl)client).removeSubscription(this);
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this._subscribers = (ClientImpl[])LazyList.removeFromArray((Object[])this._subscribers, (Object)client);
            for (SubscriptionListener l : this._subscriptionListeners) {
                l.unsubscribed(client, (Channel)this);
            }
            if (!this._persistent && this._subscribers.length == 0 && this._children.size() == 0) {
                this.remove();
            }
        }
    }

    protected void doDelivery(ChannelId to, Client from, Message msg) {
        int tail = to.depth() - this._id.depth();
        Object data = msg.getData();
        if (data != null) {
            Object old = data;
            try {
                switch (tail) {
                    case 0: {
                        DataFilter[] filters;
                        for (DataFilter filter : filters = this._dataFilters) {
                            if ((data = filter.filter(from, (Channel)this, data)) != null) continue;
                            return;
                        }
                        break;
                    }
                    case 1: {
                        DataFilter[] filters;
                        if (this._wild != null) {
                            for (DataFilter filter : filters = this._wild._dataFilters) {
                                if ((data = filter.filter(from, (Channel)this, data)) != null) continue;
                                return;
                            }
                        }
                    }
                    default: {
                        DataFilter[] filters;
                        if (this._wildWild != null) {
                            for (DataFilter filter : filters = this._wildWild._dataFilters) {
                                if ((data = filter.filter(from, (Channel)this, data)) != null) continue;
                                return;
                            }
                        }
                    }
                }
            }
            catch (IllegalStateException e) {
                Log.ignore((Throwable)e);
                return;
            }
            if (data != old) {
                msg.put((Object)"data", data);
            }
        }
        switch (tail) {
            case 0: {
                int split;
                int i;
                ClientImpl[] subscribers;
                if (this._lazy && msg instanceof MessageImpl) {
                    ((MessageImpl)msg).setLazy(true);
                }
                if ((subscribers = this._subscribers).length <= 0) break;
                for (i = split = this._split++ % this._subscribers.length; i < subscribers.length; ++i) {
                    subscribers[i].doDelivery(from, msg);
                }
                for (i = 0; i < split; ++i) {
                    subscribers[i].doDelivery(from, msg);
                }
                break;
            }
            case 1: {
                ClientImpl[] subscribers;
                if (this._wild != null) {
                    if (this._wild._lazy && msg instanceof MessageImpl) {
                        ((MessageImpl)msg).setLazy(true);
                    }
                    for (ClientImpl client : subscribers = this._wild._subscribers) {
                        client.doDelivery(from, msg);
                    }
                }
            }
            default: {
                String next;
                ChannelImpl channel;
                ClientImpl[] subscribers;
                if (this._wildWild != null) {
                    if (this._wildWild._lazy && msg instanceof MessageImpl) {
                        ((MessageImpl)msg).setLazy(true);
                    }
                    for (ClientImpl client : subscribers = this._wildWild._subscribers) {
                        client.doDelivery(from, msg);
                    }
                }
                if ((channel = (ChannelImpl)this._children.get(next = to.getSegment(this._id.depth()))) == null) break;
                channel.doDelivery(to, from, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Client> getSubscribers() {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            return Arrays.asList((Client[])this._subscribers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSubscriberCount() {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            return this._subscribers.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DataFilter> getDataFilters() {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            return Arrays.asList(this._dataFilters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ChannelListener listener) {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            if (listener instanceof SubscriptionListener) {
                this._subscriptionListeners = (SubscriptionListener[])LazyList.addToArray((Object[])this._subscriptionListeners, (Object)listener, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ChannelListener listener) {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            if (listener instanceof SubscriptionListener) {
                this._subscriptionListeners = (SubscriptionListener[])LazyList.removeFromArray((Object[])this._subscriptionListeners, (Object)listener);
            }
        }
    }
}

