/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.cometd.Message;
import org.cometd.server.AbstractTransport;
import org.cometd.server.MessageImpl;
import org.eclipse.jetty.util.ajax.JSON;

public class JSONTransport
extends AbstractTransport {
    private int _responses;
    private PrintWriter _out;
    private String _contentType = "text/json; charset=utf-8";
    private String _start = "[";
    private String _end = "]\r\n";

    public synchronized void send(Message message) throws IOException {
        if (message != null) {
            if (message.size() == 0) {
                throw new IllegalStateException();
            }
            String r = message instanceof MessageImpl ? ((MessageImpl)message).getJSON() : JSON.toString((Map)message);
            HttpServletResponse response = this.getResponse();
            switch (this._responses) {
                case 0: {
                    response.setStatus(200);
                    response.setContentType(this._contentType);
                    this._out = response.getWriter();
                    this._out.write(this._start);
                    this._out.write(r);
                    break;
                }
                default: {
                    this._out.write(44);
                    this._out.write(r);
                }
            }
            ++this._responses;
        }
    }

    public synchronized void complete() throws IOException {
        if (this._responses == 0) {
            HttpServletResponse response = this.getResponse();
            response.setStatus(200);
            this._out = response.getWriter();
            this._out.write(this._start);
        }
        this._out.write(this._end);
        this._out.close();
        this._responses = 0;
    }

    public boolean isMetaConnectDeliveryOnly() {
        return false;
    }
}

