/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.cometd.Message;
import org.cometd.server.MessagePool;
import org.eclipse.jetty.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
extends HashMap<String, Object>
implements Message,
JSON.Generator {
    Message _associated;
    ByteBuffer _buffer;
    String _channel;
    String _clientId;
    Object _data;
    Object _ext;
    String _id;
    String _json;
    boolean _lazy = false;
    final MessagePool _pool;
    AtomicInteger _refs = new AtomicInteger();

    public MessageImpl() {
        super(8);
        this._pool = null;
    }

    public MessageImpl(MessagePool bayeux) {
        super(8);
        this._pool = bayeux;
    }

    public void addJSON(StringBuffer buffer) {
        buffer.append(this.getJSON());
    }

    @Override
    public void clear() {
        this.setAssociated(null);
        this._buffer = null;
        this._channel = null;
        this._clientId = null;
        this._data = null;
        this._ext = null;
        this._id = null;
        this._json = null;
        this._lazy = false;
        this._ext = null;
        this._refs.set(0);
        Iterator iterator = super.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            if ("channel".equals(key)) {
                entry.setValue(null);
                continue;
            }
            if ("id".equals(key)) {
                entry.setValue(null);
                continue;
            }
            if ("timestamp".equals(key)) {
                entry.setValue(null);
                continue;
            }
            if ("data".equals(key)) {
                entry.setValue(null);
                continue;
            }
            if ("ext".equals(key)) {
                entry.setValue(null);
                continue;
            }
            iterator.remove();
        }
        super.clear();
    }

    @Override
    public Object clone() {
        MessageImpl msg = new MessageImpl(this._pool);
        if (this._pool != null) {
            msg._refs.incrementAndGet();
        }
        return msg;
    }

    public void decRef() {
        int r = this._refs.decrementAndGet();
        if (r == 0 && this._pool != null) {
            this.setAssociated(null);
            this._pool.recycleMessage(this);
        } else if (r < 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    public Message getAssociated() {
        return this._associated;
    }

    public ByteBuffer getBuffer() {
        return this._buffer;
    }

    public String getChannel() {
        return this._channel;
    }

    public String getClientId() {
        if (this._clientId == null) {
            this._clientId = (String)this.get("clientId");
        }
        return this._clientId;
    }

    public Object getData() {
        return this._data;
    }

    public Map<String, Object> getExt(boolean create) {
        Object ext;
        Object object = ext = this._ext == null ? this.get("ext") : this._ext;
        if (ext instanceof Map) {
            return (Map)ext;
        }
        if (ext instanceof JSON.Literal) {
            JSON json = this._pool == null ? JSON.getDefault() : this._pool.getMsgJSON();
            this._ext = ext = json.fromJSON(ext.toString());
            super.put("ext", ext);
            return (Map)ext;
        }
        if (!create) {
            return null;
        }
        ext = new HashMap();
        this._ext = ext;
        super.put("ext", ext);
        return (Map)ext;
    }

    public String getId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJSON() {
        if (this._json == null) {
            StringBuffer buf;
            JSON json = this._pool == null ? JSON.getDefault() : this._pool.getMsgJSON();
            StringBuffer stringBuffer = buf = new StringBuffer(json.getStringBufferSize());
            synchronized (stringBuffer) {
                json.appendMap(buf, (Map)this);
                this._json = buf.toString();
            }
        }
        return this._json;
    }

    public int getRefs() {
        return this._refs.get();
    }

    public void incRef() {
        this._refs.incrementAndGet();
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isSuccessful() {
        Boolean bool = (Boolean)this.get("successful");
        return bool != null && bool != false;
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Object put(String key, Object value) {
        this._json = null;
        this._buffer = null;
        if ("channel".equals(key)) {
            this._channel = (String)value;
        } else if ("id".equals(key)) {
            this._id = value.toString();
        } else if ("clientId".equals(key)) {
            this._clientId = (String)value;
        } else if ("data".equals(key)) {
            this._data = value;
        } else if ("ext".equals(key)) {
            this._ext = value;
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this._json = null;
        this._buffer = null;
        super.putAll(m);
        this._channel = (String)this.get("channel");
        Object id = this.get("id");
        this._id = id == null ? null : id.toString();
        this._data = this.get("data");
    }

    @Override
    public Object remove(Object key) {
        this._json = null;
        this._buffer = null;
        if ("channel".equals(key)) {
            this._channel = null;
        } else if ("id".equals(key)) {
            this._id = null;
        } else if ("data".equals(key)) {
            this._data = null;
        } else if ("ext".equals(key)) {
            this._ext = null;
        }
        return super.remove(key);
    }

    public void setAssociated(Message associated) {
        if (this._associated != associated) {
            if (this._associated != null) {
                ((MessageImpl)this._associated).decRef();
            }
            this._associated = associated;
            if (this._associated != null) {
                ((MessageImpl)this._associated).incRef();
            }
        }
    }

    public void setBuffer(ByteBuffer buffer) {
        this._buffer = buffer;
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    @Override
    public String toString() {
        return this.getJSON();
    }
}

