/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.continuation;

import org.cometd.server.ClientImpl;
import org.cometd.server.continuation.ContinuationBayeux;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.util.thread.Timeout;

public class ContinuationClient
extends ClientImpl {
    private long _accessed;
    public transient Timeout.Task _timeout;
    private ContinuationBayeux _bayeux;
    private transient Continuation _continuation;

    protected ContinuationClient(ContinuationBayeux bayeux) {
        super(bayeux);
        this._bayeux = bayeux;
        if (!this.isLocal()) {
            this._timeout = new Timeout.Task(){

                public void expired() {
                    ContinuationClient.this.remove(true);
                }

                public String toString() {
                    return "T-" + ContinuationClient.this.toString();
                }
            };
            this._bayeux.startTimeout(this._timeout, this.getTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContinuation(Continuation continuation) {
        if (continuation == null) {
            ContinuationClient continuationClient = this;
            synchronized (continuationClient) {
                if (this._continuation != null) {
                    this._continuation.resume();
                }
                this._continuation = null;
                if (this._timeout != null) {
                    this._bayeux.startTimeout(this._timeout, this.getTimeout());
                }
            }
        }
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            if (this._continuation != null) {
                this._continuation.resume();
            }
            this._continuation = continuation;
            this._bayeux.cancelTimeout(this._timeout);
        }
    }

    public Continuation getContinuation() {
        return this._continuation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            if (this._continuation != null) {
                this._continuation.resume();
            }
            this._continuation = null;
        }
    }

    public boolean isLocal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access() {
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            this._accessed = this._bayeux.getNow();
            if (this._timeout != null && this._timeout.isScheduled()) {
                this._timeout.reschedule();
            }
        }
    }

    public synchronized long lastAccessed() {
        return this._accessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean wasTimeout) {
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            if (!wasTimeout && this._timeout != null) {
                this._bayeux.cancelTimeout(this._timeout);
            }
            this._timeout = null;
        }
        super.remove(wasTimeout);
    }
}

