/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.continuation;

import javax.servlet.http.HttpServletResponse;
import org.cometd.server.ClientImpl;
import org.cometd.server.continuation.ContinuationBayeux;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

public class ContinuationClient
extends ClientImpl {
    private final ContinuationBayeux _bayeux;
    private final Timeout.Task _intervalTimeoutTask;
    private final Timeout.Task _lazyTimeoutTask;
    private long _accessed;
    private volatile Continuation _continuation;
    private volatile boolean _lazyResuming;

    protected ContinuationClient(ContinuationBayeux bayeux) {
        super(bayeux);
        this._bayeux = bayeux;
        if (this.isLocal()) {
            this._intervalTimeoutTask = null;
            this._lazyTimeoutTask = null;
        } else {
            this._intervalTimeoutTask = new Timeout.Task(){

                public void expired() {
                    ContinuationClient.this.remove(true);
                }

                public String toString() {
                    return "T-" + ContinuationClient.this.toString();
                }
            };
            this._lazyTimeoutTask = new Timeout.Task(){

                public void expired() {
                    ContinuationClient.this._lazyResuming = false;
                    if (ContinuationClient.this.hasMessages()) {
                        ContinuationClient.this.resume();
                    }
                }

                public String toString() {
                    return "L-" + ContinuationClient.this.toString();
                }
            };
            this._bayeux.startTimeout(this._intervalTimeoutTask, this._bayeux.getMaxInterval());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContinuation(Continuation continuation) {
        if (continuation == null) {
            ContinuationClient continuationClient = this;
            synchronized (continuationClient) {
                this._continuation = null;
                if (this._intervalTimeoutTask != null) {
                    this._bayeux.startTimeout(this._intervalTimeoutTask, this._bayeux.getMaxInterval());
                }
            }
        }
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            Continuation oldContinuation = this._continuation;
            this._continuation = continuation;
            this._bayeux.cancelTimeout(this._intervalTimeoutTask);
            this._accessed = this._bayeux.getNow();
            if (oldContinuation != null) {
                try {
                    if (oldContinuation.isSuspended()) {
                        ((HttpServletResponse)oldContinuation.getServletResponse()).sendError(408);
                        oldContinuation.complete();
                    }
                }
                catch (Exception e) {
                    Log.debug((Throwable)e);
                }
            }
        }
    }

    public Continuation getContinuation() {
        return this._continuation;
    }

    public void lazyResume() {
        int max = this._bayeux.getMaxLazyLatency();
        if (max > 0 && this._lazyTimeoutTask != null && !this._lazyResuming) {
            this._lazyResuming = true;
            this._bayeux.startTimeout(this._lazyTimeoutTask, this._accessed % (long)max);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            if (this._continuation != null) {
                this._continuation.resume();
            }
            this._continuation = null;
        }
    }

    public boolean isLocal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access() {
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            this._accessed = this._bayeux.getNow();
            if (this._intervalTimeoutTask != null && this._intervalTimeoutTask.isScheduled()) {
                this._intervalTimeoutTask.reschedule();
            }
        }
    }

    public synchronized long lastAccessed() {
        return this._accessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean wasTimeout) {
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            if (!wasTimeout && this._intervalTimeoutTask != null) {
                this._bayeux.cancelTimeout(this._intervalTimeoutTask);
            }
        }
        super.remove(wasTimeout);
    }
}

