/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.TimeZone;
import org.cometd.Client;
import org.cometd.Extension;
import org.cometd.Message;
import org.eclipse.jetty.util.DateCache;

public class TimestampExtension
implements Extension {
    private final DateCache _dateCache;

    public TimestampExtension() {
        this._dateCache = new DateCache();
        this._dateCache.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public TimestampExtension(String format) {
        this._dateCache = new DateCache(format);
        this._dateCache.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public TimestampExtension(String format, TimeZone tz) {
        this._dateCache = new DateCache(format);
        this._dateCache.setTimeZone(tz);
    }

    public Message rcv(Client from, Message message) {
        return message;
    }

    public Message rcvMeta(Client from, Message message) {
        return message;
    }

    public Message send(Client from, Message message) {
        message.put((Object)"timestamp", (Object)this._dateCache.format(System.currentTimeMillis()));
        return message;
    }

    public Message sendMeta(Client from, Message message) {
        message.put((Object)"timestamp", (Object)this._dateCache.format(System.currentTimeMillis()));
        return message;
    }
}

