/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.cometd.Bayeux;
import org.cometd.BayeuxListener;
import org.cometd.Channel;
import org.cometd.ChannelBayeuxListener;
import org.cometd.Client;
import org.cometd.ClientBayeuxListener;
import org.cometd.ConfigurableChannel;
import org.cometd.Extension;
import org.cometd.Message;
import org.cometd.SecurityPolicy;
import org.cometd.server.AbstractTransport;
import org.cometd.server.ChannelId;
import org.cometd.server.ChannelImpl;
import org.cometd.server.ClientImpl;
import org.cometd.server.JSONPTransport;
import org.cometd.server.JSONTransport;
import org.cometd.server.MessageImpl;
import org.cometd.server.MessagePool;
import org.cometd.server.Transport;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBayeux
extends MessagePool
implements Bayeux {
    public static final Logger logger = Log.getLogger((String)Bayeux.class.getName());
    public static final ChannelId META_ID = new ChannelId("/meta");
    public static final ChannelId META_CONNECT_ID = new ChannelId("/meta/connect");
    public static final ChannelId META_CLIENT_ID = new ChannelId("/meta/client");
    public static final ChannelId META_DISCONNECT_ID = new ChannelId("/meta/disconnect");
    public static final ChannelId META_HANDSHAKE_ID = new ChannelId("/meta/handshake");
    public static final ChannelId META_PING_ID = new ChannelId("/meta/ping");
    public static final ChannelId META_STATUS_ID = new ChannelId("/meta/status");
    public static final ChannelId META_SUBSCRIBE_ID = new ChannelId("/meta/subscribe");
    public static final ChannelId META_UNSUBSCRIBE_ID = new ChannelId("/meta/unsubscribe");
    private final HashMap<String, Handler> _handlers = new HashMap();
    private final ChannelImpl _root = new ChannelImpl("/", this);
    private final ConcurrentHashMap<String, ClientImpl> _clients = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, ChannelId> _channelIdCache = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, List<String>> _browser2client = new ConcurrentHashMap();
    protected final ThreadLocal<HttpServletRequest> _request = new ThreadLocal();
    protected final List<ClientBayeuxListener> _clientListeners = new CopyOnWriteArrayList<ClientBayeuxListener>();
    protected final List<ChannelBayeuxListener> _channelListeners = new CopyOnWriteArrayList<ChannelBayeuxListener>();
    private final List<ConfigurableChannel.Initializer> _initialChannelListeners = new CopyOnWriteArrayList<ConfigurableChannel.Initializer>();
    protected final Handler _publishHandler;
    protected final Handler _metaPublishHandler;
    protected SecurityPolicy _securityPolicy = new DefaultPolicy();
    protected JSON.Literal _advice;
    protected JSON.Literal _multiFrameAdvice;
    protected int _adviceVersion = 0;
    protected Object _handshakeAdvice = new JSON.Literal("{\"reconnect\":\"handshake\",\"interval\":500}");
    protected int _logLevel;
    protected long _timeout = 30000L;
    protected long _interval = 0L;
    protected long _maxInterval = 10000L;
    protected boolean _initialized;
    protected int _multiFrameInterval = -1;
    private int _channelIdCacheLimit = 0;
    protected boolean _requestAvailable;
    private ServletContext _context;
    protected Random _random;
    protected int _maxClientQueue = -1;
    protected Extension[] _extensions;
    protected JSON.Literal _transports = new JSON.Literal("[\"long-polling\",\"callback-polling\"]");
    protected int _maxLazyLatency = 5000;

    protected AbstractBayeux() {
        this._publishHandler = new PublishHandler();
        this._metaPublishHandler = new MetaPublishHandler();
        this._handlers.put("/meta/handshake", new HandshakeHandler());
        this._handlers.put("/meta/connect", new ConnectHandler());
        this._handlers.put("/meta/disconnect", new DisconnectHandler());
        this._handlers.put("/meta/subscribe", new SubscribeHandler());
        this._handlers.put("/meta/unsubscribe", new UnsubscribeHandler());
        this._handlers.put("/meta/ping", new PingHandler());
        this.setTimeout(this.getTimeout());
    }

    public void addExtension(Extension ext) {
        this._extensions = (Extension[])LazyList.addToArray((Object[])this._extensions, (Object)ext, Extension.class);
    }

    public void removeExtension(Extension ext) {
        this._extensions = (Extension[])LazyList.removeFromArray((Object[])this._extensions, (Object)ext);
    }

    public ChannelImpl getChannel(ChannelId id) {
        return this._root.getChild(id);
    }

    public ChannelImpl getChannel(String id) {
        ChannelId cid = this.getChannelId(id);
        if (cid.depth() == 0) {
            return null;
        }
        return this._root.getChild(cid);
    }

    public Channel getChannel(String id, boolean create) {
        ChannelImpl channel = this.getChannel(id);
        if (channel == null && create) {
            channel = new ChannelImpl(id, this);
            ChannelImpl added = this._root.addChild(channel);
            if (added != channel) {
                return added;
            }
            if (this.isLogInfo()) {
                this.logInfo("newChannel: " + channel);
            }
        }
        return channel;
    }

    public ChannelId getChannelId(String id) {
        if (this._channelIdCacheLimit < 0) {
            return new ChannelId(id);
        }
        ChannelId cid = this._channelIdCache.get(id);
        if (cid == null) {
            ChannelId other;
            cid = new ChannelId(id);
            if (this._channelIdCacheLimit > 0 && this._channelIdCache.size() > this._channelIdCacheLimit) {
                this._channelIdCache.clear();
            }
            if ((other = this._channelIdCache.putIfAbsent(id, cid)) != null) {
                return other;
            }
        }
        return cid;
    }

    public Client getClient(String client_id) {
        if (client_id == null) {
            return null;
        }
        return this._clients.get(client_id);
    }

    public Set<String> getClientIDs() {
        return this._clients.keySet();
    }

    public long getMaxInterval() {
        return this._maxInterval;
    }

    public int getLogLevel() {
        return this._logLevel;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this._securityPolicy;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public long getInterval() {
        return this._interval;
    }

    public boolean isDirectDeliver() {
        return false;
    }

    public void setDirectDeliver(boolean directDeliver) {
        this._context.log("directDeliver is deprecated");
    }

    public String handle(ClientImpl client, Transport transport, Message message) throws IOException {
        String channel_id = message.getChannel();
        if (channel_id == null) {
            throw new IllegalArgumentException("Message without channel: " + message);
        }
        Handler handler = this._handlers.get(channel_id);
        if (handler != null) {
            message = this.extendRcvMeta(client, message);
            handler.handle(client, transport, message);
            this._metaPublishHandler.handle(client, transport, message);
        } else if (channel_id.startsWith("/meta/")) {
            message = this.extendRcvMeta(client, message);
            this._metaPublishHandler.handle(client, transport, message);
        } else {
            handler = this._publishHandler;
            message = this.extendRcv(client, message);
            handler.handle(client, transport, message);
        }
        return channel_id;
    }

    public boolean hasChannel(String id) {
        ChannelId cid = this.getChannelId(id);
        return this._root.getChild(cid) != null;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public boolean isJSONCommented() {
        return false;
    }

    public boolean isLogDebug() {
        return this._logLevel > 1;
    }

    public boolean isLogInfo() {
        return this._logLevel > 0;
    }

    public void logDebug(String message) {
        if (this._logLevel > 1) {
            this._context.log(message);
        }
    }

    public void logDebug(String message, Throwable th) {
        if (this._logLevel > 1) {
            this._context.log(message, th);
        }
    }

    public void logWarn(String message, Throwable th) {
        this._context.log(message + ": " + th.toString());
    }

    public void logWarn(String message) {
        this._context.log(message);
    }

    public void logInfo(String message) {
        if (this._logLevel > 0) {
            this._context.log(message);
        }
    }

    public Client newClient(String idPrefix) {
        ClientImpl client = new ClientImpl(this, idPrefix);
        this.addClient(client, idPrefix);
        return client;
    }

    public abstract ClientImpl newRemoteClient();

    public Transport newTransport(ClientImpl client, Map<?, ?> message) {
        AbstractTransport result;
        String jsonp;
        Object types;
        String type;
        if (this.isLogDebug()) {
            this.logDebug("newTransport: client=" + client + ",message=" + message);
        }
        String string = type = client == null ? null : client.getConnectionType();
        if (type == null) {
            type = (String)message.get("connectionType");
        }
        if (type == null && (types = message.get("supportedConnectionTypes")) != null) {
            List<Object> supportedTypes = types instanceof Object[] ? Arrays.asList((Object[])types) : (types instanceof List ? (List)types : (types instanceof Map ? new ArrayList(((Map)types).values()) : Collections.emptyList()));
            if (supportedTypes.contains("long-polling")) {
                type = "long-polling";
            } else if (supportedTypes.contains("callback-polling")) {
                type = "callback-polling";
            }
        }
        if (type == null) {
            jsonp = (String)message.get("jsonp");
            String string2 = type = jsonp != null ? "callback-polling" : "long-polling";
        }
        if ("callback-polling".equals(type)) {
            jsonp = (String)message.get("jsonp");
            if (jsonp == null) {
                throw new IllegalArgumentException("Missing 'jsonp' field in message " + message + " for transport " + type);
            }
            result = new JSONPTransport(jsonp);
        } else if ("long-polling".equals(type)) {
            result = new JSONTransport();
        } else {
            throw new IllegalArgumentException("Unsupported transport type " + type);
        }
        if (this.isLogDebug()) {
            this.logDebug("newTransport: result=" + result);
        }
        return result;
    }

    protected void doPublish(ChannelId to, Client from, Object data, String msgId, boolean lazy) {
        MessageImpl message = this.newMessage();
        message.put("channel", (Object)to.toString());
        if (msgId == null) {
            long id = message.hashCode() ^ (to == null ? 0 : to.hashCode()) ^ (from == null ? 0 : from.hashCode());
            id = id < 0L ? -id : id;
            message.put("id", (Object)Long.toString(id, 36));
        } else {
            message.put("id", (Object)msgId);
        }
        message.put("data", data);
        message.setLazy(lazy);
        Message m = this.extendSendBayeux(from, message);
        if (m != null) {
            this._root.doDelivery(to, from, m);
        }
        if (m instanceof MessageImpl) {
            ((MessageImpl)m).decRef();
        }
    }

    public boolean removeChannel(ChannelImpl channel) {
        return this._root.doRemove(channel, this._channelListeners);
    }

    protected void initChannel(ConfigurableChannel channel) {
        for (ConfigurableChannel.Initializer listener : this._initialChannelListeners) {
            try {
                listener.configureChannel(channel);
            }
            catch (RuntimeException x) {
                logger.info("Unexpected exception while invoking listener " + listener, (Throwable)x);
            }
        }
    }

    protected void addChannel(ChannelImpl channel) {
        for (ChannelBayeuxListener listener : this._channelListeners) {
            try {
                listener.channelAdded((Channel)channel);
            }
            catch (RuntimeException x) {
                logger.info("Unexpected exception while invoking listener " + listener, (Throwable)x);
            }
        }
    }

    protected String newClientId(long variation, String idPrefix) {
        if (idPrefix == null) {
            return Long.toString(this.getRandom(), 36) + Long.toString(variation, 36);
        }
        return idPrefix + "_" + Long.toString(this.getRandom(), 36);
    }

    protected void addClient(ClientImpl client, String idPrefix) {
        String id;
        ClientImpl other;
        do {
            id = this.newClientId(client.hashCode(), idPrefix);
            client.setId(id);
        } while ((other = this._clients.putIfAbsent(id, client)) != null);
        for (ClientBayeuxListener l : this._clientListeners) {
            l.clientAdded((Client)client);
        }
        if (this.isLogInfo()) {
            this.logInfo("Added client: " + client);
        }
    }

    public Client removeClient(String client_id) {
        if (client_id == null) {
            return null;
        }
        ClientImpl client = this._clients.remove(client_id);
        if (client != null) {
            for (ClientBayeuxListener l : this._clientListeners) {
                l.clientRemoved((Client)client);
            }
            client.unsubscribeAll();
            if (this.isLogInfo()) {
                this.logInfo("Removed client: " + client);
            }
        }
        return client;
    }

    public void setMaxInterval(long ms) {
        this._maxInterval = ms;
    }

    public void setJSONCommented(boolean commented) {
        if (commented) {
            this._context.log("JSONCommented is deprecated");
        }
    }

    public void setLogLevel(int logLevel) {
        this._logLevel = logLevel;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this._securityPolicy = securityPolicy;
    }

    public void setTimeout(long ms) {
        this._timeout = ms;
        this.generateAdvice();
    }

    public void setInterval(long ms) {
        this._interval = ms;
        this.generateAdvice();
    }

    public void setMultiFrameInterval(int multiFrameInterval) {
        this._multiFrameInterval = multiFrameInterval;
        this.generateAdvice();
    }

    public int getMultiFrameInterval() {
        return this._multiFrameInterval;
    }

    public int getChannelIdCacheLimit() {
        return this._channelIdCacheLimit;
    }

    public void setChannelIdCacheLimit(int channelIdCacheLimit) {
        this._channelIdCacheLimit = channelIdCacheLimit;
    }

    void generateAdvice() {
        this.setAdvice(new JSON.Literal("{\"reconnect\":\"retry\",\"interval\":" + this.getInterval() + ",\"timeout\":" + this.getTimeout() + "}"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdvice(JSON.Literal advice) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            ++this._adviceVersion;
            this._advice = advice;
            this._multiFrameAdvice = new JSON.Literal(JSON.toString(this.multiFrameAdvice(advice)));
        }
    }

    private Map<String, Object> multiFrameAdvice(JSON.Literal advice) {
        Map a = (Map)JSON.parse((String)this._advice.toString());
        a.put("multiple-clients", Boolean.TRUE);
        if (this._multiFrameInterval > 0) {
            a.put("reconnect", "retry");
            a.put("interval", this._multiFrameInterval);
        } else {
            a.put("reconnect", "none");
        }
        return a;
    }

    public JSON.Literal getAdvice() {
        return this._advice;
    }

    public boolean isRequestAvailable() {
        return this._requestAvailable;
    }

    public void setRequestAvailable(boolean requestAvailable) {
        this._requestAvailable = requestAvailable;
    }

    public HttpServletRequest getCurrentRequest() {
        return this._request.get();
    }

    void setCurrentRequest(HttpServletRequest request) {
        this._request.set(request);
    }

    public Collection<Channel> getChannels() {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        this._root.getChannels(channels);
        return channels;
    }

    public int getChannelCount() {
        return this.getChannels().size();
    }

    public Collection<Client> getClients() {
        return new ArrayList<Client>(this._clients.values());
    }

    public int getClientCount() {
        return this._clients.size();
    }

    public boolean hasClient(String clientId) {
        if (clientId == null) {
            return false;
        }
        return this._clients.containsKey(clientId);
    }

    public Channel removeChannel(String channelId) {
        ChannelImpl channel = this.getChannel(channelId);
        boolean removed = false;
        if (channel != null) {
            removed = channel.remove();
        }
        if (removed) {
            return channel;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(ServletContext context) {
        AbstractBayeux abstractBayeux = this;
        synchronized (abstractBayeux) {
            this._initialized = true;
            this._context = context;
            try {
                this._random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (Exception e) {
                context.log("Could not get secure random for ID generation", (Throwable)e);
                this._random = new Random();
            }
            this._random.setSeed(this._random.nextLong() ^ (long)this.hashCode() ^ System.nanoTime() ^ Runtime.getRuntime().freeMemory());
            this._root.addChild(new ServiceChannel("/service"));
        }
    }

    long getRandom() {
        long l = this._random.nextLong();
        return l < 0L ? -l : l;
    }

    void clientOnBrowser(String browserId, String clientId) {
        CopyOnWriteArrayList<String> new_clients;
        CopyOnWriteArrayList<String> clients = this._browser2client.get(browserId);
        if (clients == null && (clients = (CopyOnWriteArrayList<String>)this._browser2client.putIfAbsent(browserId, new_clients = new CopyOnWriteArrayList<String>())) == null) {
            clients = new_clients;
        }
        clients.add(clientId);
    }

    void clientOffBrowser(String browserId, String clientId) {
        List<String> clients = this._browser2client.get(browserId);
        if (clients != null) {
            clients.remove(clientId);
            if (clients.isEmpty()) {
                this._browser2client.remove(browserId);
            }
        }
    }

    List<String> clientsOnBrowser(String browserId) {
        return this._browser2client.get(browserId);
    }

    public void addListener(BayeuxListener listener) {
        if (listener instanceof ClientBayeuxListener) {
            this._clientListeners.add((ClientBayeuxListener)listener);
        }
        if (listener instanceof ChannelBayeuxListener) {
            this._channelListeners.add((ChannelBayeuxListener)listener);
        }
        if (listener instanceof ConfigurableChannel.Initializer) {
            this._initialChannelListeners.add((ConfigurableChannel.Initializer)listener);
        }
    }

    public void removeListener(BayeuxListener listener) {
        if (listener instanceof ClientBayeuxListener) {
            this._clientListeners.remove(listener);
        }
        if (listener instanceof ChannelBayeuxListener) {
            this._channelListeners.remove(listener);
        }
        if (listener instanceof ConfigurableChannel.Initializer) {
            this._initialChannelListeners.remove(listener);
        }
    }

    public int getMaxClientQueue() {
        return this._maxClientQueue;
    }

    public void setMaxClientQueue(int size) {
        this._maxClientQueue = size;
    }

    protected Message extendRcv(ClientImpl from, Message message) {
        Extension[] client_exs;
        if (this._extensions != null) {
            int i = this._extensions.length;
            while (message != null && i-- > 0) {
                message = this._extensions[i].rcv((Client)from, message);
            }
        }
        if (from != null && (client_exs = from.getExtensions()) != null) {
            int i = client_exs.length;
            while (message != null && i-- > 0) {
                message = client_exs[i].rcv((Client)from, message);
            }
        }
        return message;
    }

    protected Message extendRcvMeta(ClientImpl from, Message message) {
        Extension[] client_exs;
        if (this._extensions != null) {
            int i = this._extensions.length;
            while (message != null && i-- > 0) {
                message = this._extensions[i].rcvMeta((Client)from, message);
            }
        }
        if (from != null && (client_exs = from.getExtensions()) != null) {
            int i = client_exs.length;
            while (message != null && i-- > 0) {
                message = client_exs[i].rcvMeta((Client)from, message);
            }
        }
        return message;
    }

    protected Message extendSendBayeux(Client from, Message message) {
        if (this._extensions != null) {
            for (int i = 0; message != null && i < this._extensions.length; ++i) {
                message = this._extensions[i].send(from, message);
            }
        }
        return message;
    }

    public Message extendSendClient(Client from, ClientImpl to, Message message) {
        Extension[] client_exs;
        if (to != null && (client_exs = to.getExtensions()) != null) {
            for (int i = 0; message != null && i < client_exs.length; ++i) {
                message = client_exs[i].send(from, message);
            }
        }
        return message;
    }

    public Message extendSendMeta(ClientImpl from, Message message) {
        Extension[] client_exs;
        if (this._extensions != null) {
            for (int i = 0; message != null && i < this._extensions.length; ++i) {
                message = this._extensions[i].sendMeta((Client)from, message);
            }
        }
        if (from != null && (client_exs = from.getExtensions()) != null) {
            for (int i = 0; message != null && i < client_exs.length; ++i) {
                message = client_exs[i].sendMeta((Client)from, message);
            }
        }
        return message;
    }

    public int getMaxLazyLatency() {
        return this._maxLazyLatency;
    }

    public void setMaxLazyLatency(int ms) {
        this._maxLazyLatency = ms;
    }

    protected class ServiceChannel
    extends ChannelImpl {
        ServiceChannel(String id) {
            super(id, AbstractBayeux.this);
            this.setPersistent(true);
        }

        public ChannelImpl addChild(ChannelImpl channel) {
            channel.setPersistent(true);
            return super.addChild(channel);
        }

        public void subscribe(Client client) {
            if (client.isLocal()) {
                super.subscribe(client);
            }
        }
    }

    protected class PingHandler
    extends Handler {
        protected PingHandler() {
        }

        ChannelId getMetaChannelId() {
            return META_PING_ID;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", "/meta/ping");
            reply.put("successful", Boolean.TRUE);
            String id = message.getId();
            if (id != null) {
                reply.put("id", id);
            }
            this.sendMetaReply(client, reply, transport);
        }
    }

    protected class UnsubscribeHandler
    extends Handler {
        protected UnsubscribeHandler() {
        }

        ChannelId getMetaChannelId() {
            return META_UNSUBSCRIBE_ID;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            if (this.isClientUnknown(client)) {
                this.unknownClient(transport, "/meta/unsubscribe");
                return;
            }
            String channel_id = (String)message.get((Object)"subscription");
            ChannelImpl channel = AbstractBayeux.this.getChannel(channel_id);
            if (channel != null) {
                channel.unsubscribe(client);
            }
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", "/meta/unsubscribe");
            reply.put("subscription", channel_id);
            reply.put("successful", Boolean.TRUE);
            String id = message.getId();
            if (id != null) {
                reply.put("id", id);
            }
            this.sendMetaReply(client, reply, transport);
        }
    }

    protected class SubscribeHandler
    extends Handler {
        protected SubscribeHandler() {
        }

        ChannelId getMetaChannelId() {
            return META_SUBSCRIBE_ID;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            if (this.isClientUnknown(client)) {
                this.unknownClient(transport, "/meta/subscribe");
                return;
            }
            String subscribe_id = (String)message.get((Object)"subscription");
            if (subscribe_id == null) {
                subscribe_id = Long.toString(AbstractBayeux.this.getRandom(), 36);
                while (AbstractBayeux.this.getChannel(subscribe_id) != null) {
                    subscribe_id = Long.toString(AbstractBayeux.this.getRandom(), 36);
                }
            }
            ChannelId cid = null;
            boolean can_subscribe = false;
            if (subscribe_id.startsWith("/service/")) {
                can_subscribe = true;
            } else if (subscribe_id.startsWith("/meta/")) {
                can_subscribe = false;
            } else {
                cid = AbstractBayeux.this.getChannelId(subscribe_id);
                can_subscribe = AbstractBayeux.this._securityPolicy.canSubscribe((Client)client, subscribe_id, message);
            }
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", "/meta/subscribe");
            reply.put("subscription", subscribe_id);
            if (can_subscribe) {
                if (cid != null) {
                    ChannelImpl channel = AbstractBayeux.this.getChannel(cid);
                    if (channel == null && AbstractBayeux.this._securityPolicy.canCreate((Client)client, subscribe_id, message)) {
                        channel = (ChannelImpl)AbstractBayeux.this.getChannel(subscribe_id, true);
                    }
                    if (channel != null) {
                        if (this.isClientUnknown(client)) {
                            this.unknownClient(transport, "/meta/subscribe");
                            return;
                        }
                        channel.subscribe(client);
                    } else {
                        can_subscribe = false;
                    }
                }
                if (can_subscribe) {
                    reply.put("successful", Boolean.TRUE);
                } else {
                    reply.put("successful", Boolean.FALSE);
                    reply.put("error", "403::cannot create");
                }
            } else {
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "403::cannot subscribe");
            }
            String id = message.getId();
            if (id != null) {
                reply.put("id", id);
            }
            this.sendMetaReply(client, reply, transport);
        }
    }

    protected class MetaPublishHandler
    extends Handler {
        protected MetaPublishHandler() {
        }

        ChannelId getMetaChannelId() {
            return null;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            String channel_id = message.getChannel();
            if (this.isClientUnknown(client) && !"/meta/handshake".equals(channel_id) && !"/meta/disconnect".equals(channel_id)) {
                return;
            }
            if (AbstractBayeux.this._securityPolicy.canPublish((Client)client, channel_id, message)) {
                AbstractBayeux.this._root.doDelivery(AbstractBayeux.this.getChannelId(channel_id), client, message);
            }
        }
    }

    protected class PublishHandler
    extends Handler {
        protected PublishHandler() {
        }

        ChannelId getMetaChannelId() {
            return null;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            if (message == null) {
                MessageImpl reply = AbstractBayeux.this.newMessage(message);
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "404::Message deleted");
                this.sendMetaReply(client, reply, transport);
                return;
            }
            String channel_id = message.getChannel();
            if (this.isClientUnknown(client) && message.containsKey((Object)"clientId")) {
                this.unknownClient(transport, channel_id);
                return;
            }
            String id = message.getId();
            ChannelId cid = AbstractBayeux.this.getChannelId(channel_id);
            Object data = message.get((Object)"data");
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", channel_id);
            if (id != null) {
                reply.put("id", id);
            }
            if (data == null) {
                message = null;
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "403::No data");
            } else if (!AbstractBayeux.this._securityPolicy.canPublish((Client)client, channel_id, message)) {
                message = null;
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "403::Publish denied");
            } else {
                reply.put("successful", Boolean.TRUE);
            }
            this.sendMetaReply(client, reply, transport);
            if (message != null) {
                AbstractBayeux.this._root.doDelivery(cid, client, message);
            }
        }
    }

    protected class HandshakeHandler
    extends Handler {
        protected HandshakeHandler() {
        }

        ChannelId getMetaChannelId() {
            return META_HANDSHAKE_ID;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            String id;
            if (client != null) {
                throw new IllegalStateException();
            }
            if (AbstractBayeux.this._securityPolicy != null && !AbstractBayeux.this._securityPolicy.canHandshake(message)) {
                MessageImpl reply = AbstractBayeux.this.newMessage(message);
                reply.put("channel", "/meta/handshake");
                reply.put("successful", Boolean.FALSE);
                reply.put("error", "403::Handshake denied");
                this.sendMetaReply(client, reply, transport);
                return;
            }
            client = AbstractBayeux.this.newRemoteClient();
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", "/meta/handshake");
            reply.put("version", "1.0");
            reply.put("minimumVersion", "0.9");
            if (client != null) {
                reply.put("supportedConnectionTypes", AbstractBayeux.this._transports);
                reply.put("successful", Boolean.TRUE);
                reply.put("clientId", client.getId());
                if (AbstractBayeux.this._advice != null) {
                    reply.put("advice", AbstractBayeux.this._advice);
                }
            } else {
                reply.put("successful", Boolean.FALSE);
                if (AbstractBayeux.this._advice != null) {
                    reply.put("advice", AbstractBayeux.this._advice);
                }
            }
            if (AbstractBayeux.this.isLogDebug()) {
                AbstractBayeux.this.logDebug("handshake.handle: reply=" + reply);
            }
            if ((id = message.getId()) != null) {
                reply.put("id", id);
            }
            this.sendMetaReply(client, reply, transport);
        }
    }

    protected class DisconnectHandler
    extends Handler {
        protected DisconnectHandler() {
        }

        ChannelId getMetaChannelId() {
            return META_DISCONNECT_ID;
        }

        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            Message pollReply;
            if (this.isClientUnknown(client)) {
                this.unknownClient(transport, "/meta/disconnect");
                return;
            }
            if (AbstractBayeux.this.isLogInfo()) {
                AbstractBayeux.this.logInfo("Disconnect " + client.getId());
            }
            client.remove(false);
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", "/meta/disconnect");
            reply.put("successful", Boolean.TRUE);
            String id = message.getId();
            if (id != null) {
                reply.put("id", id);
            }
            if ((pollReply = transport.getMetaConnectReply()) != null) {
                transport.setMetaConnectReply(null);
                this.sendMetaReply(client, pollReply, transport);
            }
            this.sendMetaReply(client, reply, transport);
        }
    }

    protected class ConnectHandler
    extends Handler {
        protected String _metaChannel;

        protected ConnectHandler() {
            this._metaChannel = "/meta/connect";
        }

        ChannelId getMetaChannelId() {
            return META_CONNECT_ID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(ClientImpl client, Transport transport, Message message) throws IOException {
            Object clients;
            Object advice;
            if (this.isClientUnknown(client)) {
                this.unknownClient(transport, this._metaChannel);
                return;
            }
            String type = client.getConnectionType();
            boolean polling = true;
            if (type == null) {
                type = (String)message.get((Object)"connectionType");
                client.setConnectionType(type);
                polling = false;
            }
            if ((advice = message.get((Object)"advice")) != null) {
                Long timeout = (Long)((Map)advice).get("timeout");
                if (timeout != null && timeout >= 0L) {
                    client.setTimeout(timeout);
                } else {
                    client.setTimeout(-1L);
                }
                Long interval = (Long)((Map)advice).get("interval");
                if (interval != null && interval >= 0L) {
                    client.setInterval(interval);
                } else {
                    client.setInterval(-1L);
                }
            } else {
                client.setTimeout(-1L);
                client.setInterval(-1L);
            }
            advice = null;
            if (polling && AbstractBayeux.this._multiFrameInterval > 0 && client.getBrowserId() != null && (clients = AbstractBayeux.this.clientsOnBrowser(client.getBrowserId())) != null && clients.size() > 1) {
                polling = ((String)clients.get(0)).equals(client.getId());
                advice = client.getAdvice();
                advice = advice == null ? AbstractBayeux.this._multiFrameAdvice : AbstractBayeux.this.multiFrameAdvice((JSON.Literal)advice);
            }
            clients = this;
            synchronized (clients) {
                if (advice == null) {
                    if (AbstractBayeux.this._adviceVersion != client._adviseVersion) {
                        advice = AbstractBayeux.this._advice;
                        client._adviseVersion = AbstractBayeux.this._adviceVersion;
                    }
                } else {
                    client._adviseVersion = -1;
                }
            }
            String id = message.getId();
            MessageImpl reply = AbstractBayeux.this.newMessage(message);
            reply.put("channel", "/meta/connect");
            reply.put("successful", Boolean.TRUE);
            if (advice != null) {
                reply.put("advice", advice);
            }
            if (id != null) {
                reply.put("id", id);
            }
            if (polling) {
                transport.setMetaConnectReply(reply);
            } else {
                this.sendMetaReply(client, reply, transport);
            }
        }
    }

    protected abstract class Handler {
        protected Handler() {
        }

        abstract void handle(ClientImpl var1, Transport var2, Message var3) throws IOException;

        abstract ChannelId getMetaChannelId();

        protected boolean isClientUnknown(Client client) {
            return client == null || !AbstractBayeux.this.hasClient(client.getId());
        }

        void unknownClient(Transport transport, String channel) throws IOException {
            MessageImpl reply = AbstractBayeux.this.newMessage();
            reply.put("channel", (Object)channel);
            reply.put("successful", (Object)Boolean.FALSE);
            reply.put("error", (Object)"402::Unknown client");
            reply.put("advice", AbstractBayeux.this._handshakeAdvice);
            transport.send(reply);
            reply.decRef();
        }

        void sendMetaReply(ClientImpl client, Message reply, Transport transport) throws IOException {
            if ((reply = AbstractBayeux.this.extendSendMeta(client, reply)) != null) {
                transport.send(reply);
                if (reply instanceof MessageImpl) {
                    ((MessageImpl)reply).decRef();
                }
            }
        }
    }

    public static class DefaultPolicy
    implements SecurityPolicy {
        public boolean canHandshake(Message message) {
            return true;
        }

        public boolean canCreate(Client client, String channel, Message message) {
            return client != null && !channel.startsWith("/meta/");
        }

        public boolean canSubscribe(Client client, String channel, Message message) {
            if (client != null && ("/**".equals(channel) || "/*".equals(channel))) {
                return false;
            }
            return client != null && !channel.startsWith("/meta/");
        }

        public boolean canPublish(Client client, String channel, Message message) {
            return client != null || "/meta/handshake".equals(channel);
        }
    }
}

