/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.Map;
import org.cometd.Client;
import org.cometd.Extension;
import org.cometd.Message;
import org.cometd.server.ClientImpl;
import org.eclipse.jetty.util.ajax.JSON;

public class TimesyncExtension
implements Extension {
    private int _accuracyTarget = 25;

    public int getAccuracyTarget() {
        return this._accuracyTarget;
    }

    public void setAccuracyTarget(int target) {
        this._accuracyTarget = target;
    }

    public Message rcv(Client from, Message message) {
        return message;
    }

    public Message rcvMeta(Client from, Message message) {
        Map sync;
        Map ext = message.getExt(false);
        if (ext != null && (sync = (Map)ext.get("timesync")) != null) {
            sync.put("ts", System.currentTimeMillis());
            Number lag = (Number)sync.get("l");
            if (lag != null && from instanceof ClientImpl) {
                ((ClientImpl)from).setLag(lag.intValue());
            }
        }
        return message;
    }

    public Message send(Client from, Message message) {
        return message;
    }

    public Message sendMeta(Client from, Message message) {
        Map sync;
        Map extIn;
        Message associated = message.getAssociated();
        if (associated != null && (extIn = associated.getExt(false)) != null && (sync = (Map)extIn.get("timesync")) != null) {
            long tc = ((Number)sync.get("tc")).longValue();
            long ts = ((Number)sync.get("ts")).longValue();
            StringBuilder buffer = new StringBuilder(80);
            Number lag = (Number)sync.get("l");
            if (lag == null) {
                Map extOut = message.getExt(true);
                buffer.append("{\"tc\":").append(tc).append(",\"ts\":").append(ts).append(",\"p\":").append(System.currentTimeMillis() - ts).append("}");
                extOut.put("timesync", new JSON.Literal(buffer.toString()));
            } else {
                int l = lag.intValue();
                Number offset = (Number)sync.get("o");
                int o = offset == null ? 0 : offset.intValue();
                int a = (int)(tc + (long)o + (long)l - ts);
                if (l == 0 || a >= this._accuracyTarget || a <= -this._accuracyTarget) {
                    Map extOut = message.getExt(true);
                    buffer.append("{\"tc\":").append(tc).append(",\"ts\":").append(ts).append(",\"p\":").append(System.currentTimeMillis() - ts).append(",\"a\":").append(a).append("}");
                    extOut.put("timesync", new JSON.Literal(buffer.toString()));
                }
            }
        }
        return message;
    }
}

