/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.filter;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.cometd.Channel;
import org.cometd.Client;
import org.cometd.DataFilter;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;

public class JSONDataFilter
implements DataFilter {
    public void init(Object init) {
    }

    public Object filter(Client from, Channel to, Object data) throws IllegalStateException {
        if (data == null) {
            return null;
        }
        if (data instanceof Map) {
            return this.filterMap(from, to, (Map)data);
        }
        if (data instanceof List) {
            return this.filterArray(from, to, ((List)data).toArray());
        }
        if (data instanceof Collection) {
            return this.filterArray(from, to, ((Collection)data).toArray());
        }
        if (data.getClass().isArray()) {
            return this.filterArray(from, to, data);
        }
        if (data instanceof Number) {
            return this.filterNumber((Number)data);
        }
        if (data instanceof Boolean) {
            return this.filterBoolean((Boolean)data);
        }
        if (data instanceof String) {
            return this.filterString((String)data);
        }
        if (data instanceof JSON.Literal) {
            return this.filterJSON(from, to, (JSON.Literal)data);
        }
        if (data instanceof JSON.Generator) {
            return this.filterJSON(from, to, (JSON.Generator)data);
        }
        return this.filterObject(from, to, data);
    }

    protected Object filterString(String string) {
        return string;
    }

    protected Object filterBoolean(Boolean bool) {
        return bool;
    }

    protected Object filterNumber(Number number) {
        return number;
    }

    protected Object filterArray(Client from, Channel to, Object array) {
        if (array == null) {
            return null;
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.filter(from, to, Array.get(array, i)));
        }
        return array;
    }

    protected Object filterMap(Client from, Channel to, Map object) {
        if (object == null) {
            return null;
        }
        for (Map.Entry entry : object.entrySet()) {
            entry.setValue(this.filter(from, to, entry.getValue()));
        }
        return object;
    }

    protected Object filterJSON(Client from, Channel to, JSON.Generator generator) {
        String json = JSON.toString((Object)generator);
        Object data = JSON.parse((String)json);
        return this.filter(from, to, data);
    }

    protected Object filterJSON(Client from, Channel to, JSON.Literal json) {
        Object data = JSON.parse((String)json.toString());
        return this.filter(from, to, data);
    }

    protected Object filterObject(Client from, Channel to, Object obj) {
        Log.warn((String)(this + ": Cannot Filter " + obj.getClass()));
        return obj;
    }
}

