/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.TimeZone;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.eclipse.jetty.util.DateCache;

public class TimestampExtension
implements BayeuxServer.Extension {
    private final DateCache _dateCache;

    public TimestampExtension() {
        this._dateCache = new DateCache();
        this._dateCache.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public TimestampExtension(String format) {
        this._dateCache = new DateCache(format);
        this._dateCache.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public TimestampExtension(String format, TimeZone tz) {
        this._dateCache = new DateCache(format);
        this._dateCache.setTimeZone(tz);
    }

    public boolean rcv(ServerSession from, ServerMessage.Mutable message) {
        return true;
    }

    public boolean rcvMeta(ServerSession from, ServerMessage.Mutable message) {
        return true;
    }

    public boolean send(ServerMessage.Mutable message) {
        message.put((Object)"timestamp", (Object)this._dateCache.format(System.currentTimeMillis()));
        return true;
    }

    public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
        message.put((Object)"timestamp", (Object)this._dateCache.format(System.currentTimeMillis()));
        return true;
    }
}

