/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.Transport;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.HttpTransport;

public class CometdServlet
extends GenericServlet {
    private static final long serialVersionUID = 3637310585741732936L;
    public static final int CONFIG_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int DEBUG_LEVEL = 3;
    public static final String CLIENT_ATTR = "org.cometd.server.client";
    public static final String TRANSPORT_ATTR = "org.cometd.server.transport";
    public static final String MESSAGE_PARAM = "message";
    public static final String TUNNEL_INIT_PARAM = "tunnelInit";
    public static final String HTTP_CLIENT_ID = "BAYEUX_HTTP_CLIENT";
    private BayeuxServerImpl _bayeux;
    private final ThreadLocal<HttpServletRequest> _currentRequest = new ThreadLocal();
    private String _transportParameter;
    private int _logLevel;
    private HttpTransport[] _transports;

    public BayeuxServerImpl getBayeux() {
        if (this._bayeux == null) {
            this._bayeux = new BayeuxServerImpl();
            this.initializeBayeux(this._bayeux);
        }
        return this._bayeux;
    }

    protected void initializeBayeux(BayeuxServerImpl bayeux) {
        bayeux.initializeDefaultTransports();
    }

    public void init() throws ServletException {
        Transport transport;
        this._bayeux = (BayeuxServerImpl)((Object)this.getServletContext().getAttribute("org.cometd.bayeux"));
        if (this._bayeux == null) {
            this.getServletContext().setAttribute("org.cometd.bayeux", (Object)this.getBayeux());
        }
        if (this.getInitParameter("logLevel") != null) {
            this._logLevel = Integer.parseInt(this.getInitParameter("logLevel"));
            if (this._logLevel >= 3) {
                this._bayeux.getLogger().setDebugEnabled(true);
            }
        }
        HashSet<String> qualified_names = new HashSet<String>();
        for (String string : this._bayeux.getKnownTransportNames()) {
            transport = this._bayeux.getTransport(string);
            for (String option : transport.getOptionNames()) {
                qualified_names.add(option);
                String prefix = transport.getOptionPrefix();
                while (prefix != null) {
                    qualified_names.add(prefix + "." + option);
                    int dot = prefix.lastIndexOf(46);
                    prefix = dot < 0 ? null : prefix.substring(0, dot);
                }
            }
        }
        for (String string : qualified_names) {
            String value = this.getInitParameter(string);
            if (value == null) continue;
            this._bayeux.setOption(string, value);
        }
        for (String string : this._bayeux.getKnownTransportNames()) {
            transport = this._bayeux.getTransport(string);
            if (!(transport instanceof AbstractServerTransport)) continue;
            ((AbstractServerTransport)transport).init();
        }
        if (this._logLevel >= 1) {
            for (Map.Entry entry : this._bayeux.getOptions().entrySet()) {
                this._bayeux.getLogger().info((String)entry.getKey() + "=" + entry.getValue(), new Object[0]);
            }
        }
        this._transports = new HttpTransport[this._bayeux.getAllowedTransports().size()];
        int i = 0;
        for (String t : this._bayeux.getAllowedTransports()) {
            Transport transport2 = this._bayeux.getTransport(t);
            this._transports[i++] = transport2 instanceof HttpTransport ? (HttpTransport)transport2 : null;
        }
        try {
            this._bayeux.start();
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        this._currentRequest.set(request);
        try {
            this.service(request, response);
        }
        finally {
            this._currentRequest.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String transport_name;
        HttpTransport transport = null;
        if (this._transportParameter != null && (transport_name = request.getParameter(this._transportParameter)) != null) {
            transport = (HttpTransport)this._bayeux.getTransport(transport_name);
        }
        if (transport == null) {
            for (HttpTransport t : this._transports) {
                if (t == null || !t.accept(request)) continue;
                transport = t;
                break;
            }
        }
        if (transport == null) {
            response.sendError(400, "bad transport");
        } else {
            try {
                this._bayeux.setCurrentTransport(transport);
                transport.setCurrentRequest(request);
                transport.handle(request, response);
            }
            finally {
                this._bayeux.setCurrentTransport(null);
                transport.setCurrentRequest(null);
            }
        }
    }

    public void destroy() {
        for (ServerSessionImpl session : this._bayeux.getSessions()) {
            session.cancelSchedule();
        }
    }
}

