/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.common.ChannelId;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;

public class ServerChannelImpl
implements ServerChannel,
ConfigurableServerChannel {
    private final BayeuxServerImpl _bayeux;
    private final ChannelId _id;
    private final Set<ServerSessionImpl> _subscribers = new CopyOnWriteArraySet<ServerSessionImpl>();
    private final List<ServerChannel.ServerChannelListener> _listeners = new CopyOnWriteArrayList<ServerChannel.ServerChannelListener>();
    private final boolean _meta;
    private final boolean _broadcast;
    private final boolean _service;
    private final CountDownLatch _initialized;
    private boolean _lazy;
    private boolean _persistent;
    private volatile int _used = 0;

    protected ServerChannelImpl(BayeuxServerImpl bayeux, ChannelId id) {
        this._bayeux = bayeux;
        this._id = id;
        this._meta = this._id.isMeta();
        this._service = this._id.isService();
        this._broadcast = !this.isMeta() && !this.isService();
        this._initialized = new CountDownLatch(1);
        this.setPersistent(!this._broadcast);
    }

    void waitForInitialized() {
        try {
            if (!this._initialized.await(5L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Not Initialized: " + this);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Initizlization interrupted: " + this);
        }
    }

    void initialized() {
        this._initialized.countDown();
    }

    protected boolean subscribe(ServerSessionImpl session) {
        if (!session.isHandshook()) {
            return false;
        }
        if (this._subscribers.add(session)) {
            session.subscribedTo(this);
            for (ServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
                if (!(serverChannelListener instanceof ServerChannel.SubscriptionListener)) continue;
                ((ServerChannel.SubscriptionListener)serverChannelListener).subscribed((ServerSession)session, (ServerChannel)this);
            }
            for (BayeuxServer.BayeuxServerListener bayeuxServerListener : this._bayeux.getListeners()) {
                if (!(bayeuxServerListener instanceof BayeuxServer.SubscriptionListener)) continue;
                ((BayeuxServer.SubscriptionListener)bayeuxServerListener).subscribed((ServerSession)session, (ServerChannel)this);
            }
        }
        this._used = 0;
        return true;
    }

    protected void unsubscribe(ServerSessionImpl session) {
        if (this._subscribers.remove(session)) {
            session.unsubscribedTo(this);
            for (ServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
                if (!(serverChannelListener instanceof ServerChannel.SubscriptionListener)) continue;
                ((ServerChannel.SubscriptionListener)serverChannelListener).unsubscribed((ServerSession)session, (ServerChannel)this);
            }
            for (BayeuxServer.BayeuxServerListener bayeuxServerListener : this._bayeux.getListeners()) {
                if (!(bayeuxServerListener instanceof BayeuxServer.SubscriptionListener)) continue;
                ((BayeuxServer.SubscriptionListener)bayeuxServerListener).unsubscribed((ServerSession)session, (ServerChannel)this);
            }
        }
    }

    public List<ServerChannel.ServerChannelListener> getListeners() {
        return this._listeners;
    }

    public Set<? extends ServerSession> getSubscribers() {
        return Collections.unmodifiableSet(this._subscribers);
    }

    public boolean isBroadcast() {
        return this._broadcast;
    }

    public boolean isDeepWild() {
        return this._id.isDeepWild();
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public boolean isWild() {
        return this._id.isWild();
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    public void addListener(ServerChannel.ServerChannelListener listener) {
        this._listeners.add(listener);
    }

    public ChannelId getChannelId() {
        return this._id;
    }

    public String getId() {
        return this._id.toString();
    }

    public boolean isMeta() {
        return this._meta;
    }

    public boolean isService() {
        return this._service;
    }

    public void removeListener(ServerChannel.ServerChannelListener listener) {
        this._listeners.remove(listener);
    }

    public void publish(Session from, ServerMessage msg) {
        if (this.isWild()) {
            throw new IllegalStateException("Wild publish");
        }
        ServerMessage.Mutable mutable = msg.asMutable();
        if (this._bayeux.extendSend((ServerSessionImpl)from, null, mutable)) {
            this._bayeux.doPublish((ServerSessionImpl)from, this, mutable);
        }
    }

    public void publish(Session from, Object data, String id) {
        if (this.isWild()) {
            throw new IllegalStateException("Wild publish");
        }
        ServerMessage.Mutable mutable = this._bayeux.newMessage();
        mutable.setChannel(this.getId());
        if (from != null) {
            mutable.setClientId(from.getId());
        }
        mutable.setData(data);
        mutable.setId(id);
        if (this._bayeux.extendSend((ServerSessionImpl)from, null, mutable)) {
            ServerSessionImpl session = (ServerSessionImpl)(from instanceof LocalSession ? ((LocalSession)from).getServerSession() : (ServerSession)from);
            this._bayeux.doPublish(session, this, mutable);
        }
    }

    protected void doSweep(int children) {
        for (ServerSessionImpl session : this._subscribers) {
            if (session.isHandshook()) continue;
            this.unsubscribe(session);
        }
        if (!this.isPersistent() && this._subscribers.size() == 0 && children == 0 && ++this._used > 2) {
            this.remove();
        }
    }

    public void remove() {
        for (ServerChannelImpl child : this._bayeux.getChannelChildren(this._id)) {
            child.remove();
        }
        if (this._bayeux.removeServerChannel(this)) {
            for (ServerSessionImpl subscriber : this._subscribers) {
                subscriber.unsubscribedTo(this);
            }
            this._subscribers.clear();
        }
    }

    protected void dump(StringBuilder b, String indent) {
        b.append(this.toString());
        b.append(this.isLazy() ? " lazy" : "");
        b.append('\n');
        List<ServerChannelImpl> children = this._bayeux.getChannelChildren(this._id);
        int leaves = children.size() + this._subscribers.size() + this._listeners.size();
        int i = 0;
        for (ServerChannelImpl serverChannelImpl : children) {
            b.append(indent);
            b.append(" +-");
            serverChannelImpl.dump(b, indent + (++i == leaves ? "   " : " | "));
        }
        for (ServerSessionImpl serverSessionImpl : this._subscribers) {
            b.append(indent);
            b.append(" +-");
            serverSessionImpl.dump(b, indent + (++i == leaves ? "   " : " | "));
        }
        for (ServerChannel.ServerChannelListener serverChannelListener : this._listeners) {
            b.append(indent);
            b.append(" +-");
            b.append(serverChannelListener);
            b.append('\n');
        }
    }

    public String toString() {
        return this._id.toString();
    }
}

