/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.text.ParseException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerMessageImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.HttpTransport;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;

public class WebSocketTransport
extends HttpTransport {
    public static final String PREFIX = "ws";
    public static final String NAME = "websocket";
    public static final String PROTOCOL_OPTION = "protocol";
    public static final String BUFFER_SIZE_OPTION = "bufferSize";
    private final WebSocketFactory _factory = new WebSocketFactory();
    private ThreadLocal<Addresses> _addresses = new ThreadLocal();
    private String _protocol = "";

    public WebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
        this.setOption(PROTOCOL_OPTION, this._protocol);
        this.setOption(BUFFER_SIZE_OPTION, this._factory.getBufferSize());
        this.setMetaConnectDeliveryOnly(false);
        this.setOption("metaConnectDeliverOnly", this.isMetaConnectDeliveryOnly());
        this.setTimeout(15000L);
        this.setOption("timeout", this.getTimeout());
        this.setInterval(2500L);
        this.setOption("interval", this.getInterval());
        this.setMaxInterval(15000L);
        this.setOption("maxInterval", this.getMaxInterval());
    }

    @Override
    public void init() {
        this._protocol = this.getOption(PROTOCOL_OPTION, this._protocol);
        this._factory.setBufferSize(this.getOption(BUFFER_SIZE_OPTION, this._factory.getBufferSize()));
    }

    @Override
    public boolean accept(HttpServletRequest request) {
        return "WebSocket".equals(request.getHeader("Upgrade"));
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String protocol = request.getHeader("WebSocket-Protocol");
        String host = request.getHeader("Host");
        String origin = request.getHeader("Origin");
        if ((origin = this.checkOrigin(request, host, origin)) == null || this._protocol != null && this._protocol.length() > 0 && !this._protocol.equals(protocol)) {
            response.sendError(400);
            return;
        }
        if (this.isMetaConnectDeliveryOnly()) {
            Log.warn((String)"MetaConnectDeliveryOnly not implemented for websocket");
            response.sendError(500);
            return;
        }
        Addresses addresses = new Addresses();
        addresses._local = new InetSocketAddress(request.getLocalAddr(), request.getLocalPort());
        addresses._remote = new InetSocketAddress(request.getRemoteAddr(), request.getRemotePort());
        WebSocketScheduler websocket = new WebSocketScheduler(addresses, request.getHeader("User-Agent"));
        this._factory.upgrade(request, response, (WebSocket)websocket, origin, protocol);
    }

    protected String checkOrigin(HttpServletRequest request, String host, String origin) {
        if (origin == null) {
            origin = host;
        }
        return origin;
    }

    @Override
    public InetSocketAddress getCurrentLocalAddress() {
        Addresses addresses = this._addresses.get();
        if (addresses != null) {
            return addresses._local;
        }
        return super.getCurrentLocalAddress();
    }

    @Override
    public InetSocketAddress getCurrentRemoteAddress() {
        Addresses addresses = this._addresses.get();
        if (addresses != null) {
            return addresses._remote;
        }
        return super.getCurrentRemoteAddress();
    }

    private static class Addresses {
        InetSocketAddress _local;
        InetSocketAddress _remote;

        private Addresses() {
        }
    }

    protected class WebSocketScheduler
    implements WebSocket,
    AbstractServerTransport.Scheduler {
        protected final Addresses _addresses;
        protected final String _userAgent;
        protected ServerSessionImpl _session;
        protected WebSocket.Outbound _outbound;
        protected ServerMessage _connectReply;
        protected final Timeout.Task _timeoutTask = new Timeout.Task(){

            public void expired() {
                if (WebSocketScheduler.this._session != null) {
                    WebSocketScheduler.this.schedule();
                }
            }
        };

        public WebSocketScheduler(Addresses addresses, String userAgent) {
            this._addresses = addresses;
            this._userAgent = userAgent;
        }

        public void onConnect(WebSocket.Outbound outbound) {
            this._outbound = outbound;
        }

        public void onDisconnect() {
            if (this._session != null) {
                this._session.cancelIntervalTimeout();
                WebSocketTransport.this.getBayeux().cancelTimeout(this._timeoutTask);
                WebSocketTransport.this.getBayeux().removeServerSession(this._session, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(byte frame, String data) {
            boolean batch = false;
            try {
                ServerMessage.Mutable[] messages;
                WebSocketTransport.this._addresses.set(this._addresses);
                WebSocketTransport.this.getBayeux().setCurrentTransport(WebSocketTransport.this);
                for (ServerMessage.Mutable message : messages = ServerMessageImpl.parseMessages(data)) {
                    boolean connect = "/meta/connect".equals(message.getChannel());
                    String client_id = message.getClientId();
                    if (this._session == null || client_id != null && !client_id.equals(this._session.getId())) {
                        this._session = (ServerSessionImpl)WebSocketTransport.this.getBayeux().getSession(message.getClientId());
                    } else if (!this._session.isHandshook()) {
                        batch = false;
                        this._session = null;
                    }
                    if (!(batch || this._session == null || connect || message.isMeta())) {
                        batch = true;
                        this._session.startBatch();
                    }
                    boolean was_connected = this._session != null && this._session.isConnected();
                    ServerMessage reply = WebSocketTransport.this.getBayeux().handle(this._session, message);
                    if (connect && reply.isSuccessful()) {
                        this._session.setUserAgent(this._userAgent);
                        this._session.setScheduler(this);
                        long timeout = this._session.calculateTimeout(WebSocketTransport.this.getTimeout());
                        if (timeout > 0L && was_connected) {
                            WebSocketTransport.this.getBayeux().startTimeout(this._timeoutTask, timeout);
                            this._connectReply = reply;
                            reply = null;
                        } else if (!was_connected) {
                            this._session.startIntervalTimeout();
                        }
                    }
                    if (reply != null) {
                        reply = WebSocketTransport.this.getBayeux().extendReply(this._session, this._session, reply);
                        if (batch) {
                            this._session.addQueue(reply);
                        } else {
                            this.send(reply);
                        }
                    }
                    message.setAssociated(null);
                }
            }
            catch (IOException e) {
                WebSocketTransport.this.getBayeux().getLogger().warn("", (Throwable)e);
            }
            catch (ParseException e) {
                this.handleJSONParseException(e.getMessage(), e.getCause());
            }
            finally {
                WebSocketTransport.this._addresses.set(null);
                WebSocketTransport.this.getBayeux().setCurrentTransport(null);
                if (batch) {
                    this._session.endBatch();
                }
            }
        }

        protected void handleJSONParseException(String json, Throwable exception) {
            WebSocketTransport.this.getBayeux().getLogger().debug("Error parsing JSON: " + json, exception);
        }

        public void onMessage(byte frame, byte[] data, int offset, int length) {
            try {
                this.onMessage(frame, new String(data, offset, length, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Log.warn((Throwable)e);
            }
        }

        @Override
        public void cancel() {
        }

        @Override
        public void schedule() {
            ServerSessionImpl session = this._session;
            if (session != null) {
                List<ServerMessage> queue = session.takeQueue();
                if (this._connectReply != null) {
                    queue.add(WebSocketTransport.this.getBayeux().extendReply(session, session, this._connectReply));
                    this._connectReply = null;
                    session.startIntervalTimeout();
                }
                try {
                    if (queue.size() > 0) {
                        this.send(queue);
                    }
                }
                catch (IOException e) {
                    WebSocketTransport.this.getBayeux().getLogger().warn("io ", (Throwable)e);
                }
            }
        }

        protected void send(List<ServerMessage> messages) throws IOException {
            String data = JSON.toString(messages);
            this._outbound.sendMessage(data);
        }

        protected void send(ServerMessage message) throws IOException {
            String data = message.getJSON();
            this._outbound.sendMessage("[" + data + "]");
        }
    }
}

