/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.eclipse.jetty.util.ajax.JSON;

public abstract class AbstractServerTransport
implements ServerTransport {
    public static final String TIMEOUT_OPTION = "timeout";
    public static final String INTERVAL_OPTION = "interval";
    public static final String MAX_INTERVAL_OPTION = "maxInterval";
    public static final String MAX_LAZY_OPTION = "maxLazyTimeout";
    public static final String META_CONNECT_DELIVERY_OPTION = "metaConnectDeliverOnly";
    private final BayeuxServerImpl _bayeux;
    private long _interval = 0L;
    private long _maxInterval = 10000L;
    private long _timeout = 10000L;
    private long _maxLazyTimeout = 5000L;
    private boolean _metaConnectDeliveryOnly = false;
    private Object _advice;
    private String _optionPrefix = "";
    private String[] _prefix = new String[0];
    private final String _name;
    private final Map<String, Object> _options;

    protected AbstractServerTransport(BayeuxServerImpl bayeux, String name) {
        this._name = name;
        this._options = bayeux.getOptions();
        this._bayeux = bayeux;
        this.setOption(TIMEOUT_OPTION, this._timeout);
        this.setOption(INTERVAL_OPTION, this._interval);
        this.setOption(MAX_INTERVAL_OPTION, this._maxInterval);
        this.setOption(MAX_LAZY_OPTION, this._maxLazyTimeout);
        this.setOption(META_CONNECT_DELIVERY_OPTION, this._metaConnectDeliveryOnly);
    }

    public Object getAdvice() {
        return this._advice;
    }

    public long getInterval() {
        return this._interval;
    }

    public long getMaxInterval() {
        return this._maxInterval;
    }

    public long getMaxLazyTimeout() {
        return this._maxLazyTimeout;
    }

    public String getName() {
        return this._name;
    }

    public Object getOption(String name) {
        Object value = this._options.get(name);
        String prefix = null;
        for (String segment : this._prefix) {
            String key = (prefix = prefix == null ? segment : prefix + "." + segment) + "." + name;
            if (!this._options.containsKey(key)) continue;
            value = this._options.get(key);
        }
        return value;
    }

    public boolean getOption(String option, boolean dftValue) {
        Object value = this.getOption(option);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public int getOption(String option, int dftValue) {
        Object value = this.getOption(option);
        if (value == null) {
            return -1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    public long getOption(String option, long dftValue) {
        Object value = this.getOption(option);
        if (value == null) {
            return -1L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    public String getOption(String option, String dftValue) {
        Object value = this.getOption(option);
        return value == null ? dftValue : value.toString();
    }

    public Set<String> getOptionNames() {
        HashSet<String> names = new HashSet<String>();
        for (String name : this._options.keySet()) {
            int lastdot = name.lastIndexOf(46);
            if (lastdot >= 0) {
                name = name.substring(lastdot + 1);
            }
            names.add(name);
        }
        return names;
    }

    public String getOptionPrefix() {
        return this._optionPrefix;
    }

    public void setOptionPrefix(String prefix) {
        if (!prefix.startsWith(this._optionPrefix)) {
            throw new IllegalArgumentException(this._optionPrefix + " not prefix of " + prefix);
        }
        this._optionPrefix = prefix;
        this._prefix = prefix.split("\\.");
    }

    public long getTimeout() {
        return this._timeout;
    }

    public boolean isMetaConnectDeliveryOnly() {
        return this._metaConnectDeliveryOnly;
    }

    public void setMetaConnectDeliveryOnly(boolean meta) {
        this._metaConnectDeliveryOnly = meta;
    }

    public void setOption(String name, Object value) {
        if (this._optionPrefix != null && this._optionPrefix.length() > 0) {
            name = this._optionPrefix + "." + name;
        }
        this._options.put(name, value);
    }

    protected void init() {
        this._interval = this.getOption(INTERVAL_OPTION, this._interval);
        this._maxInterval = this.getOption(MAX_INTERVAL_OPTION, this._maxInterval);
        this._timeout = this.getOption(TIMEOUT_OPTION, this._timeout);
        this._maxLazyTimeout = this.getOption(MAX_LAZY_OPTION, this._maxLazyTimeout);
        this._metaConnectDeliveryOnly = this.getOption(META_CONNECT_DELIVERY_OPTION, this._metaConnectDeliveryOnly);
        this._advice = new JSON.Literal("{\"reconnect\":\"retry\",\"interval\":" + this._interval + ",\"timeout\":" + this._timeout + "}");
    }

    public BayeuxServerImpl getBayeux() {
        return this._bayeux;
    }

    public void setInterval(long interval) {
        this._interval = interval;
    }

    public void setMaxInterval(long maxInterval) {
        this._maxInterval = maxInterval;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public void setMaxLazyTimeout(long maxLazyTimeout) {
        this._maxLazyTimeout = maxLazyTimeout;
    }

    public void setAdvice(Object advice) {
        this._advice = advice;
    }

    protected void doSweep() {
    }

    public static interface OneTimeScheduler
    extends Scheduler {
    }

    public static interface Scheduler {
        public void cancel();

        public void schedule();
    }
}

