/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.transport.LongPollingTransport;

public class JSONPTransport
extends LongPollingTransport {
    public static final String PREFIX = "long-polling.jsonp";
    public static final String NAME = "callback-polling";
    public static final String MIME_TYPE_OPTION = "mimeType";
    public static final String CALLBACK_PARAMETER_OPTION = "callbackParameter";
    private String _mimeType = "text/javascript;charset=UTF-8";
    private String _callbackParam = "jsonp";

    public JSONPTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
        this.setOption(CALLBACK_PARAMETER_OPTION, this._callbackParam);
        this.setOption(MIME_TYPE_OPTION, this._mimeType);
        this.setMetaConnectDeliveryOnly(true);
        this.setOption("metaConnectDeliverOnly", this.isMetaConnectDeliveryOnly());
    }

    @Override
    protected boolean isAlwaysFlushingAfterHandle() {
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this._callbackParam = this.getOption(CALLBACK_PARAMETER_OPTION, this._callbackParam);
        this._mimeType = this.getOption(MIME_TYPE_OPTION, this._mimeType);
    }

    @Override
    public boolean accept(HttpServletRequest request) {
        return "GET".equals(request.getMethod()) && request.getParameter(this.getCallbackParameter()) != null;
    }

    public String getCallbackParameter() {
        return this._callbackParam;
    }

    @Override
    protected PrintWriter send(HttpServletRequest request, HttpServletResponse response, PrintWriter writer, ServerMessage message) throws IOException {
        if (writer == null) {
            response.setContentType(this._mimeType);
            String callback = request.getParameter(this._callbackParam);
            writer = response.getWriter();
            writer.append(callback);
            writer.append("([");
        } else {
            writer.append(',');
        }
        writer.append(message.getJSON());
        return writer;
    }

    @Override
    protected void complete(PrintWriter writer) throws IOException {
        writer.append("])\r\n");
        writer.close();
    }
}

