/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.Transport;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.common.ChannelId;
import org.cometd.server.DefaultSecurityPolicy;
import org.cometd.server.LocalSessionImpl;
import org.cometd.server.ServerChannelImpl;
import org.cometd.server.ServerMessagePool;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.ServerTransport;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Timeout;

public class BayeuxServerImpl
extends AbstractLifeCycle
implements BayeuxServer {
    private final Logger _logger;
    private final SecureRandom _random = new SecureRandom();
    private final List<BayeuxServer.BayeuxServerListener> _listeners = new CopyOnWriteArrayList<BayeuxServer.BayeuxServerListener>();
    private final List<BayeuxServer.Extension> _extensions = new CopyOnWriteArrayList<BayeuxServer.Extension>();
    private final ServerMessagePool _pool = new ServerMessagePool();
    private final ServerChannelImpl _root = new ServerChannelImpl(this, null, new ChannelId("/"));
    private final ConcurrentMap<String, ServerSessionImpl> _sessions = new ConcurrentHashMap<String, ServerSessionImpl>();
    private final ConcurrentMap<String, ServerChannelImpl> _channels = new ConcurrentHashMap<String, ServerChannelImpl>();
    private final ConcurrentMap<String, Transport> _transports = new ConcurrentHashMap<String, Transport>();
    private final List<String> _allowedTransports = new CopyOnWriteArrayList<String>();
    private final ThreadLocal<ServerTransport> _currentTransport = new ThreadLocal();
    private final Map<String, Object> _options = new TreeMap<String, Object>();
    private final Timeout _timeout = new Timeout();
    private SecurityPolicy _policy = new DefaultSecurityPolicy();
    private Timer _timer = new Timer();
    private Object _handshakeAdvice = new JSON.Literal("{\"reconnect\":\"handshake\",\"interval\":500}");

    protected BayeuxServerImpl() {
        this.getChannel("/meta/handshake", true).addListener((ServerChannel.ServerChannelListener)new HandshakeHandler());
        this.getChannel("/meta/connect", true).addListener((ServerChannel.ServerChannelListener)new ConnectHandler());
        this.getChannel("/meta/subscribe", true).addListener((ServerChannel.ServerChannelListener)new SubscribeHandler());
        this.getChannel("/meta/unsubscribe", true).addListener((ServerChannel.ServerChannelListener)new UnsubscribeHandler());
        this.getChannel("/meta/disconnect", true).addListener((ServerChannel.ServerChannelListener)new DisconnectHandler());
        this._logger = Log.getLogger((String)("bayeux@" + ((Object)((Object)this)).hashCode()));
        this._logger.info("STARTED: " + this._sessions);
        this.setOption("tickIntervalMs", "97");
        this.setOption("sweepIntervalMs", "9997");
    }

    public Logger getLogger() {
        return this._logger;
    }

    protected void doStart() throws Exception {
        long sweep_interval;
        super.doStart();
        this._timer = new Timer("BayeuxServer@" + ((Object)((Object)this)).hashCode(), true);
        long tick_interval = this.getLongOptions("tickIntervalMs", -1L);
        if (tick_interval > 0L) {
            this._timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    BayeuxServerImpl.this._timeout.tick(System.currentTimeMillis());
                }
            }, tick_interval, tick_interval);
        }
        if ((sweep_interval = this.getLongOptions("sweepIntervalMs", -1L)) > 0L) {
            this._timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    BayeuxServerImpl.this._root.doSweep();
                }
            }, sweep_interval, sweep_interval);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._timer.cancel();
        this._timer = null;
    }

    public void startTimeout(Timeout.Task task, long interval) {
        this._timeout.schedule(task, interval);
    }

    public void cancelTimeout(Timeout.Task task) {
        task.cancel();
    }

    public ChannelId newChannelId(String id) {
        ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(id);
        if (channel != null) {
            return channel.getChannelId();
        }
        return new ChannelId(id);
    }

    public Map<String, Object> getOptions() {
        return this._options;
    }

    public Object getOption(String qualifiedName) {
        return this._options.get(qualifiedName);
    }

    protected long getLongOptions(String name, long dft) {
        Object val = this.getOption(name);
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val != null) {
            return Long.valueOf(val.toString());
        }
        return dft;
    }

    public Set<String> getOptionNames() {
        return this._options.keySet();
    }

    public void setOption(String qualifiedName, Object value) {
        this._options.put(qualifiedName, value);
    }

    public int randomInt() {
        return this._random.nextInt();
    }

    public int randomInt(int n) {
        return this._random.nextInt(n);
    }

    public long randomLong() {
        return this._random.nextLong();
    }

    public ServerChannelImpl root() {
        return this._root;
    }

    public ServerMessagePool getServerMessagePool() {
        return this._pool;
    }

    public void setCurrentTransport(ServerTransport transport) {
        this._currentTransport.set(transport);
    }

    public ServerTransport getCurrentTransport() {
        return this._currentTransport.get();
    }

    public SecurityPolicy getSecurityPolicy() {
        return this._policy;
    }

    public ServerChannel getChannel(String channelId, boolean create) {
        ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(channelId);
        if (channel == null && create) {
            channel = this._root.getChild(new ChannelId(channelId), true);
        }
        return channel;
    }

    public Collection<ServerSessionImpl> getSessions() {
        return Collections.unmodifiableCollection(this._sessions.values());
    }

    public ServerSession getSession(String clientId) {
        if (clientId == null) {
            return null;
        }
        return (ServerSession)this._sessions.get(clientId);
    }

    protected void addServerSession(ServerSessionImpl session) {
        this._sessions.put(session.getId(), session);
        for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
            if (!(listener instanceof BayeuxServer.SessionListener)) continue;
            ((BayeuxServer.SessionListener)listener).sessionAdded((ServerSession)session);
        }
    }

    public boolean removeServerSession(ServerSession session, boolean timedout) {
        ServerSessionImpl removed;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("remove " + session + (timedout ? " timedout" : ""));
        }
        if ((removed = (ServerSessionImpl)this._sessions.remove(session.getId())) == session) {
            for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                if (!(listener instanceof BayeuxServer.SessionListener)) continue;
                ((BayeuxServer.SessionListener)listener).sessionRemoved(session, timedout);
            }
            return ((ServerSessionImpl)session).removed(timedout);
        }
        return false;
    }

    protected ServerSessionImpl newServerSession() {
        return new ServerSessionImpl(this);
    }

    protected ServerSessionImpl newServerSession(LocalSessionImpl local, String idHint) {
        return new ServerSessionImpl(this, local, idHint);
    }

    public LocalSession newLocalSession(String idHint) {
        return new LocalSessionImpl(this, idHint);
    }

    public ServerMessage.Mutable newMessage() {
        return this._pool.getServerMessage();
    }

    public ServerMessage.Mutable newMessage(ServerMessage tocopy) {
        ServerMessage.Mutable mutable = this._pool.getServerMessage();
        for (String key : tocopy.keySet()) {
            mutable.put((Object)key, tocopy.get((Object)key));
        }
        return mutable;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this._policy = securityPolicy;
    }

    public void addExtension(BayeuxServer.Extension extension) {
        this._extensions.add(extension);
    }

    public void addListener(BayeuxServer.BayeuxServerListener listener) {
        if (!(listener instanceof BayeuxServer.BayeuxServerListener)) {
            throw new IllegalArgumentException("!BayeuxServerListener");
        }
        this._listeners.add(listener);
    }

    public ServerChannel getChannel(String channelId) {
        return (ServerChannel)this._channels.get(channelId);
    }

    public void removeListener(BayeuxServer.BayeuxServerListener listener) {
        this._listeners.remove(listener);
    }

    public ServerMessage handle(ServerSessionImpl session, ServerMessage.Mutable message) {
        ServerMessage.Mutable reply = null;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(">  " + message + " " + session);
        }
        if (!this.extendRecv(session, message) || session != null && !session.extendRecv(message)) {
            reply = this.createReply(message);
            reply.setSuccessful(false);
            reply.put((Object)"error", (Object)"404::Message deleted");
        } else {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(">> " + message);
            }
            String channelId = message.getChannel();
            ServerChannel channel = null;
            if (channelId != null && (channel = this.getChannel(channelId, false)) == null && this._policy.canCreate((BayeuxServer)this, (ServerSession)session, channelId, (ServerMessage)message)) {
                channel = this.getChannel(channelId, true);
            }
            if (channel == null) {
                reply = this.createReply(message);
                this.error(reply, channelId == null ? "402::no channel" : "403::Cannot create");
            } else if (channel.isMeta()) {
                this.root().doPublish(session, (ServerChannelImpl)channel, message);
                reply = message.getAssociated().asMutable();
            } else if (this._policy.canPublish((BayeuxServer)this, (ServerSession)session, channel, (ServerMessage)message)) {
                if (session != null && session.isLocalSession() || channel.isService()) {
                    message.setClientId(null);
                    channel.publish((Session)session, (ServerMessage)message);
                } else {
                    ServerMessage.Mutable out = this.newMessage();
                    out.setChannel(message.getChannel());
                    out.setData(message.getData());
                    out.setId(message.getId());
                    out.incRef();
                    channel.publish((Session)session, (ServerMessage)out);
                    out.decRef();
                }
                reply = this.createReply(message);
                reply.setSuccessful(true);
            } else {
                reply = this.createReply(message);
                this.error(reply, session == null ? "402::unknown client" : "403::Cannot publish");
            }
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("<< " + reply);
        }
        return reply;
    }

    public ServerMessage extendReply(ServerSessionImpl session, ServerMessage reply) {
        if (session != null) {
            reply = session.extendSend(reply);
        }
        if (reply != null && !this.extendSend(session, reply.asMutable())) {
            reply = null;
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("<  " + reply);
        }
        return reply;
    }

    protected boolean extendRecv(ServerSessionImpl from, ServerMessage.Mutable message) {
        if (message.isMeta()) {
            for (BayeuxServer.Extension ext : this._extensions) {
                if (ext.rcvMeta((ServerSession)from, message)) continue;
                return false;
            }
        } else {
            for (BayeuxServer.Extension ext : this._extensions) {
                if (ext.rcv((ServerSession)from, message)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean extendSend(ServerSessionImpl to, ServerMessage.Mutable message) {
        if (message.isMeta()) {
            ListIterator<BayeuxServer.Extension> i = this._extensions.listIterator(this._extensions.size());
            while (i.hasPrevious()) {
                if (i.previous().sendMeta((ServerSession)to, message)) continue;
                return false;
            }
        } else {
            ListIterator<BayeuxServer.Extension> i = this._extensions.listIterator(this._extensions.size());
            while (i.hasPrevious()) {
                if (i.previous().send(message)) continue;
                return false;
            }
        }
        return true;
    }

    void addServerChannel(ServerChannelImpl channel) {
        ServerChannelImpl old = this._channels.putIfAbsent(channel.getId(), channel);
        if (old != null) {
            throw new IllegalStateException();
        }
        for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
            if (!(listener instanceof BayeuxServer.ChannelListener)) continue;
            ((BayeuxServer.ChannelListener)listener).channelAdded((ServerChannel)channel);
        }
    }

    boolean removeServerChannel(ServerChannelImpl channel) {
        if (this._channels.remove(channel.getId(), channel)) {
            for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                if (!(listener instanceof BayeuxServer.ChannelListener)) continue;
                ((BayeuxServer.ChannelListener)listener).channelRemoved(channel.getId());
            }
            return true;
        }
        return false;
    }

    List<BayeuxServer.BayeuxServerListener> getListeners() {
        return this._listeners;
    }

    public List<String> getAllowedTransports() {
        return Collections.unmodifiableList(this._allowedTransports);
    }

    public Set<String> getKnownTransportNames() {
        return this._transports.keySet();
    }

    public Transport getTransport(String transport) {
        return (Transport)this._transports.get(transport);
    }

    public void addTransport(Transport transport) {
        this._transports.put(transport.getName(), transport);
    }

    public void setAllowedTransports(String ... allowed) {
        this.setAllowedTransports(Arrays.asList(allowed));
    }

    public void setAllowedTransports(List<String> allowed) {
        this._allowedTransports.clear();
        for (String transport : allowed) {
            if (!this._transports.containsKey(transport)) continue;
            this._allowedTransports.add(transport);
        }
    }

    protected void error(ServerMessage.Mutable reply, String error) {
        reply.put((Object)"error", (Object)error);
        reply.setSuccessful(false);
    }

    protected ServerMessage.Mutable createReply(ServerMessage.Mutable message) {
        ServerMessage.Mutable reply = this.newMessage();
        message.setAssociated((ServerMessage)reply);
        reply.setAssociated((ServerMessage)message);
        reply.setChannel(message.getChannel());
        Object id = message.getId();
        if (id != null) {
            reply.setId(id);
        }
        return reply;
    }

    protected ServerChannelImpl getRootChannel() {
        return this._root;
    }

    public String dump() {
        StringBuilder b = new StringBuilder();
        this._root.dump(b, "");
        return b.toString();
    }

    class DisconnectHandler
    extends HandlerListener {
        DisconnectHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl session, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (session == null) {
                BayeuxServerImpl.this.error(reply, "402::Unknown client");
                return;
            }
            BayeuxServerImpl.this.removeServerSession(session, false);
            session.dispatch();
            reply.setSuccessful(true);
        }
    }

    class UnsubscribeHandler
    extends HandlerListener {
        UnsubscribeHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl from, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (from == null) {
                BayeuxServerImpl.this.error(reply, "402::Unknown client");
                reply.put((Object)"advice", BayeuxServerImpl.this._handshakeAdvice);
                return;
            }
            String subscribe_id = (String)message.get((Object)"subscription");
            reply.put((Object)"subscription", (Object)subscribe_id);
            if (subscribe_id == null) {
                BayeuxServerImpl.this.error(reply, "400::no channel");
            } else {
                reply.put((Object)"subscription", (Object)subscribe_id);
                ServerChannelImpl channel = (ServerChannelImpl)BayeuxServerImpl.this.getChannel(subscribe_id);
                if (channel == null) {
                    BayeuxServerImpl.this.error(reply, "400::no channel");
                } else {
                    if (from.isLocalSession() || !channel.isMeta() && !channel.isService()) {
                        channel.unsubscribe(from);
                    }
                    reply.setSuccessful(true);
                }
            }
        }
    }

    class SubscribeHandler
    extends HandlerListener {
        SubscribeHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl from, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (from == null) {
                BayeuxServerImpl.this.error(reply, "402::Unknown client");
                reply.put((Object)"advice", BayeuxServerImpl.this._handshakeAdvice);
                return;
            }
            String subscribe_id = (String)message.get((Object)"subscription");
            reply.put((Object)"subscription", (Object)subscribe_id);
            if (subscribe_id == null) {
                BayeuxServerImpl.this.error(reply, "403::cannot create");
            } else {
                reply.put((Object)"subscription", (Object)subscribe_id);
                ServerChannelImpl channel = (ServerChannelImpl)BayeuxServerImpl.this.getChannel(subscribe_id);
                if (channel == null && BayeuxServerImpl.this.getSecurityPolicy().canCreate((BayeuxServer)BayeuxServerImpl.this, (ServerSession)from, subscribe_id, (ServerMessage)message)) {
                    channel = (ServerChannelImpl)BayeuxServerImpl.this.getChannel(subscribe_id, true);
                }
                if (channel == null) {
                    BayeuxServerImpl.this.error(reply, "403::cannot create");
                } else if (!BayeuxServerImpl.this.getSecurityPolicy().canSubscribe((BayeuxServer)BayeuxServerImpl.this, (ServerSession)from, (ServerChannel)channel, (ServerMessage)message)) {
                    BayeuxServerImpl.this.error(reply, "403::cannot subscribe");
                } else if (from.isLocalSession() || !channel.isMeta() && !channel.isService()) {
                    if (channel.subscribe(from)) {
                        reply.setSuccessful(true);
                    } else {
                        BayeuxServerImpl.this.error(reply, "403::subscribe failed");
                    }
                } else {
                    reply.setSuccessful(true);
                }
            }
        }
    }

    class ConnectHandler
    extends HandlerListener {
        ConnectHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl session, ServerMessage.Mutable message) {
            Object adviceOut;
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (session == null) {
                BayeuxServerImpl.this.error(reply, "402::Unknown client");
                reply.put((Object)"advice", BayeuxServerImpl.this._handshakeAdvice);
                return;
            }
            session.connect(BayeuxServerImpl.this._timeout.getNow());
            Map adviceIn = message.getAdvice();
            if (adviceIn != null) {
                Long timeout = (Long)adviceIn.get("timeout");
                session.setTimeout(timeout == null ? 0L : timeout);
                Long interval = (Long)adviceIn.get("interval");
                session.setInterval(interval == null ? 0L : interval);
            }
            if ((adviceOut = session.takeAdvice()) != null) {
                reply.put((Object)"advice", adviceOut);
            }
            reply.setSuccessful(true);
        }
    }

    class HandshakeHandler
    extends HandlerListener {
        HandshakeHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl session, ServerMessage.Mutable message) {
            if (session == null) {
                session = BayeuxServerImpl.this.newServerSession();
            }
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (BayeuxServerImpl.this._policy != null && !BayeuxServerImpl.this._policy.canHandshake((BayeuxServer)BayeuxServerImpl.this, (ServerSession)session, (ServerMessage)message)) {
                BayeuxServerImpl.this.error(reply, "403::Handshake denied");
                return;
            }
            session.handshake();
            BayeuxServerImpl.this.addServerSession(session);
            reply.setSuccessful(true);
            reply.put((Object)"clientId", (Object)session.getId());
            reply.put((Object)"version", (Object)"1.0");
            reply.put((Object)"minimumVersion", (Object)"1.0");
            reply.put((Object)"supportedConnectionTypes", BayeuxServerImpl.this.getAllowedTransports());
        }
    }

    abstract class HandlerListener
    implements ServerChannel.ServerChannelListener {
        HandlerListener() {
        }

        public abstract void onMessage(ServerSessionImpl var1, ServerMessage.Mutable var2);
    }
}

