/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.SessionChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.common.AbstractClientSession;
import org.cometd.common.ChannelId;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.eclipse.jetty.util.ajax.JSON;

public class LocalSessionImpl
extends AbstractClientSession
implements LocalSession {
    private static final Object LOCAL_ADVICE = JSON.parse((String)"{\"interval\":-1}");
    private final Queue<ServerMessage.Mutable> _queue = new ConcurrentLinkedQueue<ServerMessage.Mutable>();
    private final BayeuxServerImpl _bayeux;
    private final String _idHint;
    private ServerSessionImpl _session;

    protected LocalSessionImpl(BayeuxServerImpl bayeux, String idHint) {
        this._bayeux = bayeux;
        this._idHint = idHint;
    }

    protected void doDisconnected() {
        this._session = null;
    }

    protected AbstractClientSession.AbstractSessionChannel newChannel(ChannelId channelId) {
        return new LocalChannel(channelId);
    }

    protected ChannelId newChannelId(String channelId) {
        return this._bayeux.newChannelId(channelId);
    }

    protected void sendBatch() {
        int size = this._queue.size();
        while (size-- > 0) {
            ServerMessage.Mutable message = this._queue.poll();
            this.doSend(this._session, message);
            message.decRef();
        }
    }

    public ServerSession getServerSession() {
        if (this._session == null) {
            throw new IllegalStateException("!handshake");
        }
        return this._session;
    }

    public void handshake() {
        this.handshake(null);
    }

    public void handshake(Map<String, Object> template) {
        if (this._session != null) {
            throw new IllegalStateException();
        }
        ServerMessage.Mutable message = this._bayeux.newMessage();
        if (template != null) {
            message.putAll(template);
        }
        message.incRef();
        message.setChannel("/meta/handshake");
        message.setId((Object)this._idGen.incrementAndGet());
        ServerSessionImpl session = new ServerSessionImpl(this._bayeux, this, this._idHint);
        this.doSend(session, message);
        ServerMessage reply = message.getAssociated();
        if (reply != null && reply.isSuccessful()) {
            this._session = session;
            message.clear();
            message.setChannel("/meta/connect");
            message.setClientId(this._session.getId());
            message.put((Object)"advice", LOCAL_ADVICE);
            message.setId((Object)this._idGen.incrementAndGet());
            this.doSend(session, message);
            reply = message.getAssociated();
            if (!reply.isSuccessful()) {
                this._session = null;
            }
        }
        message.setAssociated(null);
        message.decRef();
    }

    public void disconnect() {
        if (this._session != null) {
            ServerMessage.Mutable message = this._bayeux.newMessage();
            message.incRef();
            message.setChannel("/meta/disconnect");
            message.setId((Object)this._idGen.incrementAndGet());
            this.send(this._session, message);
            message.decRef();
            while (this._batch.get() > 0) {
                this.endBatch();
            }
        }
    }

    public String getId() {
        if (this._session == null) {
            throw new IllegalStateException("!handshake");
        }
        return this._session.getId();
    }

    public boolean isConnected() {
        return this._session != null && this._session.isConnected();
    }

    public String toString() {
        return "L:" + (this._session == null ? this._idHint + "?" : this._session.getId());
    }

    protected void send(ServerSessionImpl session, ServerMessage.Mutable message) {
        if (this._batch.get() > 0) {
            message.incRef();
            this._queue.add(message);
        } else {
            this.doSend(session, message);
        }
    }

    protected void doSend(ServerSessionImpl session, ServerMessage.Mutable message) {
        ServerMessage reply;
        if (message.isMeta()) {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.sendMeta((ClientSession)this, (Message.Mutable)message)) continue;
                return;
            }
        } else {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.send((ClientSession)this, (Message.Mutable)message)) continue;
                return;
            }
        }
        if (this._session != null) {
            message.setClientId(this._session.getId());
        }
        if ((reply = this._bayeux.handle(session, message)) != null) {
            this._bayeux.extendReply(session, reply);
            if (reply != null) {
                this.receive((Message)reply, (Message.Mutable)reply.asMutable());
            }
        }
    }

    protected void dump(StringBuilder b, String indent) {
        b.append(this.toString());
        b.append('\n');
        int leaves = this._channels.size();
        int i = 0;
        for (AbstractClientSession.AbstractSessionChannel child : this._channels.values()) {
            b.append(indent);
            b.append(" +-");
            ((LocalChannel)child).dump(b, indent + (++i == leaves ? "   " : " | "));
        }
    }

    protected class LocalChannel
    extends AbstractClientSession.AbstractSessionChannel {
        LocalChannel(ChannelId id) {
            super(id);
        }

        public ClientSession getSession() {
            return LocalSessionImpl.this;
        }

        public void publish(Object data) {
            if (LocalSessionImpl.this._session == null) {
                throw new IllegalStateException("!handshake");
            }
            ServerMessage.Mutable message = LocalSessionImpl.this._bayeux.newMessage();
            message.incRef();
            message.setChannel(this._id.toString());
            message.setData(data);
            LocalSessionImpl.this.send(LocalSessionImpl.this._session, message);
            message.setAssociated(null);
            message.decRef();
        }

        public void publish(Object data, Object id) {
            if (LocalSessionImpl.this._session == null) {
                throw new IllegalStateException("!handshake");
            }
            ServerMessage.Mutable message = LocalSessionImpl.this._bayeux.newMessage();
            message.incRef();
            message.setChannel(this._id.toString());
            message.setData(data);
            if (id != null) {
                message.setId(id);
            }
            LocalSessionImpl.this.send(LocalSessionImpl.this._session, message);
            message.setAssociated(null);
            message.decRef();
        }

        public String toString() {
            return this._id + "@" + LocalSessionImpl.this.toString();
        }

        protected void dump(StringBuilder b, String indent) {
            b.append(this.toString());
            b.append('\n');
            for (SessionChannel.SessionChannelListener child : this._listeners) {
                b.append(indent);
                b.append(" +-");
                b.append(child);
                b.append('\n');
            }
            for (SessionChannel.SessionChannelListener child : this._subscriptions) {
                b.append(indent);
                b.append(" +-");
                b.append(child);
                b.append('\n');
            }
        }

        protected void sendSubscribe() {
            ServerMessage.Mutable message = LocalSessionImpl.this._bayeux.newMessage();
            message.incRef();
            message.setChannel("/meta/subscribe");
            message.put((Object)"subscription", (Object)this._id.toString());
            message.setClientId(LocalSessionImpl.this.getId());
            message.setId((Object)LocalSessionImpl.this._idGen.incrementAndGet());
            LocalSessionImpl.this.send(LocalSessionImpl.this._session, message);
            message.setAssociated(null);
            message.decRef();
        }

        protected void sendUnSubscribe() {
            ServerMessage.Mutable message = LocalSessionImpl.this._bayeux.newMessage();
            message.incRef();
            message.setChannel("/meta/unsubscribe");
            message.put((Object)"subscription", (Object)this._id.toString());
            message.setId((Object)LocalSessionImpl.this._idGen.incrementAndGet());
            LocalSessionImpl.this.send(LocalSessionImpl.this._session, message);
            message.setAssociated(null);
            message.decRef();
        }
    }
}

