/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.common.ChannelId;
import org.cometd.server.ServerMessagePool;
import org.cometd.util.ImmutableHashMap;
import org.eclipse.jetty.util.ajax.JSON;

public class ServerMessageImpl
extends AbstractMap<String, Object>
implements ServerMessage,
JSON.Generator {
    private final ImmutableHashMap<String, Object> _immutable = new NestedMap(8);
    private final MutableMessage _mutable;
    private final Map.Entry<String, Object> _adviceImmutable;
    private final Map.Entry<String, Object> _dataImmutable;
    private final Map.Entry<String, Object> _extImmitable;
    private ServerMessage _associated;
    private String _jsonString;
    private boolean _lazy = false;
    private final ServerMessagePool _pool;
    private final AtomicInteger _refs = new AtomicInteger();

    public ServerMessageImpl() {
        this(null);
    }

    public ServerMessageImpl(ServerMessagePool bayeux) {
        this._pool = bayeux;
        this._mutable = new MutableMessage();
        this._adviceImmutable = this._immutable.getEntry((Object)"advice");
        this._dataImmutable = this._immutable.getEntry((Object)"data");
        this._extImmitable = this._immutable.getEntry((Object)"ext");
    }

    public ServerMessage.Mutable asMutable() {
        return this._mutable;
    }

    public void addJSON(StringBuffer buffer) {
        buffer.append(this.getJSON());
    }

    @Override
    public boolean containsKey(Object key) {
        return this._immutable.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._immutable.containsValue(value);
    }

    public void decRef() {
        int r = this._refs.decrementAndGet();
        if (r == 0 && this._pool != null) {
            this._pool.recycleMessage(this);
        } else if (r < 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this._immutable.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this._immutable.get(key);
    }

    public Map<String, Object> getAdvice() {
        Object advice = this._mutable._advice.getValue();
        if (advice instanceof JSON.Literal) {
            return (Map)JSON.parse((String)advice.toString());
        }
        return (Map)advice;
    }

    public ServerMessage getAssociated() {
        return this._associated;
    }

    public String getChannel() {
        return (String)this._mutable._channelId.getValue();
    }

    public String getClientId() {
        return (String)this._mutable._clientId.getValue();
    }

    public Object getData() {
        return this._dataImmutable.getValue();
    }

    public Map<String, Object> getDataAsMap() {
        return (Map)this._dataImmutable.getValue();
    }

    public Map<String, Object> getExt() {
        return (Map)this._extImmitable.getValue();
    }

    public Object getId() {
        return this._mutable._id.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJSON() {
        if (this._jsonString == null) {
            StringBuffer buf;
            JSON json = this._pool == null ? JSON.getDefault() : this._pool.getMsgJSON();
            StringBuffer stringBuffer = buf = new StringBuffer(json.getStringBufferSize());
            synchronized (stringBuffer) {
                json.appendMap(buf, (Map)this);
                this._jsonString = buf.toString();
            }
        }
        return this._jsonString;
    }

    public int getRefs() {
        return this._refs.get();
    }

    public void incRef() {
        this._refs.incrementAndGet();
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isMeta() {
        return ChannelId.isMeta((String)((String)this._mutable._channelId.getValue()));
    }

    public boolean isSuccessful() {
        Boolean bool = (Boolean)this.get("successful");
        return bool != null && bool != false;
    }

    public void setAssociated(ServerMessage associated) {
        if (this._associated != associated) {
            if (this._associated != null) {
                this._associated.decRef();
            }
            this._associated = associated;
            if (this._associated != null) {
                this._associated.incRef();
            }
        }
    }

    public void setData(Object data) {
        this._dataImmutable.setValue(data);
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    @Override
    public int size() {
        return this._immutable.size();
    }

    @Override
    public String toString() {
        return "|" + this.getJSON() + "|";
    }

    class NestedMap
    extends ImmutableHashMap<String, Object> {
        protected NestedMap() {
        }

        protected NestedMap(int size) {
            super(size);
        }

        protected void onChange(String key) throws UnsupportedOperationException {
            ServerMessageImpl.this._jsonString = null;
        }
    }

    class MutableMessage
    extends AbstractMap<String, Object>
    implements ServerMessage.Mutable {
        private final ImmutableHashMap.Mutable _mutable;
        private final Map.Entry<String, Object> _advice;
        private final Map.Entry<String, Object> _channelId;
        private final Map.Entry<String, Object> _clientId;
        private final Map.Entry<String, Object> _data;
        private final Map.Entry<String, Object> _ext;
        private final Map.Entry<String, Object> _id;

        MutableMessage() {
            this._mutable = ServerMessageImpl.this._immutable.asMutable();
            this._mutable.put((Object)"advice", null);
            this._mutable.put((Object)"channel", null);
            this._mutable.put((Object)"clientId", null);
            this._mutable.put((Object)"data", null);
            this._mutable.put((Object)"ext", null);
            this._mutable.put((Object)"id", null);
            this._advice = this._mutable.getEntry((Object)"advice");
            this._channelId = this._mutable.getEntry((Object)"channel");
            this._clientId = this._mutable.getEntry((Object)"clientId");
            this._data = this._mutable.getEntry((Object)"data");
            this._ext = this._mutable.getEntry((Object)"ext");
            this._id = this._mutable.getEntry((Object)"id");
        }

        public ServerMessage.Mutable asMutable() {
            return this;
        }

        public ServerMessageImpl asImmutable() {
            return ServerMessageImpl.this;
        }

        @Override
        public void clear() {
            this.setAssociated(null);
            ServerMessageImpl.this._jsonString = null;
            ServerMessageImpl.this._lazy = false;
            super.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this._mutable.containsKey(key);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this._mutable.entrySet();
        }

        @Override
        public Object get(Object key) {
            return this._mutable.get(key);
        }

        public Map<String, Object> getAdvice() {
            Object advice = this._advice.getValue();
            if (advice instanceof JSON.Literal) {
                advice = JSON.parse((String)advice.toString());
                this._advice.setValue(advice);
            }
            return (Map)advice;
        }

        public Map<String, Object> getDataAsMap() {
            Map data = (Map)this._data.getValue();
            return data;
        }

        public Map<String, Object> getDataAsMap(boolean create) {
            Map data = (Map)this._data.getValue();
            if (create && data == null) {
                data = new NestedMap(16).asMutable();
                this._data.setValue(data);
            }
            return data;
        }

        public Map<String, Object> getAdvice(boolean create) {
            Object advice = this._advice.getValue();
            if (advice instanceof JSON.Literal) {
                advice = JSON.parse((String)advice.toString());
                this._advice.setValue(advice);
            }
            if (create && advice == null) {
                advice = new NestedMap(16).asMutable();
                this._advice.setValue(advice);
            }
            return (Map)advice;
        }

        public String getChannel() {
            return (String)this._channelId.getValue();
        }

        public String getClientId() {
            return (String)this._clientId.getValue();
        }

        public Object getData() {
            return this._data.getValue();
        }

        public Map.Entry<String, Object> getEntry(String key) {
            return this._mutable.getEntry((Object)key);
        }

        public Map<String, Object> getExt() {
            return (Map)this._ext.getValue();
        }

        public Map<String, Object> getExt(boolean create) {
            Object ext = this._ext.getValue();
            if (ext == null && !create) {
                return null;
            }
            if (ext instanceof Map) {
                return (Map)ext;
            }
            if (ext instanceof JSON.Literal) {
                JSON json = ServerMessageImpl.this._pool == null ? JSON.getDefault() : ServerMessageImpl.this._pool.getMsgJSON();
                ext = json.fromJSON(ext.toString());
                this._ext.setValue(ext);
                return (Map)ext;
            }
            ext = new NestedMap().asMutable();
            this._ext.setValue(ext);
            return (Map)ext;
        }

        public Object getId() {
            return this._id.getValue();
        }

        public boolean isLazy() {
            return ServerMessageImpl.this._lazy;
        }

        public boolean isMeta() {
            return ChannelId.isMeta((String)((String)this._channelId.getValue()));
        }

        @Override
        public Object put(String key, Object value) {
            return this._mutable.put((Object)key, value);
        }

        @Override
        public Object remove(Object key) {
            return this._mutable.remove(key);
        }

        public void setData(Object data) {
            this._data.setValue(data);
        }

        public void setLazy(boolean lazy) {
            ServerMessageImpl.this._lazy = lazy;
        }

        @Override
        public int size() {
            return this._mutable.size();
        }

        public ServerMessage getAssociated() {
            return ServerMessageImpl.this.getAssociated();
        }

        public void setAssociated(ServerMessage message) {
            ServerMessageImpl.this.setAssociated(message);
        }

        public void setClientId(String clientId) {
            this._clientId.setValue(clientId);
        }

        public void setId(Object id) {
            this._id.setValue(id);
        }

        public void setChannel(String channelId) {
            this._channelId.setValue(channelId);
        }

        public String getJSON() {
            return ServerMessageImpl.this.getJSON();
        }

        public void decRef() {
            ServerMessageImpl.this.decRef();
        }

        public void incRef() {
            ServerMessageImpl.this.incRef();
        }

        public boolean isSuccessful() {
            return ServerMessageImpl.this.isSuccessful();
        }

        public void setSuccessful(boolean success) {
            this.put("successful", (Object)(success ? Boolean.TRUE : Boolean.FALSE));
        }

        @Override
        public String toString() {
            return this.getJSON();
        }
    }
}

