/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.ServerMessageImpl;
import org.cometd.util.ImmutableHashMap;
import org.eclipse.jetty.util.StringMap;
import org.eclipse.jetty.util.ajax.JSON;

public class ServerMessagePool {
    private final ConcurrentLinkedQueue<ServerMessageImpl> _messagePool;
    private final ConcurrentLinkedQueue<JSON.ReaderSource> _readerPool;
    private StringMap _fieldStrings = new StringMap();
    private StringMap _valueStrings = new StringMap();
    private JSON _json;
    private JSON _msgJSON;
    private JSON _batchJSON;

    public ServerMessagePool() {
        this(50);
    }

    public ServerMessagePool(int capacity) {
        this._fieldStrings.put("advice", (Object)"advice");
        this._fieldStrings.put("channel", (Object)"channel");
        this._fieldStrings.put("clientId", (Object)"clientId");
        this._fieldStrings.put("data", (Object)"data");
        this._fieldStrings.put("error", (Object)"error");
        this._fieldStrings.put("ext", (Object)"ext");
        this._fieldStrings.put("id", (Object)"id");
        this._fieldStrings.put("subscription", (Object)"subscription");
        this._fieldStrings.put("successful", (Object)"successful");
        this._fieldStrings.put("timestamp", (Object)"timestamp");
        this._fieldStrings.put("transport", (Object)"transport");
        this._fieldStrings.put("connectionType", (Object)"connectionType");
        this._valueStrings.put("/meta/connect", (Object)"/meta/connect");
        this._valueStrings.put("/meta/disconnect", (Object)"/meta/disconnect");
        this._valueStrings.put("/meta/handshake", (Object)"/meta/handshake");
        this._valueStrings.put("/meta/subscribe", (Object)"/meta/subscribe");
        this._valueStrings.put("/meta/unsubscribe", (Object)"/meta/unsubscribe");
        this._valueStrings.put("long-polling", (Object)"long-polling");
        this._json = new JSON(){

            protected Map newMap() {
                return new ImmutableHashMap().asMutable();
            }

            protected String toString(char[] buffer, int offset, int length) {
                Map.Entry entry = ServerMessagePool.this._valueStrings.getEntry(buffer, offset, length);
                if (entry != null) {
                    return (String)entry.getValue();
                }
                String s = new String(buffer, offset, length);
                return s;
            }
        };
        this._msgJSON = new JSON(){

            protected Map newMap() {
                return ServerMessagePool.this.getServerMessage();
            }

            protected String toString(char[] buffer, int offset, int length) {
                Map.Entry entry = ServerMessagePool.this._fieldStrings.getEntry(buffer, offset, length);
                if (entry != null) {
                    return (String)entry.getValue();
                }
                String s = new String(buffer, offset, length);
                return s;
            }

            protected JSON contextFor(String field) {
                return ServerMessagePool.this._json;
            }
        };
        this._batchJSON = new JSON(){

            protected Map newMap() {
                return ServerMessagePool.this.getServerMessage();
            }

            protected Object[] newArray(int size) {
                return new ServerMessage.Mutable[size];
            }

            protected JSON contextFor(String field) {
                return ServerMessagePool.this._json;
            }

            protected JSON contextForArray() {
                return ServerMessagePool.this._msgJSON;
            }
        };
        this._messagePool = new ConcurrentLinkedQueue();
        this._readerPool = new ConcurrentLinkedQueue();
    }

    public JSON getJSON() {
        return this._json;
    }

    public void setJSON(JSON json) {
        this._json = json;
    }

    public JSON getMsgJSON() {
        return this._msgJSON;
    }

    public void setMsgJSON(JSON msgJSON) {
        this._msgJSON = msgJSON;
    }

    public JSON getBatchJSON() {
        return this._batchJSON;
    }

    public void setBatchJSON(JSON batchJSON) {
        this._batchJSON = batchJSON;
    }

    public ServerMessage.Mutable getServerMessage() {
        ServerMessageImpl message = this._messagePool.poll();
        if (message == null) {
            message = new ServerMessageImpl(this);
        }
        return message.asMutable();
    }

    void recycleMessage(ServerMessage message) {
        if (message instanceof ServerMessageImpl) {
            message.asMutable().clear();
            this._messagePool.offer((ServerMessageImpl)message);
        } else if (message instanceof ServerMessageImpl.MutableMessage) {
            message.clear();
            this._messagePool.offer((ServerMessageImpl)((ServerMessage.Mutable)message).asImmutable());
        }
    }

    public ServerMessage.Mutable[] parseMessages(Reader reader) throws IOException {
        JSON.ReaderSource source = this._readerPool.poll();
        if (source == null) {
            source = new JSON.ReaderSource(reader);
        } else {
            source.setReader(reader);
        }
        Object batch = this._batchJSON.parse((JSON.Source)source);
        this._readerPool.offer(source);
        if (batch == null) {
            return new ServerMessage.Mutable[0];
        }
        if (batch.getClass().isArray()) {
            return (ServerMessage.Mutable[])batch;
        }
        return new ServerMessage.Mutable[]{(ServerMessage.Mutable)batch};
    }

    public ServerMessage.Mutable[] parseMessages(String s) throws IOException {
        Object batch = this._batchJSON.parse((JSON.Source)new JSON.StringSource(s));
        if (batch == null) {
            return new ServerMessage.Mutable[0];
        }
        if (batch.getClass().isArray()) {
            return (ServerMessage.Mutable[])batch;
        }
        return new ServerMessage.Mutable[]{(ServerMessage.Mutable)batch};
    }

    public ServerMessage.Mutable parseMessage(String s) throws IOException {
        return (ServerMessage.Mutable)this._msgJSON.parse((JSON.Source)new JSON.StringSource(s));
    }

    public String toString() {
        return "MessagePool:" + this._messagePool.size();
    }
}

