/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cometd.bayeux.Transport;
import org.cometd.server.BayeuxServerImpl;
import org.eclipse.jetty.util.ajax.JSON;

public class ServerTransport
implements Transport {
    public static final String TIMEOUT_OPTION = "timeout";
    public static final String INTERVAL_OPTION = "interval";
    public static final String MAX_INTERVAL_OPTION = "maxInterval";
    public static final String MAX_LAZY_OPTION = "maxLazyTimeout";
    public static final String META_CONNECT_DELIVERY_OPTION = "metaConnectDeliverOnly";
    protected final BayeuxServerImpl _bayeux;
    protected long _interval = 0L;
    protected long _maxInterval = 10000L;
    protected long _timeout = 10000L;
    protected long _maxLazyTimeout = 5000L;
    protected boolean _metaConnectDeliveryOnly = false;
    protected Object _advice;
    private final String _name;
    private final Map<String, Object> _options;
    protected final List<String> _prefix = new ArrayList<String>();

    protected ServerTransport(BayeuxServerImpl bayeux, String name, Map<String, Object> options) {
        this._name = name;
        this._options = options;
        this._bayeux = bayeux;
        this.setOption(TIMEOUT_OPTION, this._timeout);
        this.setOption(INTERVAL_OPTION, this._interval);
        this.setOption(MAX_INTERVAL_OPTION, this._maxInterval);
        this.setOption(MAX_LAZY_OPTION, this._maxLazyTimeout);
        this.setOption(META_CONNECT_DELIVERY_OPTION, this._metaConnectDeliveryOnly);
    }

    public Object getAdvice() {
        return this._advice;
    }

    public long getInterval() {
        return this._interval;
    }

    public long getMaxInterval() {
        return this._maxInterval;
    }

    public long getMaxLazyTimeout() {
        return this._maxLazyTimeout;
    }

    public String getName() {
        return this._name;
    }

    public Object getOption(String name) {
        Object value = this._options.get(name);
        String prefix = null;
        for (String segment : this._prefix) {
            String key = (prefix = prefix == null ? segment : prefix + "." + segment) + "." + name;
            if (!this._options.containsKey(key)) continue;
            value = this._options.get(key);
        }
        return value;
    }

    public boolean getOption(String option, boolean dftValue) {
        Object value = this.getOption(option);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public int getOption(String option, int dftValue) {
        Object value = this.getOption(option);
        if (value == null) {
            return -1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    public long getOption(String option, long dftValue) {
        Object value = this.getOption(option);
        if (value == null) {
            return -1L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    public String getOption(String option, String dftValue) {
        Object value = this.getOption(option);
        return value == null ? dftValue : value.toString();
    }

    public Set<String> getOptionNames() {
        HashSet<String> names = new HashSet<String>();
        names.add(INTERVAL_OPTION);
        names.add(MAX_INTERVAL_OPTION);
        names.add(TIMEOUT_OPTION);
        names.add(MAX_LAZY_OPTION);
        return names;
    }

    public String getOptionPrefix() {
        String prefix = null;
        for (String segment : this._prefix) {
            prefix = prefix == null ? segment : prefix + "." + segment;
        }
        return prefix;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public boolean isMetaConnectDeliveryOnly() {
        return this._metaConnectDeliveryOnly;
    }

    public void setMetaConnectDeliveryOnly(boolean meta) {
        this._metaConnectDeliveryOnly = meta;
    }

    public void setOption(String name, Object value) {
        String prefix = this.getOptionPrefix();
        this._options.put(prefix == null ? name : prefix + "." + name, value);
    }

    protected void init() {
        this._interval = this.getOption(INTERVAL_OPTION, this._interval);
        this._maxInterval = this.getOption(MAX_INTERVAL_OPTION, this._maxInterval);
        this._timeout = this.getOption(TIMEOUT_OPTION, this._timeout);
        this._maxLazyTimeout = this.getOption(MAX_LAZY_OPTION, this._maxLazyTimeout);
        this._metaConnectDeliveryOnly = this.getOption(META_CONNECT_DELIVERY_OPTION, this._metaConnectDeliveryOnly);
        this._advice = new JSON.Literal("{\"reconnect\":\"retry\",\"interval\":" + this._interval + ",\"timeout\":" + this._timeout + "}");
    }

    public static interface Dispatcher {
        public void cancelDispatch();

        public void dispatch();
    }
}

