/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.Iterator;
import java.util.Map;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.ext.ArrayIdQueue;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.log.Log;

public class AcknowledgedMessagesClientExtension
implements ServerSession.Extension {
    private final ServerSession _session;
    private final ArrayQueue<ServerMessage> _queue;
    private final ArrayIdQueue<ServerMessage> _unackedQueue;
    private long _lastAck;

    public AcknowledgedMessagesClientExtension(ServerSession session) {
        this._session = session;
        this._queue = (ArrayQueue)session.getQueue();
        this._unackedQueue = new ArrayIdQueue(16, 32, session.getQueue());
        this._unackedQueue.setCurrentId(1);
    }

    public boolean rcv(ServerSession from, ServerMessage.Mutable message) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rcvMeta(ServerSession session, ServerMessage.Mutable message) {
        Map ext;
        if ("/meta/connect".equals(message.getChannel()) && (ext = message.getExt(false)) != null) {
            assert (session == this._session);
            ArrayQueue<ServerMessage> arrayQueue = this._queue;
            synchronized (arrayQueue) {
                Long acked = (Long)ext.get("ack");
                if (acked != null) {
                    if (acked <= this._lastAck) {
                        Log.debug((String)(session + " lost ACK " + acked + "<=" + this._lastAck));
                        Iterator i$ = this._unackedQueue.iterator();
                        while (i$.hasNext()) {
                            ServerMessage m = (ServerMessage)i$.next();
                            m.incRef();
                        }
                        for (ServerMessage m : this._queue) {
                            m.decRef();
                        }
                        this._queue.clear();
                        this._queue.addAll(this._unackedQueue);
                    } else {
                        this._lastAck = acked;
                        int s = this._unackedQueue.size();
                        if (s > 0) {
                            if (this._unackedQueue.getAssociatedIdUnsafe(s - 1) <= acked) {
                                for (int i = 0; i < s; ++i) {
                                    ServerMessage q = (ServerMessage)this._unackedQueue.getUnsafe(i);
                                    q.decRef();
                                }
                                this._unackedQueue.clear();
                            } else {
                                long a;
                                for (int i = 0; i < s && (a = this._unackedQueue.getAssociatedIdUnsafe(0)) <= acked; ++i) {
                                    ServerMessage q = (ServerMessage)this._unackedQueue.remove();
                                    q.decRef();
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerMessage send(ServerSession to, ServerMessage message) {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            message.incRef();
            this._unackedQueue.add(message);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
        if (message.getChannel().equals("/meta/connect")) {
            ArrayQueue<ServerMessage> arrayQueue = this._queue;
            synchronized (arrayQueue) {
                Map ext = message.getExt(true);
                ext.put("ack", this._unackedQueue.getCurrentId());
                this._unackedQueue.incrementCurrentId();
            }
        }
        return true;
    }
}

