/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transports;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.transports.LongPollingTransport;

public class JSONTransport
extends LongPollingTransport {
    public static final String NAME = "long-polling";
    public static final String MIME_TYPE_OPTION = "mimeType";
    protected String _mimeType = "application/json;charset=UTF-8";

    public JSONTransport(BayeuxServerImpl bayeux, Map<String, Object> options) {
        super(bayeux, NAME, options);
        this._prefix.add("json");
        this.setOption(MIME_TYPE_OPTION, this._mimeType);
        this._metaConnectDeliveryOnly = false;
    }

    @Override
    protected void init() {
        super.init();
        this._mimeType = this.getOption(MIME_TYPE_OPTION, this._mimeType);
    }

    @Override
    public boolean isMetaConnectDeliveryOnly() {
        return false;
    }

    @Override
    protected PrintWriter send(HttpServletRequest request, HttpServletResponse response, PrintWriter writer, ServerMessage message) throws IOException {
        if (writer == null) {
            response.setContentType(this._mimeType);
            writer = response.getWriter();
            writer.append('[');
        } else {
            writer.append(',');
        }
        writer.append(message.getJSON());
        return writer;
    }

    @Override
    protected void complete(PrintWriter writer) throws IOException {
        writer.append("]\n");
        writer.close();
    }
}

