/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transports;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Queue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.ServerTransport;
import org.cometd.server.transports.HttpTransport;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;

public class WebSocketTransport
extends HttpTransport {
    public static final String NAME = "websocket";
    public static final String PROTOCOL_OPTION = "protocol";
    public static final String BUFFER_SIZE_OPTION = "bufferSize";
    private final WebSocketFactory _factory = new WebSocketFactory();
    private String _protocol = "";

    public WebSocketTransport(BayeuxServerImpl bayeux, Map<String, Object> options) {
        super(bayeux, NAME, options);
        this._prefix.add("ws");
        this.setOption(PROTOCOL_OPTION, this._protocol);
        this.setOption(BUFFER_SIZE_OPTION, this._factory.getBufferSize());
        this._metaConnectDeliveryOnly = false;
        this.setOption("metaConnectDeliverOnly", this._metaConnectDeliveryOnly);
        this._timeout = 15000L;
        this.setOption("timeout", this._timeout);
        this._interval = 2500L;
        this.setOption("interval", this._interval);
        this._maxInterval = 15000L;
        this.setOption("maxInterval", this._maxInterval);
    }

    @Override
    public void init() {
        this._protocol = this.getOption(PROTOCOL_OPTION, this._protocol);
        this._factory.setBufferSize(this.getOption(BUFFER_SIZE_OPTION, this._factory.getBufferSize()));
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        WebSocketDispatcher websocket;
        String protocol = request.getHeader("WebSocket-Protocol");
        String host = request.getHeader("Host");
        String origin = request.getHeader("Origin");
        if ((origin = this.checkOrigin(request, host, origin)) == null || this._protocol != null && this._protocol.length() > 0 && !this._protocol.equals(protocol)) {
            response.sendError(403);
            return;
        }
        WebSocketDispatcher webSocketDispatcher = websocket = this.isMetaConnectDeliveryOnly() ? null : new WebSocketDispatcher();
        if (websocket != null) {
            this._factory.upgrade(request, response, (WebSocket)websocket, origin, protocol);
        } else {
            response.sendError(403);
        }
    }

    protected String checkOrigin(HttpServletRequest request, String host, String origin) {
        if (origin == null) {
            origin = host;
        }
        return origin;
    }

    protected class WebSocketDispatcher
    implements WebSocket,
    ServerTransport.Dispatcher {
        protected ServerSessionImpl _session;
        protected WebSocket.Outbound _outbound;
        protected ServerMessage _connectReply;
        protected final Timeout.Task _timeoutTask = new Timeout.Task(){

            public void expired() {
                if (WebSocketDispatcher.this._session != null && WebSocketDispatcher.this._session.setDispatcher(null)) {
                    WebSocketDispatcher.this.dispatch();
                }
            }
        };

        protected WebSocketDispatcher() {
        }

        public void onConnect(WebSocket.Outbound outbound) {
            this._outbound = outbound;
        }

        public void onDisconnect() {
            if (this._session != null) {
                this._session.cancelIntervalTimeout();
                WebSocketTransport.this._bayeux.cancelTimeout(this._timeoutTask);
                WebSocketTransport.this._bayeux.removeServerSession(this._session, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(byte frame, String data) {
            System.err.println(">WS>" + data);
            boolean batch = false;
            try {
                ServerMessage.Mutable[] messages;
                WebSocketTransport.this._bayeux.setCurrentTransport(WebSocketTransport.this);
                for (ServerMessage.Mutable message : messages = WebSocketTransport.this._bayeux.getServerMessagePool().parseMessages(data)) {
                    message.incRef();
                    boolean connect = "/meta/connect".equals(message.getChannel());
                    if (this._session == null) {
                        this._session = (ServerSessionImpl)WebSocketTransport.this._bayeux.getSession(message.getClientId());
                    }
                    if (!batch && this._session != null && !connect) {
                        batch = true;
                        this._session.startBatch();
                    }
                    boolean was_connected = this._session != null && this._session.isConnected();
                    ServerMessage reply = WebSocketTransport.this._bayeux.handle(this._session, message);
                    if (connect && reply.isSuccessful()) {
                        long timeout;
                        if (!this._session.setDispatcher(this)) {
                            this.dispatch();
                        }
                        if ((timeout = this._session.getTimeout()) < 0L) {
                            timeout = WebSocketTransport.this._timeout;
                        }
                        if (this._session.setDispatcher(this) && timeout > 0L && was_connected) {
                            WebSocketTransport.this._bayeux.startTimeout(this._timeoutTask, timeout);
                            this._connectReply = reply;
                            this._connectReply.incRef();
                            reply = null;
                        } else if (!was_connected) {
                            this._session.startIntervalTimeout();
                        }
                    }
                    if (reply != null) {
                        reply = WebSocketTransport.this._bayeux.extendReply(this._session, reply);
                        if (batch) {
                            reply.incRef();
                            this._session.getQueue().add(reply);
                        } else {
                            this.send(reply);
                        }
                    }
                    message.setAssociated(null);
                    message.decRef();
                }
            }
            catch (IOException e) {
                WebSocketTransport.this._bayeux.getLogger().warn("", (Throwable)e);
            }
            finally {
                WebSocketTransport.this._bayeux.setCurrentTransport(null);
                if (batch) {
                    this._session.endBatch();
                }
            }
        }

        public void onMessage(byte frame, byte[] data, int offset, int length) {
            try {
                this.onMessage(frame, new String(data, offset, length, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Log.warn((Throwable)e);
            }
        }

        @Override
        public void cancelDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() {
            while (this._session != null) {
                Queue<ServerMessage> queue;
                Queue<ServerMessage> queue2 = queue = this._session.getQueue();
                synchronized (queue2) {
                    this._session.dequeue();
                    if (this._connectReply != null) {
                        queue.add(WebSocketTransport.this._bayeux.extendReply(this._session, this._connectReply));
                        this._connectReply = null;
                        this._session.startIntervalTimeout();
                    }
                    try {
                        if (queue.size() > 0) {
                            this.send(queue);
                        }
                    }
                    catch (IOException e) {
                        WebSocketTransport.this._bayeux.getLogger().warn("io ", (Throwable)e);
                    }
                    for (ServerMessage message : queue) {
                        message.decRef();
                    }
                    queue.clear();
                }
                if (!WebSocketTransport.this.isMetaConnectDeliveryOnly() && !this._session.setDispatcher(this)) continue;
                break;
            }
        }

        protected void send(Queue<ServerMessage> messages) throws IOException {
            String data = JSON.toString(messages);
            this._outbound.sendMessage(data);
        }

        protected void send(ServerMessage message) throws IOException {
            String data = message.getJSON();
            this._outbound.sendMessage("[" + data + "]");
        }
    }
}

