/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.common.HashMapMessage;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerMessageImpl
extends HashMapMessage
implements ServerMessage.Mutable,
JSON.Generator {
    private static final long serialVersionUID = 6412048662640296067L;
    private volatile transient ServerMessage.Mutable _associated;
    private volatile boolean _lazy = false;
    private volatile String _json;
    private static JSON serverMessageParser = new JSON(){

        protected Map<String, Object> newMap() {
            return new ServerMessageImpl();
        }

        protected JSON contextFor(String field) {
            return jsonParser;
        }
    };
    private static JSON serverMessagesParser = new JSON(){

        protected Map<String, Object> newMap() {
            return new ServerMessageImpl();
        }

        protected Object[] newArray(int size) {
            return new ServerMessage.Mutable[size];
        }

        protected JSON contextFor(String field) {
            return jsonParser;
        }

        protected JSON contextForArray() {
            return serverMessageParser;
        }
    };

    public ServerMessage.Mutable getAssociated() {
        return this._associated;
    }

    public void setAssociated(ServerMessage.Mutable associated) {
        this._associated = associated;
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    public void freeze() {
        this._json = this.getJSON();
    }

    public String getJSON() {
        if (this._json == null) {
            return super.getJSON();
        }
        return this._json;
    }

    public Object getData() {
        Object data = super.getData();
        if (this._json != null && data instanceof Map) {
            return Collections.unmodifiableMap((Map)data);
        }
        return data;
    }

    public Object put(String key, Object value) {
        if (this._json != null) {
            throw new UnsupportedOperationException();
        }
        return super.put((Object)key, value);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        if (this._json != null) {
            return new ImmutableEntrySet(super.entrySet());
        }
        return super.entrySet();
    }

    public Map<String, Object> getDataAsMap() {
        Map data = super.getDataAsMap();
        if (this._json != null && data != null) {
            return Collections.unmodifiableMap(data);
        }
        return data;
    }

    public Map<String, Object> getExt() {
        Map ext = super.getExt();
        if (this._json != null && ext != null) {
            return Collections.unmodifiableMap(ext);
        }
        return ext;
    }

    public Map<String, Object> getAdvice() {
        Map advice = super.getAdvice();
        if (this._json != null && advice != null) {
            return Collections.unmodifiableMap(advice);
        }
        return advice;
    }

    public static ServerMessage.Mutable[] parseServerMessages(Reader reader, boolean jsonDebug) throws ParseException, IOException {
        if (jsonDebug) {
            return ServerMessageImpl.parseServerMessages(IO.toString((Reader)reader));
        }
        try {
            Object batch = serverMessagesParser.parse((JSON.Source)new JSON.ReaderSource(reader));
            if (batch == null) {
                return new ServerMessage.Mutable[0];
            }
            if (batch.getClass().isArray()) {
                return (ServerMessage.Mutable[])batch;
            }
            return new ServerMessage.Mutable[]{(ServerMessage.Mutable)batch};
        }
        catch (Exception x) {
            throw (ParseException)new ParseException("", -1).initCause(x);
        }
    }

    public static ServerMessage.Mutable[] parseServerMessages(String s) throws ParseException {
        try {
            Object batch = serverMessagesParser.parse((JSON.Source)new JSON.StringSource(s));
            if (batch == null) {
                return new ServerMessage.Mutable[0];
            }
            if (batch.getClass().isArray()) {
                return (ServerMessage.Mutable[])batch;
            }
            return new ServerMessage.Mutable[]{(ServerMessage.Mutable)batch};
        }
        catch (Exception x) {
            throw (ParseException)new ParseException(s, -1).initCause(x);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImmutableEntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private final Set<Map.Entry<String, Object>> delegate;

        private ImmutableEntrySet(Set<Map.Entry<String, Object>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new ImmutableEntryIterator(this.delegate.iterator());
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ImmutableEntryIterator
        implements Iterator<Map.Entry<String, Object>> {
            private final Iterator<Map.Entry<String, Object>> delegate;

            private ImmutableEntryIterator(Iterator<Map.Entry<String, Object>> delegate) {
                this.delegate = delegate;
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Map.Entry<String, Object> next() {
                return new ImmutableEntry(this.delegate.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static class ImmutableEntry
            implements Map.Entry<String, Object> {
                private final Map.Entry<String, Object> delegate;

                private ImmutableEntry(Map.Entry<String, Object> delegate) {
                    this.delegate = delegate;
                }

                @Override
                public String getKey() {
                    return this.delegate.getKey();
                }

                @Override
                public Object getValue() {
                    return this.delegate.getValue();
                }

                @Override
                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }
}

