/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.Map;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.eclipse.jetty.util.ajax.JSON;

public class TimesyncExtension
implements BayeuxServer.Extension {
    private int _accuracyTarget = 25;

    public int getAccuracyTarget() {
        return this._accuracyTarget;
    }

    public void setAccuracyTarget(int target) {
        this._accuracyTarget = target;
    }

    public boolean rcv(ServerSession from, ServerMessage.Mutable message) {
        return true;
    }

    public boolean rcvMeta(ServerSession from, ServerMessage.Mutable message) {
        Map sync;
        Map ext = message.getExt(false);
        if (ext != null && (sync = (Map)ext.get("timesync")) != null) {
            sync.put("ts", System.currentTimeMillis());
            Number lag = (Number)sync.get("l");
            if (lag != null && from != null) {
                from.setAttribute("lag", (Object)lag);
            }
        }
        return true;
    }

    public boolean send(ServerSession from, ServerSession to, ServerMessage.Mutable message) {
        return true;
    }

    public boolean sendMeta(ServerSession session, ServerMessage.Mutable message) {
        Map sync;
        Map extIn;
        ServerMessage.Mutable associated = message.getAssociated();
        if (associated != null && (extIn = associated.getExt()) != null && (sync = (Map)extIn.get("timesync")) != null) {
            long tc = ((Number)sync.get("tc")).longValue();
            long ts = ((Number)sync.get("ts")).longValue();
            Number lag = (Number)sync.get("l");
            if (lag == null) {
                Map extOut = message.getExt(true);
                JSON.Literal timesync = new JSON.Literal("{\"tc\":" + tc + ",\"ts\":" + ts + ",\"p\":" + (System.currentTimeMillis() - ts) + "}");
                extOut.put("timesync", timesync);
            } else {
                int l = lag.intValue();
                int o = ((Number)sync.get("o")).intValue();
                int a = (int)(tc + (long)o + (long)l - ts);
                if (l == 0 || a >= this._accuracyTarget || a <= -this._accuracyTarget) {
                    Map extOut = message.getExt(true);
                    JSON.Literal timesync = new JSON.Literal("{\"tc\":" + tc + ",\"ts\":" + ts + ",\"p\":" + (System.currentTimeMillis() - ts) + ",\"a\":" + a + "}");
                    extOut.put("timesync", timesync);
                }
            }
        }
        return true;
    }
}

