/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.transport.LongPollingTransport;

public class JSONTransport
extends LongPollingTransport {
    public static final String PREFIX = "long-polling.json";
    public static final String NAME = "long-polling";
    public static final String MIME_TYPE_OPTION = "mimeType";
    private String _mimeType = "application/json;charset=UTF-8";

    public JSONTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    protected boolean isAlwaysFlushingAfterHandle() {
        return false;
    }

    protected void init() {
        super.init();
        this._mimeType = this.getOption(MIME_TYPE_OPTION, this._mimeType);
    }

    public boolean accept(HttpServletRequest request) {
        return "POST".equals(request.getMethod());
    }

    public boolean isMetaConnectDeliveryOnly() {
        return false;
    }

    protected PrintWriter send(HttpServletRequest request, HttpServletResponse response, PrintWriter writer, ServerMessage message) throws IOException {
        if (writer == null) {
            response.setContentType(this._mimeType);
            writer = response.getWriter();
            writer.append('[');
        } else {
            writer.append(',');
        }
        writer.append(message.getJSON());
        return writer;
    }

    protected void complete(PrintWriter writer) throws IOException {
        writer.append("]\n");
        writer.close();
    }
}

