/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.HttpTransport;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.util.log.Log;

public abstract class LongPollingTransport
extends HttpTransport {
    public static final String PREFIX = "long-polling";
    public static final String BROWSER_ID_OPTION = "browserId";
    public static final String MAX_SESSIONS_PER_BROWSER_OPTION = "maxSessionsPerBrowser";
    public static final String MULTI_SESSION_INTERVAL_OPTION = "multiSessionInterval";
    public static final String AUTOBATCH_OPTION = "autoBatch";
    public static final String ALLOW_MULTI_SESSIONS_NO_BROWSER_OPTION = "allowMultiSessionsNoBrowser";
    private final ConcurrentHashMap<String, AtomicInteger> _browserMap = new ConcurrentHashMap();
    private final Map<String, AtomicInteger> _browserSweep = new ConcurrentHashMap<String, AtomicInteger>();
    private String _browserId = "BAYEUX_BROWSER";
    private int _maxSessionsPerBrowser = 1;
    private long _multiSessionInterval = 2000L;
    private boolean _autoBatch = true;
    private boolean _allowMultiSessionsNoBrowser = false;
    private long _lastSweep;

    protected LongPollingTransport(BayeuxServerImpl bayeux, String name) {
        super(bayeux, name);
        this.setOptionPrefix(PREFIX);
    }

    protected void init() {
        super.init();
        this._browserId = this.getOption(BROWSER_ID_OPTION, this._browserId);
        this._maxSessionsPerBrowser = this.getOption(MAX_SESSIONS_PER_BROWSER_OPTION, this._maxSessionsPerBrowser);
        this._multiSessionInterval = this.getOption(MULTI_SESSION_INTERVAL_OPTION, this._multiSessionInterval);
        this._autoBatch = this.getOption(AUTOBATCH_OPTION, this._autoBatch);
        this._allowMultiSessionsNoBrowser = this.getOption(ALLOW_MULTI_SESSIONS_NO_BROWSER_OPTION, this._allowMultiSessionsNoBrowser);
    }

    protected String findBrowserId(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._browserId.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected String setBrowserId(HttpServletRequest request, HttpServletResponse response) {
        String browser_id = Long.toHexString(request.getRemotePort()) + Long.toString(this.getBayeux().randomLong(), 36) + Long.toString(System.currentTimeMillis(), 36) + Long.toString(request.getRemotePort(), 36);
        Cookie cookie = new Cookie(this._browserId, browser_id);
        cookie.setPath("/");
        cookie.setMaxAge(-1);
        response.addCookie(cookie);
        return browser_id;
    }

    protected boolean incBrowserId(String browserId) {
        int sessions;
        AtomicInteger new_count;
        if (this._maxSessionsPerBrowser < 0) {
            return true;
        }
        if (this._maxSessionsPerBrowser == 0) {
            return false;
        }
        AtomicInteger count = this._browserMap.get(browserId);
        if (count == null && (count = this._browserMap.putIfAbsent(browserId, new_count = new AtomicInteger())) == null) {
            count = new_count;
        }
        if ((sessions = count.incrementAndGet()) == 1) {
            this._browserSweep.remove(browserId);
        }
        if (sessions > this._maxSessionsPerBrowser) {
            count.decrementAndGet();
            return false;
        }
        return true;
    }

    protected void decBrowserId(String browserId) {
        if (browserId == null) {
            return;
        }
        AtomicInteger count = this._browserMap.get(browserId);
        if (count != null && count.decrementAndGet() == 0) {
            this._browserSweep.put(browserId, new AtomicInteger(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LongPollScheduler scheduler = (LongPollScheduler)request.getAttribute("cometd.scheduler");
        if (scheduler == null) {
            boolean batch = false;
            ServerSessionImpl session = null;
            boolean connect = false;
            try {
                ServerMessage.Mutable[] messages = this.parseMessages(request);
                if (messages == null) {
                    return;
                }
                PrintWriter writer = null;
                for (ServerMessage.Mutable message : messages) {
                    connect = "/meta/connect".equals(message.getChannel());
                    String client_id = message.getClientId();
                    if (session == null || client_id != null && !client_id.equals(session.getId())) {
                        session = (ServerSessionImpl)this.getBayeux().getSession(client_id);
                        if (this._autoBatch && !batch && session != null && !connect && !message.isMeta()) {
                            batch = true;
                            session.startBatch();
                        }
                    } else if (!session.isHandshook()) {
                        batch = false;
                        session = null;
                    }
                    if (connect && session != null) {
                        session.setScheduler(null);
                    }
                    boolean wasConnected = session != null && session.isConnected();
                    ServerMessage.Mutable reply = this.getBayeux().handle(session, message);
                    if (reply != null) {
                        if (session == null) {
                            session = (ServerSessionImpl)this.getBayeux().getSession(reply.getClientId());
                            if (session != null) {
                                String userAgent = request.getHeader("User-Agent");
                                session.setUserAgent(userAgent);
                                String browserId = this.findBrowserId(request);
                                if (browserId == null) {
                                    this.setBrowserId(request, response);
                                }
                            }
                        } else {
                            if (connect || !this.isMetaConnectDeliveryOnly() && !session.isMetaConnectDeliveryOnly()) {
                                writer = this.sendQueue(request, response, session, writer);
                            }
                            if (connect) {
                                long timeout = session.calculateTimeout(this.getTimeout());
                                if (writer == null && reply.isSuccessful() && session.isQueueEmpty()) {
                                    boolean shouldSuspend;
                                    String browserId = this.findBrowserId(request);
                                    if (browserId != null) {
                                        shouldSuspend = this.incBrowserId(browserId);
                                    } else {
                                        boolean bl = shouldSuspend = this._allowMultiSessionsNoBrowser || request.getHeader("Origin") != null;
                                    }
                                    if (shouldSuspend) {
                                        if (timeout > 0L && wasConnected) {
                                            Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                                            continuation.setTimeout(timeout);
                                            continuation.suspend((ServletResponse)response);
                                            scheduler = new LongPollScheduler(session, continuation, reply, browserId);
                                            session.setScheduler(scheduler);
                                            request.setAttribute("cometd.scheduler", (Object)scheduler);
                                            reply = null;
                                        } else {
                                            this.decBrowserId(browserId);
                                        }
                                    } else {
                                        Map advice = reply.getAdvice(true);
                                        if (browserId != null) {
                                            advice.put("multiple-clients", true);
                                        }
                                        if (this._multiSessionInterval > 0L) {
                                            advice.put("reconnect", "retry");
                                            advice.put("interval", this._multiSessionInterval);
                                        } else {
                                            advice.put("reconnect", "none");
                                            reply.setSuccessful(false);
                                        }
                                        session.reAdvise();
                                    }
                                }
                                if (reply != null && session.isConnected()) {
                                    session.startIntervalTimeout();
                                }
                            }
                        }
                        if (reply != null && (reply = this.getBayeux().extendReply(session, session, reply)) != null) {
                            writer = this.send(request, response, writer, (ServerMessage)reply);
                        }
                    }
                    message.setAssociated(null);
                }
                if (writer == null) return;
                this.complete(writer);
                return;
            }
            catch (ParseException x) {
                this.handleJSONParseException(request, response, x.getMessage(), x.getCause());
                return;
            }
            finally {
                if (batch) {
                    boolean ended = session.endBatch();
                    if (!ended && this.isAlwaysFlushingAfterHandle()) {
                        session.flush();
                    }
                } else if (session != null && !connect && this.isAlwaysFlushingAfterHandle()) {
                    session.flush();
                }
            }
        } else {
            ServerSessionImpl session = scheduler.getSession();
            if (session.isConnected()) {
                session.startIntervalTimeout();
            }
            PrintWriter writer = this.sendQueue(request, response, session, null);
            ServerMessage.Mutable reply = scheduler.getReply();
            reply = this.getBayeux().extendReply(session, session, reply);
            writer = this.send(request, response, writer, (ServerMessage)reply);
            this.complete(writer);
        }
    }

    protected void handleJSONParseException(HttpServletRequest request, HttpServletResponse response, String json, Throwable exception) throws ServletException, IOException {
        this.getBayeux().getLogger().debug("Error parsing JSON: " + json, exception);
        response.sendError(400);
    }

    protected void doSweep() {
        long now = System.currentTimeMillis();
        if (0L < this._lastSweep && this._lastSweep < now) {
            int maxSweeps = (int)(2L * this.getMaxInterval() / (now - this._lastSweep));
            for (Map.Entry<String, AtomicInteger> entry : this._browserSweep.entrySet()) {
                String key;
                AtomicInteger count = entry.getValue();
                if (count == null || count.incrementAndGet() <= maxSweeps || this._browserSweep.remove(key = entry.getKey()) != count || this._browserMap.get(key).get() != 0) continue;
                this._browserMap.remove(key);
                this.getBayeux().getLogger().debug("Swept browserId {}", new Object[]{key});
            }
        }
        this._lastSweep = now;
    }

    private PrintWriter sendQueue(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, PrintWriter writer) throws IOException {
        List<ServerMessage> queue = session.takeQueue();
        for (ServerMessage m : queue) {
            writer = this.send(request, response, writer, m);
        }
        return writer;
    }

    protected abstract boolean isAlwaysFlushingAfterHandle();

    protected abstract PrintWriter send(HttpServletRequest var1, HttpServletResponse var2, PrintWriter var3, ServerMessage var4) throws IOException;

    protected abstract void complete(PrintWriter var1) throws IOException;

    private class LongPollScheduler
    implements AbstractServerTransport.OneTimeScheduler,
    ContinuationListener {
        private final ServerSessionImpl _session;
        private final Continuation _continuation;
        private final ServerMessage.Mutable _reply;
        private String _browserId;

        public LongPollScheduler(ServerSessionImpl session, Continuation continuation, ServerMessage.Mutable reply, String browserId) {
            this._session = session;
            this._continuation = continuation;
            this._continuation.addContinuationListener((ContinuationListener)this);
            this._reply = reply;
            this._browserId = browserId;
        }

        public void cancel() {
            if (this._continuation != null && this._continuation.isSuspended() && !this._continuation.isExpired()) {
                try {
                    this.decBrowserId();
                    ((HttpServletResponse)this._continuation.getServletResponse()).sendError(408);
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
                try {
                    this._continuation.complete();
                }
                catch (Exception e) {
                    Log.ignore((Throwable)e);
                }
            }
        }

        public void schedule() {
            this.decBrowserId();
            this._continuation.resume();
        }

        public ServerSessionImpl getSession() {
            return this._session;
        }

        public ServerMessage.Mutable getReply() {
            return this._reply;
        }

        public void onComplete(Continuation continuation) {
            this.decBrowserId();
        }

        public void onTimeout(Continuation continuation) {
            this._session.setScheduler(null);
        }

        private void decBrowserId() {
            LongPollingTransport.this.decBrowserId(this._browserId);
            this._browserId = null;
        }
    }
}

