/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.HttpTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CometdServlet
extends GenericServlet {
    private static final long serialVersionUID = 3637310585741732936L;
    @Deprecated
    public static final int CONFIG_LEVEL = 1;
    @Deprecated
    public static final int INFO_LEVEL = 2;
    @Deprecated
    public static final int DEBUG_LEVEL = 3;
    private final List<HttpTransport> _transports = new ArrayList<HttpTransport>();
    private volatile BayeuxServerImpl _bayeux;

    public void init() throws ServletException {
        try {
            boolean export = false;
            this._bayeux = (BayeuxServerImpl)((Object)this.getServletContext().getAttribute("org.cometd.bayeux"));
            if (this._bayeux == null) {
                export = true;
                this._bayeux = this.newBayeuxServer();
                Object allowed = null;
                Enumeration initParameterNames = this.getInitParameterNames();
                while (initParameterNames.hasMoreElements()) {
                    String initParameterName = (String)initParameterNames.nextElement();
                    String value = this.getInitParameter(initParameterName);
                    if ("transports".equals(initParameterName)) {
                        ClassLoader loader = Thread.currentThread().getContextClassLoader();
                        if (loader == null) {
                            loader = ((Object)((Object)this)).getClass().getClassLoader();
                        }
                        for (String classname : value.split("\\s*,\\s*")) {
                            try {
                                Class<?> transportClass = loader.loadClass(classname);
                                Constructor<?> constructor = transportClass.getConstructor(BayeuxServerImpl.class);
                                ServerTransport transport = (ServerTransport)constructor.newInstance(new Object[]{this._bayeux});
                                this._bayeux.addTransport(transport);
                            }
                            catch (Error e) {
                                this._bayeux.getLogger().warn("Failed to add transport " + classname + " : " + e, new Object[0]);
                                this._bayeux.getLogger().debug((Throwable)e);
                            }
                            catch (Exception e) {
                                this._bayeux.getLogger().warn("Failed to add transport " + classname + " : " + e, new Object[0]);
                                this._bayeux.getLogger().debug((Throwable)e);
                            }
                        }
                        continue;
                    }
                    if ("allowedTransports".equalsIgnoreCase(initParameterName)) {
                        this._bayeux.setAllowedTransports(value.split("\\s*,\\s*"));
                        continue;
                    }
                    this._bayeux.setOption(initParameterName, value);
                }
            }
            this._bayeux.start();
            if (export) {
                this.getServletContext().setAttribute("org.cometd.bayeux", (Object)this._bayeux);
            }
            for (String transportName : this._bayeux.getAllowedTransports()) {
                ServerTransport transport = this._bayeux.getTransport(transportName);
                if (!(transport instanceof HttpTransport)) continue;
                this._transports.add((HttpTransport)transport);
            }
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    public BayeuxServerImpl getBayeux() {
        return this._bayeux;
    }

    protected BayeuxServerImpl newBayeuxServer() {
        return new BayeuxServerImpl();
    }

    public List<HttpTransport> getTransports() {
        return Collections.unmodifiableList(this._transports);
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        this.service(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("OPTIONS".equals(request.getMethod())) {
            this.serviceOptions(request, response);
            return;
        }
        HttpTransport transport = null;
        for (HttpTransport t : this._transports) {
            if (t == null || !t.accept(request)) continue;
            transport = t;
            break;
        }
        if (transport == null) {
            response.sendError(400, "Unknown Bayeux Transport");
        } else {
            try {
                this._bayeux.setCurrentTransport(transport);
                transport.setCurrentRequest(request);
                transport.handle(request, response);
            }
            finally {
                transport.setCurrentRequest(null);
                BayeuxServerImpl bayeux = this._bayeux;
                if (bayeux != null) {
                    bayeux.setCurrentTransport(null);
                }
            }
        }
    }

    protected void serviceOptions(HttpServletRequest request, HttpServletResponse response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        for (ServerSession session : this._bayeux.getSessions()) {
            ((ServerSessionImpl)session).cancelSchedule();
        }
        try {
            this._bayeux.stop();
        }
        catch (Exception x) {
            this._bayeux.getLogger().debug((Throwable)x);
        }
        finally {
            this._bayeux = null;
        }
        this._transports.clear();
    }
}

