/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.DefaultSecurityPolicy;
import org.cometd.server.LocalSessionImpl;
import org.cometd.server.ServerChannelImpl;
import org.cometd.server.ServerMessageImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.JSONPTransport;
import org.cometd.server.transport.JSONTransport;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BayeuxServerImpl
extends AbstractLifeCycle
implements BayeuxServer {
    public static final String LOG_LEVEL = "logLevel";
    public static final int OFF_LOG_LEVEL = 0;
    public static final int CONFIG_LOG_LEVEL = 1;
    public static final int INFO_LOG_LEVEL = 2;
    public static final int DEBUG_LOG_LEVEL = 3;
    private final Logger _logger = Log.getLogger((String)(((Object)((Object)this)).getClass().getName() + "@" + System.identityHashCode((Object)this)));
    private final SecureRandom _random = new SecureRandom();
    private final List<BayeuxServer.BayeuxServerListener> _listeners = new CopyOnWriteArrayList<BayeuxServer.BayeuxServerListener>();
    private final List<BayeuxServer.Extension> _extensions = new CopyOnWriteArrayList<BayeuxServer.Extension>();
    private final ConcurrentMap<String, ServerSessionImpl> _sessions = new ConcurrentHashMap<String, ServerSessionImpl>();
    private final ConcurrentMap<String, ServerChannelImpl> _channels = new ConcurrentHashMap<String, ServerChannelImpl>();
    private final ConcurrentMap<String, ServerTransport> _transports = new ConcurrentHashMap<String, ServerTransport>();
    private final List<String> _allowedTransports = new CopyOnWriteArrayList<String>();
    private final ThreadLocal<AbstractServerTransport> _currentTransport = new ThreadLocal();
    private final Map<String, Object> _options = new TreeMap<String, Object>();
    private final Timeout _timeout = new Timeout();
    private Timer _timer = new Timer();
    private Object _handshakeAdvice = new JSON.Literal("{\"reconnect\":\"handshake\",\"interval\":500}");
    private SecurityPolicy _policy = new DefaultSecurityPolicy();

    public BayeuxServerImpl() {
        this.addTransport(new JSONTransport(this));
        this.addTransport(new JSONPTransport(this));
    }

    public BayeuxServerImpl(List<ServerTransport> transports) {
        this.setTransports(transports);
    }

    public Logger getLogger() {
        return this._logger;
    }

    protected void doStart() throws Exception {
        long sweep_interval;
        super.doStart();
        int logLevel = 0;
        Object logLevelValue = this.getOption(LOG_LEVEL);
        if (logLevelValue != null) {
            logLevel = Integer.parseInt(String.valueOf(logLevelValue));
            this.getLogger().setDebugEnabled(logLevel > 2);
        }
        if (logLevel >= 1) {
            for (Map.Entry<String, Object> entry : this.getOptions().entrySet()) {
                this.getLogger().info(entry.getKey() + "=" + entry.getValue(), new Object[0]);
            }
        }
        this.initializeMetaChannels();
        this.initializeDefaultTransports();
        List<String> allowedTransportNames = this.getAllowedTransports();
        if (allowedTransportNames.isEmpty()) {
            throw new IllegalStateException("No allowed transport names are configured, there must be at least one");
        }
        for (String allowedTransportName : allowedTransportNames) {
            ServerTransport allowedTransport = this.getTransport(allowedTransportName);
            if (!(allowedTransport instanceof AbstractServerTransport)) continue;
            ((AbstractServerTransport)allowedTransport).init();
        }
        this._timer = new Timer("BayeuxServer@" + ((Object)((Object)this)).hashCode(), true);
        long tick_interval = this.getOption("tickIntervalMs", 97L);
        if (tick_interval > 0L) {
            this._timer.schedule(new TimerTask(){

                public void run() {
                    BayeuxServerImpl.this._timeout.tick(System.currentTimeMillis());
                }
            }, tick_interval, tick_interval);
        }
        if ((sweep_interval = this.getOption("sweepIntervalMs", 997L)) > 0L) {
            this._timer.schedule(new TimerTask(){

                public void run() {
                    BayeuxServerImpl.this.doSweep();
                    long now = System.currentTimeMillis();
                    for (ServerSessionImpl session : BayeuxServerImpl.this._sessions.values()) {
                        session.sweep(now);
                    }
                }
            }, sweep_interval, sweep_interval);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._listeners.clear();
        this._extensions.clear();
        this._sessions.clear();
        this._channels.clear();
        this._transports.clear();
        this._allowedTransports.clear();
        this._options.clear();
        this._timer.cancel();
    }

    protected void initializeMetaChannels() {
        this.createIfAbsent("/meta/handshake", new ConfigurableServerChannel.Initializer[0]);
        this.createIfAbsent("/meta/connect", new ConfigurableServerChannel.Initializer[0]);
        this.createIfAbsent("/meta/subscribe", new ConfigurableServerChannel.Initializer[0]);
        this.createIfAbsent("/meta/unsubscribe", new ConfigurableServerChannel.Initializer[0]);
        this.createIfAbsent("/meta/disconnect", new ConfigurableServerChannel.Initializer[0]);
        this.getChannel("/meta/handshake").addListener((ServerChannel.ServerChannelListener)new HandshakeHandler());
        this.getChannel("/meta/connect").addListener((ServerChannel.ServerChannelListener)new ConnectHandler());
        this.getChannel("/meta/subscribe").addListener((ServerChannel.ServerChannelListener)new SubscribeHandler());
        this.getChannel("/meta/unsubscribe").addListener((ServerChannel.ServerChannelListener)new UnsubscribeHandler());
        this.getChannel("/meta/disconnect").addListener((ServerChannel.ServerChannelListener)new DisconnectHandler());
    }

    protected void initializeDefaultTransports() {
        if (this._allowedTransports.size() == 0) {
            for (ServerTransport t : this._transports.values()) {
                this._allowedTransports.add(t.getName());
            }
        }
        this._logger.info("Allowed Transports:" + this._allowedTransports, new Object[0]);
    }

    public void startTimeout(Timeout.Task task, long interval) {
        this._timeout.schedule(task, interval);
    }

    public void cancelTimeout(Timeout.Task task) {
        task.cancel();
    }

    public ChannelId newChannelId(String id) {
        ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(id);
        if (channel != null) {
            return channel.getChannelId();
        }
        return new ChannelId(id);
    }

    public Map<String, Object> getOptions() {
        return this._options;
    }

    public Object getOption(String qualifiedName) {
        return this._options.get(qualifiedName);
    }

    protected long getOption(String name, long dft) {
        Object val = this.getOption(name);
        if (val == null) {
            return dft;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return Long.parseLong(val.toString());
    }

    public Set<String> getOptionNames() {
        return this._options.keySet();
    }

    public void setOption(String qualifiedName, Object value) {
        this._options.put(qualifiedName, value);
    }

    public void setOptions(Map<String, Object> options) {
        this._options.putAll(options);
    }

    public long randomLong() {
        return this._random.nextLong();
    }

    public void setCurrentTransport(AbstractServerTransport transport) {
        this._currentTransport.set(transport);
    }

    public ServerTransport getCurrentTransport() {
        return this._currentTransport.get();
    }

    public BayeuxContext getContext() {
        ServerTransport transport = this._currentTransport.get();
        return transport == null ? null : transport.getContext();
    }

    public SecurityPolicy getSecurityPolicy() {
        return this._policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createIfAbsent(String channelId, ConfigurableServerChannel.Initializer ... initializers) {
        ServerChannelImpl proposed;
        ServerChannelImpl channel;
        if (this._channels.containsKey(channelId)) {
            return false;
        }
        ChannelId id = new ChannelId(channelId);
        if (id.depth() > 1) {
            this.createIfAbsent(id.getParent(), new ConfigurableServerChannel.Initializer[0]);
        }
        if ((channel = this._channels.putIfAbsent(channelId, proposed = new ServerChannelImpl(this, id))) == null) {
            channel = proposed;
            this._logger.debug("added {}", new Object[]{channel});
            try {
                for (ConfigurableServerChannel.Initializer initializer : initializers) {
                    this.notifyConfigureChannel(initializer, channel);
                }
                for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                    if (!(listener instanceof ConfigurableServerChannel.Initializer)) continue;
                    this.notifyConfigureChannel((ConfigurableServerChannel.Initializer)listener, channel);
                }
            }
            finally {
                channel.initialized();
            }
            for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                if (!(listener instanceof BayeuxServer.ChannelListener)) continue;
                this.notifyChannelAdded((BayeuxServer.ChannelListener)listener, channel);
            }
            return true;
        }
        channel.waitForInitialized();
        return false;
    }

    private void notifyConfigureChannel(ConfigurableServerChannel.Initializer listener, ServerChannel channel) {
        try {
            listener.configureChannel((ConfigurableServerChannel)channel);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking listener " + listener, (Throwable)x);
        }
    }

    private void notifyChannelAdded(BayeuxServer.ChannelListener listener, ServerChannel channel) {
        try {
            listener.channelAdded(channel);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking listener " + listener, (Throwable)x);
        }
    }

    public List<ServerSession> getSessions() {
        return Collections.unmodifiableList(new ArrayList(this._sessions.values()));
    }

    public ServerSession getSession(String clientId) {
        if (clientId == null) {
            return null;
        }
        return (ServerSession)this._sessions.get(clientId);
    }

    protected void addServerSession(ServerSessionImpl session) {
        this._sessions.put(session.getId(), session);
        for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
            if (!(listener instanceof BayeuxServer.SessionListener)) continue;
            this.notifySessionAdded((BayeuxServer.SessionListener)listener, session);
        }
    }

    private void notifySessionAdded(BayeuxServer.SessionListener listener, ServerSession session) {
        try {
            listener.sessionAdded(session);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking listener " + listener, (Throwable)x);
        }
    }

    public boolean removeServerSession(ServerSession session, boolean timedout) {
        ServerSessionImpl removed;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("remove " + session + (timedout ? " timedout" : ""), new Object[0]);
        }
        if ((removed = (ServerSessionImpl)this._sessions.remove(session.getId())) == session) {
            for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                if (!(listener instanceof BayeuxServer.SessionListener)) continue;
                this.notifySessionRemoved((BayeuxServer.SessionListener)listener, session, timedout);
            }
            return ((ServerSessionImpl)session).removed(timedout);
        }
        return false;
    }

    private void notifySessionRemoved(BayeuxServer.SessionListener listener, ServerSession session, boolean timedout) {
        try {
            listener.sessionRemoved(session, timedout);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking listener " + listener, (Throwable)x);
        }
    }

    protected ServerSessionImpl newServerSession() {
        return new ServerSessionImpl(this);
    }

    public LocalSession newLocalSession(String idHint) {
        return new LocalSessionImpl(this, idHint);
    }

    public ServerMessage.Mutable newMessage() {
        return new ServerMessageImpl();
    }

    public ServerMessage.Mutable newMessage(ServerMessage tocopy) {
        ServerMessage.Mutable mutable = this.newMessage();
        for (String key : tocopy.keySet()) {
            mutable.put((Object)key, tocopy.get((Object)key));
        }
        return mutable;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this._policy = securityPolicy;
    }

    public void addExtension(BayeuxServer.Extension extension) {
        this._extensions.add(extension);
    }

    public void removeExtension(BayeuxServer.Extension extension) {
        this._extensions.remove(extension);
    }

    public void addListener(BayeuxServer.BayeuxServerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this._listeners.add(listener);
    }

    public ServerChannel getChannel(String channelId) {
        return (ServerChannel)this._channels.get(channelId);
    }

    public List<ServerChannel> getChannels() {
        return Collections.unmodifiableList(new ArrayList(this._channels.values()));
    }

    public List<ServerChannelImpl> getChannelChildren(ChannelId id) {
        ArrayList<ServerChannelImpl> children = new ArrayList<ServerChannelImpl>();
        for (ServerChannelImpl channel : this._channels.values()) {
            if (!id.isParentOf(channel.getChannelId())) continue;
            children.add(channel);
        }
        return children;
    }

    public void removeListener(BayeuxServer.BayeuxServerListener listener) {
        this._listeners.remove(listener);
    }

    public ServerMessage.Mutable handle(ServerSessionImpl session, ServerMessage.Mutable message) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(">  " + message + " " + session, new Object[0]);
        }
        ServerMessage.Mutable reply = null;
        if (!this.extendRecv(session, message) || session != null && !session.extendRecv(message)) {
            reply = this.createReply(message);
            this.error(reply, "404::message deleted");
        } else {
            String channelName;
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(">> " + message, new Object[0]);
            }
            if ((channelName = message.getChannel()) == null) {
                reply = this.createReply(message);
                this.error(reply, "400::channel missing");
            } else {
                String denyReason;
                ServerChannel channel = this.getChannel(channelName);
                if (channel == null) {
                    Authorizer.Result creationResult = this.isCreationAuthorized(session, (ServerMessage)message, channelName);
                    if (creationResult instanceof Authorizer.Result.Denied) {
                        reply = this.createReply(message);
                        denyReason = ((Authorizer.Result.Denied)creationResult).getReason();
                        this.error(reply, "403:" + denyReason + ":create denied");
                    } else {
                        this.createIfAbsent(channelName, new ConfigurableServerChannel.Initializer[0]);
                        channel = this.getChannel(channelName);
                    }
                }
                if (channel != null) {
                    if (channel.isMeta()) {
                        if (session == null && !"/meta/handshake".equals(channelName)) {
                            reply = this.createReply(message);
                            this.unknownSession(reply);
                        } else {
                            this.doPublish(session, (ServerChannelImpl)channel, message);
                            reply = message.getAssociated();
                        }
                    } else if (session == null) {
                        reply = this.createReply(message);
                        this.unknownSession(reply);
                    } else {
                        Authorizer.Result publishResult = this.isPublishAuthorized(channel, session, (ServerMessage)message);
                        if (publishResult instanceof Authorizer.Result.Denied) {
                            reply = this.createReply(message);
                            denyReason = ((Authorizer.Result.Denied)publishResult).getReason();
                            this.error(reply, "403:" + denyReason + ":publish denied");
                        } else {
                            channel.publish((Session)session, message);
                            reply = this.createReply(message);
                            reply.setSuccessful(true);
                        }
                    }
                }
            }
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("<< " + reply, new Object[0]);
        }
        return reply;
    }

    private Authorizer.Result isPublishAuthorized(ServerChannel channel, ServerSession session, ServerMessage message) {
        if (this._policy != null && !this._policy.canPublish((BayeuxServer)this, session, channel, message)) {
            this._logger.warn("{} denied Publish@{} by {}", new Object[]{session, channel.getId(), this._policy});
            return Authorizer.Result.deny((String)"denied_by_security_policy");
        }
        return this.isOperationAuthorized(Authorizer.Operation.PUBLISH, session, message, channel.getChannelId());
    }

    private Authorizer.Result isSubscribeAuthorized(ServerChannel channel, ServerSession session, ServerMessage message) {
        if (this._policy != null && !this._policy.canSubscribe((BayeuxServer)this, session, channel, message)) {
            this._logger.warn("{} denied Publish@{} by {}", new Object[]{session, channel, this._policy});
            return Authorizer.Result.deny((String)"denied_by_security_policy");
        }
        return this.isOperationAuthorized(Authorizer.Operation.SUBSCRIBE, session, message, channel.getChannelId());
    }

    private Authorizer.Result isCreationAuthorized(ServerSession session, ServerMessage message, String channel) {
        if (this._policy != null && !this._policy.canCreate((BayeuxServer)this, session, channel, message)) {
            this._logger.warn("{} denied Create@{} by {}", new Object[]{session, message.getChannel(), this._policy});
            return Authorizer.Result.deny((String)"denied_by_security_policy");
        }
        return this.isOperationAuthorized(Authorizer.Operation.CREATE, session, message, new ChannelId(channel));
    }

    private Authorizer.Result isOperationAuthorized(Authorizer.Operation operation, ServerSession session, ServerMessage message, ChannelId channelId) {
        ArrayList<ServerChannelImpl> channels = new ArrayList<ServerChannelImpl>();
        for (String wildName : channelId.getWilds()) {
            ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(wildName);
            if (channel == null) continue;
            channels.add(channel);
        }
        ServerChannelImpl candidate = (ServerChannelImpl)this._channels.get(channelId.toString());
        if (candidate != null) {
            channels.add(candidate);
        }
        boolean called = false;
        Authorizer.Result result = Authorizer.Result.ignore();
        block1: for (ServerChannel serverChannel : channels) {
            for (Authorizer authorizer : serverChannel.getAuthorizers()) {
                called = true;
                Authorizer.Result authorization = authorizer.authorize(operation, channelId, session, message);
                this._logger.debug("Authorizer {} on channel {} {} {} for channel {}", new Object[]{authorizer, serverChannel, authorization, operation, channelId});
                if (authorization instanceof Authorizer.Result.Denied) {
                    result = authorization;
                    continue block1;
                }
                if (!(authorization instanceof Authorizer.Result.Granted)) continue;
                result = authorization;
            }
        }
        if (!called) {
            result = Authorizer.Result.grant();
            this._logger.debug("No authorizers, {} for channel {} {}", new Object[]{operation, channelId, result});
        } else if (result instanceof Authorizer.Result.Ignored) {
            result = Authorizer.Result.deny((String)"denied_by_not_granting");
            this._logger.debug("No authorizer granted {} for channel {}, authorization {}", new Object[]{operation, channelId, result});
        } else if (result instanceof Authorizer.Result.Granted) {
            this._logger.debug("No authorizer denied {} for channel {}, authorization {}", new Object[]{operation, channelId, result});
        }
        assert (!(result instanceof Authorizer.Result.Ignored));
        return result;
    }

    protected void doPublish(ServerSessionImpl from, ServerChannelImpl to, ServerMessage.Mutable mutable) {
        String parent = to.getChannelId().getParent();
        while (parent != null) {
            ServerChannelImpl c = (ServerChannelImpl)this._channels.get(parent);
            if (c == null) {
                return;
            }
            if (c.isLazy()) {
                mutable.setLazy(true);
            }
            parent = c.getChannelId().getParent();
        }
        List wildIds = to.getChannelId().getWilds();
        ServerChannelImpl[] wild_channels = new ServerChannelImpl[wildIds.size()];
        int i = wildIds.size();
        while (i-- > 0) {
            wild_channels[i] = (ServerChannelImpl)this._channels.get(wildIds.get(i));
        }
        for (ServerChannelImpl channel : wild_channels) {
            if (channel == null) continue;
            if (channel.isLazy()) {
                mutable.setLazy(true);
            }
            for (ServerChannel.ServerChannelListener listener : channel.getListeners()) {
                if (!(listener instanceof ServerChannel.MessageListener) || this.notifyOnMessage((ServerChannel.MessageListener)listener, from, to, mutable)) continue;
                return;
            }
        }
        if (to.isLazy()) {
            mutable.setLazy(true);
        }
        for (ServerChannel.ServerChannelListener listener : to.getListeners()) {
            if (!(listener instanceof ServerChannel.MessageListener) || this.notifyOnMessage((ServerChannel.MessageListener)listener, from, to, mutable)) continue;
            return;
        }
        ((ServerMessageImpl)mutable).freeze();
        HashSet<String> wild_subscribers = null;
        for (ServerChannelImpl channel : wild_channels) {
            if (channel == null) continue;
            for (ServerSession session : channel.getSubscribers()) {
                if (wild_subscribers == null) {
                    wild_subscribers = new HashSet<String>();
                }
                if (!wild_subscribers.add(session.getId())) continue;
                ((ServerSessionImpl)session).doDeliver(from, mutable);
            }
        }
        for (ServerSession session : to.getSubscribers()) {
            if (wild_subscribers != null && wild_subscribers.contains(session.getId())) continue;
            ((ServerSessionImpl)session).doDeliver(from, mutable);
        }
        if (to.isMeta()) {
            for (ServerChannel.ServerChannelListener listener : to.getListeners()) {
                if (!(listener instanceof HandlerListener)) continue;
                ((HandlerListener)listener).onMessage(from, mutable);
            }
        }
    }

    private boolean notifyOnMessage(ServerChannel.MessageListener listener, ServerSession from, ServerChannel to, ServerMessage.Mutable mutable) {
        try {
            return listener.onMessage(from, to, mutable);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking listener " + listener, (Throwable)x);
            return true;
        }
    }

    public ServerMessage.Mutable extendReply(ServerSessionImpl from, ServerSessionImpl to, ServerMessage.Mutable reply) {
        if (!this.extendSend(from, to, reply)) {
            return null;
        }
        if (to != null) {
            if (reply.isMeta()) {
                if (!to.extendSendMeta(reply)) {
                    return null;
                }
            } else {
                ServerMessage newReply = to.extendSendMessage((ServerMessage)reply);
                if (newReply == null) {
                    reply = null;
                } else if (newReply != reply) {
                    reply = newReply instanceof ServerMessage.Mutable ? (ServerMessage.Mutable)newReply : this.newMessage(newReply);
                }
            }
        }
        return reply;
    }

    protected boolean extendRecv(ServerSession from, ServerMessage.Mutable message) {
        if (message.isMeta()) {
            for (BayeuxServer.Extension extension : this._extensions) {
                if (this.notifyRcvMeta(extension, from, message)) continue;
                return false;
            }
        } else {
            for (BayeuxServer.Extension extension : this._extensions) {
                if (this.notifyRcv(extension, from, message)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean notifyRcvMeta(BayeuxServer.Extension extension, ServerSession from, ServerMessage.Mutable message) {
        try {
            return extension.rcvMeta(from, message);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking extension " + extension, (Throwable)x);
            return true;
        }
    }

    private boolean notifyRcv(BayeuxServer.Extension extension, ServerSession from, ServerMessage.Mutable message) {
        try {
            return extension.rcv(from, message);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking extension " + extension, (Throwable)x);
            return true;
        }
    }

    protected boolean extendSend(ServerSession from, ServerSession to, ServerMessage.Mutable message) {
        if (message.isMeta()) {
            ListIterator<BayeuxServer.Extension> i = this._extensions.listIterator(this._extensions.size());
            while (i.hasPrevious()) {
                BayeuxServer.Extension extension = i.previous();
                if (this.notifySendMeta(extension, to, message)) continue;
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Extension {} interrupted message processing for {}", new Object[]{extension, message});
                }
                return false;
            }
        } else {
            ListIterator<BayeuxServer.Extension> i = this._extensions.listIterator(this._extensions.size());
            while (i.hasPrevious()) {
                BayeuxServer.Extension extension = i.previous();
                if (this.notifySend(extension, from, to, message)) continue;
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Extension {} interrupted message processing for {}", new Object[]{extension, message});
                }
                return false;
            }
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("<  " + message, new Object[0]);
        }
        return true;
    }

    private boolean notifySendMeta(BayeuxServer.Extension extension, ServerSession to, ServerMessage.Mutable message) {
        try {
            return extension.sendMeta(to, message);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking extension " + extension, (Throwable)x);
            return true;
        }
    }

    private boolean notifySend(BayeuxServer.Extension extension, ServerSession from, ServerSession to, ServerMessage.Mutable message) {
        try {
            return extension.send(from, to, message);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking extension " + extension, (Throwable)x);
            return true;
        }
    }

    protected boolean removeServerChannel(ServerChannelImpl channel) {
        if (this._channels.remove(channel.getId(), channel)) {
            this._logger.debug("removed {}", new Object[]{channel});
            for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                if (!(listener instanceof BayeuxServer.ChannelListener)) continue;
                this.notifyChannelRemoved((BayeuxServer.ChannelListener)listener, channel);
            }
            return true;
        }
        return false;
    }

    private void notifyChannelRemoved(BayeuxServer.ChannelListener listener, ServerChannelImpl channel) {
        try {
            listener.channelRemoved(channel.getId());
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking listener " + listener, (Throwable)x);
        }
    }

    protected List<BayeuxServer.BayeuxServerListener> getListeners() {
        return Collections.unmodifiableList(this._listeners);
    }

    public Set<String> getKnownTransportNames() {
        return this._transports.keySet();
    }

    public ServerTransport getTransport(String transport) {
        return (ServerTransport)this._transports.get(transport);
    }

    public void addTransport(ServerTransport transport) {
        this._transports.put(transport.getName(), transport);
    }

    public void setTransports(ServerTransport ... transports) {
        this.setTransports(Arrays.asList(transports));
    }

    public void setTransports(List<ServerTransport> transports) {
        this._transports.clear();
        for (ServerTransport transport : transports) {
            this.addTransport(transport);
        }
    }

    public List<String> getAllowedTransports() {
        return Collections.unmodifiableList(this._allowedTransports);
    }

    public void setAllowedTransports(String ... allowed) {
        this.setAllowedTransports(Arrays.asList(allowed));
    }

    public void setAllowedTransports(List<String> allowed) {
        this._allowedTransports.clear();
        for (String transport : allowed) {
            if (!this._transports.containsKey(transport)) continue;
            this._allowedTransports.add(transport);
        }
    }

    protected void unknownSession(ServerMessage.Mutable reply) {
        this.error(reply, "402::Unknown client");
        if ("/meta/handshake".equals(reply.getChannel()) || "/meta/connect".equals(reply.getChannel())) {
            reply.put((Object)"advice", this._handshakeAdvice);
        }
    }

    protected void error(ServerMessage.Mutable reply, String error) {
        reply.put((Object)"error", (Object)error);
        reply.setSuccessful(false);
    }

    protected ServerMessage.Mutable createReply(ServerMessage.Mutable message) {
        ServerMessage.Mutable reply = this.newMessage();
        message.setAssociated(reply);
        reply.setAssociated(message);
        reply.setChannel(message.getChannel());
        String id = message.getId();
        if (id != null) {
            reply.setId(id);
        }
        return reply;
    }

    public void doSweep() {
        for (ServerChannelImpl channel : this._channels.values()) {
            channel.doSweep();
        }
        for (ServerTransport transport : this._transports.values()) {
            if (!(transport instanceof AbstractServerTransport)) continue;
            ((AbstractServerTransport)transport).doSweep();
        }
    }

    public String dump() {
        StringBuilder b = new StringBuilder();
        ArrayList<Object> children = new ArrayList<Object>();
        if (this._policy != null) {
            children.add(this._policy);
        }
        for (ServerChannelImpl channel : this._channels.values()) {
            if (channel.getChannelId().depth() != 1) continue;
            children.add(channel);
        }
        int leaves = children.size();
        int i = 0;
        for (Object e : children) {
            b.append(" +-");
            if (e instanceof ServerChannelImpl) {
                ((ServerChannelImpl)e).dump(b, ++i == leaves ? "   " : " | ");
                continue;
            }
            b.append(e.toString()).append("\n");
        }
        return b.toString();
    }

    private class DisconnectHandler
    extends HandlerListener {
        private DisconnectHandler() {
        }

        public void onMessage(ServerSessionImpl session, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (this.isSessionUnknown(session)) {
                BayeuxServerImpl.this.unknownSession(reply);
                return;
            }
            BayeuxServerImpl.this.removeServerSession(session, false);
            session.flush();
            reply.setSuccessful(true);
        }
    }

    private class UnsubscribeHandler
    extends HandlerListener {
        private UnsubscribeHandler() {
        }

        public void onMessage(ServerSessionImpl from, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (this.isSessionUnknown(from)) {
                BayeuxServerImpl.this.unknownSession(reply);
                return;
            }
            Object subscriptionField = message.get((Object)"subscription");
            reply.put((Object)"subscription", subscriptionField);
            ArrayList<String> subscriptions = new ArrayList<String>();
            if (subscriptionField == null) {
                BayeuxServerImpl.this.error(reply, "403::subscription_missing");
                return;
            }
            if (subscriptionField instanceof Object[]) {
                for (Object subscription : (Object[])subscriptionField) {
                    if (subscription == null || !(subscription instanceof String)) {
                        BayeuxServerImpl.this.error(reply, "403::subscription_invalid");
                        return;
                    }
                    subscriptions.add((String)subscription);
                }
            } else {
                if (!(subscriptionField instanceof String)) {
                    BayeuxServerImpl.this.error(reply, "403::subscription_invalid");
                    return;
                }
                subscriptions.add((String)subscriptionField);
            }
            for (String subscription : subscriptions) {
                ServerChannelImpl channel = (ServerChannelImpl)BayeuxServerImpl.this.getChannel(subscription);
                if (channel == null) {
                    BayeuxServerImpl.this.error(reply, "400::channel_missing");
                    break;
                }
                if (channel.unsubscribe((ServerSession)from)) {
                    reply.setSuccessful(true);
                    continue;
                }
                BayeuxServerImpl.this.error(reply, "403::unsubscribe_failed");
                break;
            }
        }
    }

    private class SubscribeHandler
    extends HandlerListener {
        private SubscribeHandler() {
        }

        public void onMessage(ServerSessionImpl from, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (this.isSessionUnknown(from)) {
                BayeuxServerImpl.this.unknownSession(reply);
                return;
            }
            Object subscriptionField = message.get((Object)"subscription");
            reply.put((Object)"subscription", subscriptionField);
            ArrayList<String> subscriptions = new ArrayList<String>();
            if (subscriptionField == null) {
                BayeuxServerImpl.this.error(reply, "403::subscription_missing");
                return;
            }
            if (subscriptionField instanceof Object[]) {
                for (Object subscription : (Object[])subscriptionField) {
                    if (subscription == null || !(subscription instanceof String)) {
                        BayeuxServerImpl.this.error(reply, "403::subscription_invalid");
                        return;
                    }
                    subscriptions.add((String)subscription);
                }
            } else {
                if (!(subscriptionField instanceof String)) {
                    BayeuxServerImpl.this.error(reply, "403::subscription_invalid");
                    return;
                }
                subscriptions.add((String)subscriptionField);
            }
            for (String subscription : subscriptions) {
                ServerChannelImpl channel = (ServerChannelImpl)BayeuxServerImpl.this.getChannel(subscription);
                if (channel == null) {
                    Authorizer.Result creationResult = BayeuxServerImpl.this.isCreationAuthorized(from, (ServerMessage)message, subscription);
                    if (creationResult instanceof Authorizer.Result.Denied) {
                        String denyReason = ((Authorizer.Result.Denied)creationResult).getReason();
                        BayeuxServerImpl.this.error(reply, "403:" + denyReason + ":create_denied");
                        break;
                    }
                    BayeuxServerImpl.this.createIfAbsent(subscription, new ConfigurableServerChannel.Initializer[0]);
                    channel = (ServerChannelImpl)BayeuxServerImpl.this.getChannel(subscription);
                }
                if (channel == null) continue;
                Authorizer.Result subscribeResult = BayeuxServerImpl.this.isSubscribeAuthorized(channel, from, (ServerMessage)message);
                if (subscribeResult instanceof Authorizer.Result.Denied) {
                    String denyReason = ((Authorizer.Result.Denied)subscribeResult).getReason();
                    BayeuxServerImpl.this.error(reply, "403:" + denyReason + ":subscribe_denied");
                    break;
                }
                if (!this.isSessionUnknown(from)) {
                    if (channel.subscribe((ServerSession)from)) {
                        reply.setSuccessful(true);
                        continue;
                    }
                    BayeuxServerImpl.this.error(reply, "403::subscribe_failed");
                    break;
                }
                BayeuxServerImpl.this.unknownSession(reply);
                break;
            }
        }
    }

    private class ConnectHandler
    extends HandlerListener {
        private ConnectHandler() {
        }

        public void onMessage(ServerSessionImpl session, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (this.isSessionUnknown(session)) {
                BayeuxServerImpl.this.unknownSession(reply);
                return;
            }
            session.connect();
            Map adviceIn = message.getAdvice();
            if (adviceIn != null) {
                Long timeout = (Long)adviceIn.get("timeout");
                session.updateTransientTimeout(timeout == null ? -1L : timeout);
                Long interval = (Long)adviceIn.get("interval");
                session.updateTransientInterval(interval == null ? -1L : interval);
                session.reAdvise();
            } else {
                session.updateTransientTimeout(-1L);
                session.updateTransientInterval(-1L);
            }
            Object adviceOut = session.takeAdvice();
            if (adviceOut != null) {
                reply.put((Object)"advice", adviceOut);
            }
            reply.setSuccessful(true);
        }
    }

    private class HandshakeHandler
    extends HandlerListener {
        private HandshakeHandler() {
        }

        public void onMessage(ServerSessionImpl session, ServerMessage.Mutable message) {
            if (session == null) {
                session = BayeuxServerImpl.this.newServerSession();
            }
            ServerMessage.Mutable reply = BayeuxServerImpl.this.createReply(message);
            if (BayeuxServerImpl.this._policy != null && !BayeuxServerImpl.this._policy.canHandshake((BayeuxServer)BayeuxServerImpl.this, (ServerSession)session, (ServerMessage)message)) {
                BayeuxServerImpl.this.error(reply, "403::Handshake denied");
                Map advice = reply.getAdvice(true);
                if (!advice.containsKey("reconnect")) {
                    advice.put("reconnect", "none");
                }
                return;
            }
            session.handshake();
            BayeuxServerImpl.this.addServerSession(session);
            reply.setSuccessful(true);
            reply.put((Object)"clientId", (Object)session.getId());
            reply.put((Object)"version", (Object)"1.0");
            reply.put((Object)"minimumVersion", (Object)"1.0");
            reply.put((Object)"supportedConnectionTypes", BayeuxServerImpl.this.getAllowedTransports());
        }
    }

    abstract class HandlerListener
    implements ServerChannel.ServerChannelListener {
        HandlerListener() {
        }

        protected boolean isSessionUnknown(ServerSession session) {
            return session == null || BayeuxServerImpl.this.getSession(session.getId()) == null;
        }

        public abstract void onMessage(ServerSessionImpl var1, ServerMessage.Mutable var2);
    }
}

